/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rocksdb.flush;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.ignite.internal.rocksdb.flush.RocksDbFlusher;
import org.rocksdb.AbstractEventListener;
import org.rocksdb.FlushJobInfo;
import org.rocksdb.RocksDB;

class RocksDbFlushListener
extends AbstractEventListener {
    private final RocksDbFlusher flusher;
    private final AtomicReference<AbstractEventListener.EnabledEventCallback> lastEventType = new AtomicReference<AbstractEventListener.EnabledEventCallback>(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED);
    private volatile CompletableFuture<?> lastFlushProcessed = CompletableFuture.completedFuture(null);

    RocksDbFlushListener(RocksDbFlusher flusher) {
        super(new AbstractEventListener.EnabledEventCallback[]{AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED});
        this.flusher = flusher;
    }

    public void onFlushBegin(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED, AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN)) {
            this.lastFlushProcessed.join();
        }
    }

    public void onFlushCompleted(RocksDB db, FlushJobInfo flushJobInfo) {
        if (this.lastEventType.compareAndSet(AbstractEventListener.EnabledEventCallback.ON_FLUSH_BEGIN, AbstractEventListener.EnabledEventCallback.ON_FLUSH_COMPLETED)) {
            this.lastFlushProcessed = this.flusher.onFlushCompleted();
        }
        this.lastFlushProcessed.whenCompleteAsync((o, throwable) -> this.flusher.completeFutures(flushJobInfo.getLargestSeqno()), (Executor)this.flusher.threadPool);
    }
}

