/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.processors.query.calcite.prepare;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.fun.SqlCase;
import org.apache.calcite.sql.fun.SqlLibraryOperators;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.util.Static;

public class IgniteSqlCallRewriteTable {
    public static final IgniteSqlCallRewriteTable INSTANCE = new IgniteSqlCallRewriteTable();
    private final Map<String, BiFunction<SqlValidator, SqlCall, SqlCall>> map = new ConcurrentHashMap<String, BiFunction<SqlValidator, SqlCall, SqlCall>>();

    private IgniteSqlCallRewriteTable() {
        this.register(SqlLibraryOperators.NVL.getName(), IgniteSqlCallRewriteTable::nvlRewriter);
        this.register(SqlLibraryOperators.DECODE.getName(), IgniteSqlCallRewriteTable::decodeRewriter);
    }

    public void register(String operatorName, BiFunction<SqlValidator, SqlCall, SqlCall> rewriter) {
        this.map.put(operatorName, rewriter);
    }

    SqlCall rewrite(SqlValidator validator, SqlCall call) {
        BiFunction<SqlValidator, SqlCall, SqlCall> rewriter = this.map.get(call.getOperator().getName());
        return rewriter == null ? call : rewriter.apply(validator, call);
    }

    private static SqlCall nvlRewriter(SqlValidator validator, SqlCall call) {
        IgniteSqlCallRewriteTable.validateQuantifier(validator, call);
        List operands = call.getOperandList();
        if (operands.size() == 2) {
            SqlParserPos pos = call.getParserPosition();
            SqlNodeList whenList = new SqlNodeList(pos);
            SqlNodeList thenList = new SqlNodeList(pos);
            whenList.add((SqlNode)SqlStdOperatorTable.IS_NOT_NULL.createCall(pos, new SqlNode[]{(SqlNode)operands.get(0)}));
            thenList.add(SqlNode.clone((SqlNode)((SqlNode)operands.get(0))));
            SqlNode elseExpr = (SqlNode)operands.get(1);
            return SqlCase.createSwitched((SqlParserPos)pos, null, (SqlNodeList)whenList, (SqlNodeList)thenList, (SqlNode)elseExpr);
        }
        return call;
    }

    private static SqlCall decodeRewriter(SqlValidator validator, SqlCall call) {
        IgniteSqlCallRewriteTable.validateQuantifier(validator, call);
        List operands = call.getOperandList();
        SqlParserPos pos = call.getParserPosition();
        SqlNode op0 = (SqlNode)operands.get(0);
        SqlNodeList whenList = new SqlNodeList(pos);
        SqlNodeList thenList = new SqlNodeList(pos);
        for (int i = 1; i < operands.size() - 1; i += 2) {
            whenList.add((SqlNode)SqlStdOperatorTable.IS_NOT_DISTINCT_FROM.createCall(pos, new SqlNode[]{SqlNode.clone((SqlNode)op0), (SqlNode)operands.get(i)}));
            thenList.add((SqlNode)operands.get(i + 1));
        }
        SqlNode elseExpr = operands.size() % 2 == 0 ? (SqlNode)operands.get(operands.size() - 1) : null;
        return SqlCase.createSwitched((SqlParserPos)pos, null, (SqlNodeList)whenList, (SqlNodeList)thenList, (SqlNode)elseExpr);
    }

    private static void validateQuantifier(SqlValidator validator, SqlCall call) {
        if (call.getFunctionQuantifier() != null) {
            throw validator.newValidationError((SqlNode)call.getFunctionQuantifier(), Static.RESOURCE.functionQuantifierNotAllowed(call.getOperator().getName()));
        }
    }
}

