/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.core5.http.protocol;

import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.net.ssl.SSLSession;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.EntityDetails;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpRequestInterceptor;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.http.Method;
import org.apache.hc.core5.http.MisdirectedRequestException;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.ProtocolVersion;
import org.apache.hc.core5.http.io.entity.BasicHttpEntity;
import org.apache.hc.core5.http.io.entity.EmptyInputStream;
import org.apache.hc.core5.http.io.entity.HttpEntities;
import org.apache.hc.core5.http.io.entity.StringEntity;
import org.apache.hc.core5.http.message.BasicClassicHttpRequest;
import org.apache.hc.core5.http.message.BasicClassicHttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.protocol.HttpCoreContext;
import org.apache.hc.core5.http.protocol.RequestConformance;
import org.apache.hc.core5.http.protocol.RequestConnControl;
import org.apache.hc.core5.http.protocol.RequestContent;
import org.apache.hc.core5.http.protocol.RequestDate;
import org.apache.hc.core5.http.protocol.RequestExpectContinue;
import org.apache.hc.core5.http.protocol.RequestTargetHost;
import org.apache.hc.core5.http.protocol.RequestUserAgent;
import org.apache.hc.core5.http.protocol.RequestValidateHost;
import org.apache.hc.core5.http.protocol.ResponseConformance;
import org.apache.hc.core5.http.protocol.ResponseConnControl;
import org.apache.hc.core5.http.protocol.ResponseContent;
import org.apache.hc.core5.http.protocol.ResponseDate;
import org.apache.hc.core5.http.protocol.ResponseServer;
import org.apache.hc.core5.net.URIAuthority;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

class TestStandardInterceptors {
    TestStandardInterceptors() {
    }

    @Test
    void testRequestConnControlGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestConnControl.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"keep-alive", (Object)header.getValue());
    }

    @Test
    void testRequestConnControlConnectMethod() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.CONNECT, "/");
        HttpRequestInterceptor interceptor = RequestConnControl.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestConnControlCustom() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        BasicHeader myheader = new BasicHeader("Connection", (Object)"close");
        request.addHeader((Header)myheader);
        HttpRequestInterceptor interceptor = RequestConnControl.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"close", (Object)header.getValue());
        Assertions.assertSame((Object)header, (Object)myheader);
    }

    @Test
    void testRequestConnControlUpgrade() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader("Upgrade", (Object)"HTTP/2");
        HttpRequestInterceptor interceptor = RequestConnControl.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"upgrade", (Object)header.getValue());
    }

    @Test
    void testRequestConnControlInvalidInput() {
        HttpRequestInterceptor interceptor = RequestConnControl.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestContentProtocolException() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request1 = new BasicClassicHttpRequest(Method.POST, "/");
        request1.addHeader((Header)new BasicHeader("Transfer-Encoding", (Object)"chunked"));
        BasicClassicHttpRequest request2 = new BasicClassicHttpRequest(Method.POST, "/");
        request2.addHeader((Header)new BasicHeader("Content-Length", (Object)"12"));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request1, (EntityDetails)request1.getEntity(), (HttpContext)context));
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request2, (EntityDetails)request2.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestContentNullEntity() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((int)0, (int)Integer.parseInt(header.getValue()));
        Assertions.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    void testRequestContentNullEntityNonEnclosingMethod() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)header);
        Assertions.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    void testRequestContentEntityContentLengthDelimitedHTTP11() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("whatever", StandardCharsets.US_ASCII));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((int)8, (int)Integer.parseInt(header.getValue()));
        Assertions.assertNull((Object)request.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    void testRequestContentEntityChunkedHTTP11() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("whatever", StandardCharsets.US_ASCII, true));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"chunked", (Object)header.getValue());
        Assertions.assertNull((Object)request.getFirstHeader("Content-Length"));
    }

    @Test
    void testRequestContentEntityUnknownLengthHTTP11() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, -1L, null));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"chunked", (Object)header.getValue());
        Assertions.assertNull((Object)request.getFirstHeader("Content-Length"));
    }

    @Test
    void testRequestContentEntityChunkedHTTP10() {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("whatever", StandardCharsets.US_ASCII, true));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestContentTypeAndEncoding() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, ContentType.parseLenient((CharSequence)"whatever"), "whatever"));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h1 = request.getFirstHeader("Content-Type");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"whatever", (Object)h1.getValue());
        Header h2 = request.getFirstHeader("Content-Encoding");
        Assertions.assertNotNull((Object)h2);
        Assertions.assertEquals((Object)"whatever", (Object)h2.getValue());
    }

    @Test
    void testRequestContentNullTypeAndEncoding() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null, null));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertNull((Object)request.getFirstHeader("Content-Type"));
        Assertions.assertNull((Object)request.getFirstHeader("Content-Encoding"));
    }

    @Test
    void testRequestContentEntityUnknownLengthHTTP10() {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, -1L, null));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestContentInvalidInput() {
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestContentIgnoreNonenclosingRequests() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((int)1, (int)request.getHeaders().length);
    }

    @Test
    void testRequestContentOverwriteHeaders() throws Exception {
        RequestContent interceptor = new RequestContent(true);
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.addHeader((Header)new BasicHeader("Content-Length", (Object)"10"));
        request.addHeader((Header)new BasicHeader("Transfer-Encoding", (Object)"whatever"));
        request.setEntity((HttpEntity)new StringEntity(""));
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h1 = request.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"0", (Object)h1.getValue());
    }

    @Test
    void testRequestContentAddHeaders() throws Exception {
        RequestContent interceptor = new RequestContent(true);
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity(""));
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h1 = request.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"0", (Object)h1.getValue());
        Header h2 = request.getFirstHeader("Transfer-Encoding");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testRequestContentEntityWithTrailers() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity(HttpEntities.create((String)"whatever", (Charset)StandardCharsets.US_ASCII, (Header[])new Header[]{new BasicHeader("h1", (Object)"this"), new BasicHeader("h1", (Object)"that"), new BasicHeader("h2", (Object)"this and that")}));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header1 = request.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)header1);
        Header header2 = request.getFirstHeader("Trailer");
        Assertions.assertNotNull((Object)header2);
        Assertions.assertEquals((Object)"h1, h2", (Object)header2.getValue());
    }

    @Test
    void testRequestContentTraceWithEntity() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.TRACE, "/");
        request.setEntity((HttpEntity)new StringEntity("stuff"));
        HttpRequestInterceptor interceptor = RequestContent.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestExpectContinueGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("whatever", StandardCharsets.US_ASCII));
        RequestExpectContinue interceptor = RequestExpectContinue.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"100-continue", (Object)header.getValue());
    }

    @Test
    void testRequestExpectContinueHTTP10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("whatever", StandardCharsets.US_ASCII));
        RequestExpectContinue interceptor = RequestExpectContinue.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestExpectContinueZeroContent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("", StandardCharsets.US_ASCII));
        RequestExpectContinue interceptor = RequestExpectContinue.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Expect");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestExpectContinueInvalidInput() {
        RequestExpectContinue interceptor = RequestExpectContinue.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestExpectContinueIgnoreNonenclosingRequests() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        RequestExpectContinue interceptor = RequestExpectContinue.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((int)0, (int)request.getHeaders().length);
    }

    @Test
    void testRequestTargetHostGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setAuthority(new URIAuthority("somehost", 8080));
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"somehost:8080", (Object)header.getValue());
    }

    @Test
    void testRequestTargetHostNotGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setAuthority(new URIAuthority("somehost", 8080));
        request.addHeader((Header)new BasicHeader("Host", (Object)"whatever"));
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"whatever", (Object)header.getValue());
    }

    @Test
    void testRequestTargetHostMissingHostHTTP10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestTargetHostMissingHostHTTP11() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestTargetHostInvalidInput() {
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process((HttpRequest)new BasicClassicHttpRequest(Method.GET, "/"), null, null));
    }

    @Test
    void testRequestTargetHostConnectHttp11() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.CONNECT, "/");
        request.setAuthority(new URIAuthority("somehost", 8080));
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"somehost:8080", (Object)header.getValue());
    }

    @Test
    void testRequestTargetHostConnectHttp10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.CONNECT, "/");
        request.setAuthority(new URIAuthority("somehost", 8080));
        HttpRequestInterceptor interceptor = RequestTargetHost.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("Host");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestUserAgentGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        RequestUserAgent interceptor = new RequestUserAgent("some agent");
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"some agent", (Object)header.getValue());
    }

    @Test
    void testRequestUserAgentNotGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("User-Agent", (Object)"whatever"));
        RequestUserAgent interceptor = new RequestUserAgent("some agent");
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"whatever", (Object)header.getValue());
    }

    @Test
    void testRequestUserAgentMissingUserAgent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestUserAgent.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header header = request.getFirstHeader("User-Agent");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testRequestUserAgentInvalidInput() {
        HttpRequestInterceptor interceptor = RequestUserAgent.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testResponseConnControlNoEntity() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseConnControlEntityContentLength() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new StringEntity("whatever"));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseConnControlEntityUnknownContentLengthExplicitKeepAlive() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
        context.setRequest((HttpRequest)request);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"keep-alive", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlEntityChunked() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null, true));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseConnControlEntityUnknownContentLengthHTTP10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
        context.setRequest((HttpRequest)request);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"close", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlClientRequest() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
        context.setRequest((HttpRequest)request);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new StringEntity("whatever"));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"keep-alive", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlClientRequest2() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setRequest((HttpRequest)request);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new StringEntity("whatever"));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseConnControl10Client11Response() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        context.setRequest((HttpRequest)request);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new StringEntity("whatever"));
        ResponseConnControl interceptor = new ResponseConnControl();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"close", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlStatusCode() throws Exception {
        int[] statusCodes;
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
        context.setRequest((HttpRequest)request);
        ResponseConnControl interceptor = new ResponseConnControl();
        for (int statusCode : statusCodes = new int[]{400, 408, 411, 413, 414, 503, 501}) {
            BasicClassicHttpResponse response = new BasicClassicHttpResponse(statusCode, "Unreasonable");
            interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
            Header header = response.getFirstHeader("Connection");
            Assertions.assertNotNull((Object)header);
            Assertions.assertEquals((Object)"close", (Object)header.getValue());
        }
    }

    @Test
    void testResponseConnControlExplicitClose() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"keep-alive"));
        context.setRequest((HttpRequest)request);
        ResponseConnControl interceptor = new ResponseConnControl();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setHeader("Connection", (Object)"close");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"close", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlClientRequestMixUp() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader((Header)new BasicHeader("Connection", (Object)"blah, keep-alive, close"));
        context.setRequest((HttpRequest)request);
        ResponseConnControl interceptor = new ResponseConnControl();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"close", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlUpgrade() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        ResponseConnControl interceptor = new ResponseConnControl();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader("Upgrade", (Object)"HTTP/2");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Connection");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"upgrade", (Object)header.getValue());
    }

    @Test
    void testResponseConnControlHostInvalidInput() {
        ResponseConnControl interceptor = new ResponseConnControl();
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        Assertions.assertThrows(NullPointerException.class, () -> TestStandardInterceptors.lambda$testResponseConnControlHostInvalidInput$13(interceptor, (ClassicHttpResponse)response));
    }

    @Test
    void testResponseContentNoEntity() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)header);
        Assertions.assertEquals((Object)"0", (Object)header.getValue());
    }

    @Test
    void testResponseContentStatusNoContent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setCode(204);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseContentStatusNotModified() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setCode(304);
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header = response.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)header);
    }

    @Test
    void testResponseContentEntityChunked() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null, true));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"chunked", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testResponseContentEntityContentLenghtDelimited() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, 10L, null));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Length");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"10", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Transfer-Encoding");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testResponseContentEntityUnknownContentLength() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"chunked", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testResponseContentEntityChunkedHTTP10() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        context.setProtocolVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null, true));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Transfer-Encoding");
        Assertions.assertNull((Object)h1);
        Header h2 = response.getFirstHeader("Content-Length");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testResponseContentEntityNoContentTypeAndEncoding() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, null));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Type");
        Assertions.assertNull((Object)h1);
        Header h2 = response.getFirstHeader("Content-Encoding");
        Assertions.assertNull((Object)h2);
    }

    @Test
    void testResponseContentEntityContentTypeAndEncoding() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity((HttpEntity)new BasicHttpEntity((InputStream)EmptyInputStream.INSTANCE, ContentType.parseLenient((CharSequence)"whatever"), "whatever"));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Content-Type");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"whatever", (Object)h1.getValue());
        Header h2 = response.getFirstHeader("Content-Encoding");
        Assertions.assertNotNull((Object)h2);
        Assertions.assertEquals((Object)"whatever", (Object)h2.getValue());
    }

    @Test
    void testResponseContentInvalidInput() {
        ResponseContent interceptor = new ResponseContent();
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testResponseContentInvalidResponseState() {
        ResponseContent interceptor = new ResponseContent();
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response1 = new BasicClassicHttpResponse(200, "OK");
        response1.addHeader((Header)new BasicHeader("Content-Length", (Object)"10"));
        Assertions.assertThrows(ProtocolException.class, () -> TestStandardInterceptors.lambda$testResponseContentInvalidResponseState$15(interceptor, (ClassicHttpResponse)response1, context));
        BasicClassicHttpResponse response2 = new BasicClassicHttpResponse(200, "OK");
        response2.addHeader((Header)new BasicHeader("Transfer-Encoding", (Object)"stuff"));
        Assertions.assertThrows(ProtocolException.class, () -> TestStandardInterceptors.lambda$testResponseContentInvalidResponseState$16(interceptor, (ClassicHttpResponse)response2, context));
    }

    @Test
    void testResponseContentOverwriteHeaders() throws Exception {
        ResponseContent interceptor = new ResponseContent(true);
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader((Header)new BasicHeader("Content-Length", (Object)"10"));
        response.addHeader((Header)new BasicHeader("Transfer-Encoding", (Object)"whatever"));
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"0", (Object)response.getFirstHeader("Content-Length").getValue());
    }

    @Test
    void testResponseContentAddHeaders() throws Exception {
        ResponseContent interceptor = new ResponseContent(true);
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)"0", (Object)response.getFirstHeader("Content-Length").getValue());
        Assertions.assertNull((Object)response.getFirstHeader("Transfer-Encoding"));
    }

    @Test
    void testResponseContentEntityWithTrailers() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setEntity(HttpEntities.create((String)"whatever", (Charset)StandardCharsets.US_ASCII, (Header[])new Header[]{new BasicHeader("h1", (Object)"this"), new BasicHeader("h1", (Object)"that"), new BasicHeader("h2", (Object)"this and that")}));
        ResponseContent interceptor = new ResponseContent();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header header1 = response.getFirstHeader("Transfer-Encoding");
        Assertions.assertNotNull((Object)header1);
        Header header2 = response.getFirstHeader("Trailer");
        Assertions.assertNotNull((Object)header2);
        Assertions.assertEquals((Object)"h1, h2", (Object)header2.getValue());
    }

    @Test
    void testResponseDateGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ResponseDate interceptor = new ResponseDate();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Date");
        Assertions.assertNotNull((Object)h1);
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h2 = response.getFirstHeader("Date");
        Assertions.assertNotNull((Object)h2);
    }

    @Test
    void testResponseDateNotGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.setCode(199);
        ResponseDate interceptor = new ResponseDate();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Date");
        Assertions.assertNull((Object)h1);
    }

    @Test
    void testResponseDateInvalidInput() {
        ResponseDate interceptor = new ResponseDate();
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestDateGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.POST, "/");
        request.setEntity((HttpEntity)new StringEntity("stuff"));
        HttpRequestInterceptor interceptor = RequestDate.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h1 = request.getFirstHeader("Date");
        Assertions.assertNotNull((Object)h1);
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h2 = request.getFirstHeader("Date");
        Assertions.assertNotNull((Object)h2);
    }

    @Test
    void testRequestDateNotGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        HttpRequestInterceptor interceptor = RequestDate.INSTANCE;
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Header h1 = request.getFirstHeader("Date");
        Assertions.assertNull((Object)h1);
    }

    @Test
    void testRequestDateInvalidInput() {
        HttpRequestInterceptor interceptor = RequestDate.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testResponseServerGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ResponseServer interceptor = new ResponseServer("some server");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"some server", (Object)h1.getValue());
    }

    @Test
    void testResponseServerNotGenerated() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        response.addHeader((Header)new BasicHeader("Server", (Object)"whatever"));
        ResponseServer interceptor = new ResponseServer("some server");
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assertions.assertNotNull((Object)h1);
        Assertions.assertEquals((Object)"whatever", (Object)h1.getValue());
    }

    @Test
    void testResponseServerMissing() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(200, "OK");
        ResponseServer interceptor = new ResponseServer();
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
        Header h1 = response.getFirstHeader("Server");
        Assertions.assertNull((Object)h1);
    }

    @Test
    void testResponseServerInvalidInput() {
        ResponseServer interceptor = new ResponseServer();
        Assertions.assertThrows(NullPointerException.class, () -> interceptor.process(null, null, null));
    }

    @Test
    void testRequestHttp10HostHeaderAbsent() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_0);
        RequestValidateHost interceptor = new RequestValidateHost();
        Assertions.assertDoesNotThrow(() -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestHttpHostHeader() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("Host", (Object)"host:8888");
        RequestValidateHost interceptor = new RequestValidateHost();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)new URIAuthority("host", 8888), (Object)request.getAuthority());
    }

    @Test
    void testRequestHttpHostHeaderNoPort() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setVersion((ProtocolVersion)HttpVersion.HTTP_1_1);
        request.setHeader("Host", (Object)"host");
        RequestValidateHost interceptor = new RequestValidateHost();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)new URIAuthority("host"), (Object)request.getAuthority());
    }

    @Test
    void testRequestHttp11HostHeaderPresent() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setHeader("Host", (Object)"blah");
        RequestValidateHost interceptor = new RequestValidateHost();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
    }

    @Test
    void testRequestHttp11HostHeaderAbsent() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        RequestValidateHost interceptor = new RequestValidateHost();
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestHttp11MultipleHostHeaders() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.addHeader("Host", (Object)"blah");
        request.addHeader("Host", (Object)"blah");
        RequestValidateHost interceptor = new RequestValidateHost();
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestAbsoluteRequestURITakesPrecedenceOverHostHeader() throws Exception {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "https://somehost/blah?huh");
        request.setHeader("Host", (Object)"blah");
        RequestValidateHost interceptor = new RequestValidateHost();
        interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context);
        Assertions.assertEquals((Object)new URIAuthority("somehost"), (Object)request.getAuthority());
    }

    @Test
    void testRequestConformance() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setScheme("http");
        request.setAuthority(new URIAuthority("somehost", 8888));
        request.setPath("/path");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertDoesNotThrow(() -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestConformanceSchemeMissing() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setAuthority(new URIAuthority("somehost", 8888));
        request.setPath("/path");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestConformancePathMissing() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setScheme("http");
        request.setAuthority(new URIAuthority("somehost", 8888));
        request.setPath("");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestConformanceHostMissing() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setScheme("http");
        request.setAuthority(new URIAuthority("", -1));
        request.setPath("/path");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertThrows(ProtocolException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestConformanceHttps() {
        HttpCoreContext context = HttpCoreContext.create();
        context.setSSLSession((SSLSession)Mockito.mock(SSLSession.class));
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setScheme("https");
        request.setAuthority(new URIAuthority("somehost", 8888));
        request.setPath("/path");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertDoesNotThrow(() -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testRequestConformanceHttpsInsecureConnection() {
        HttpCoreContext context = HttpCoreContext.create();
        context.setSSLSession(null);
        BasicClassicHttpRequest request = new BasicClassicHttpRequest(Method.GET, "/");
        request.setScheme("https");
        request.setAuthority(new URIAuthority("somehost", 8888));
        request.setPath("/path");
        RequestConformance interceptor = new RequestConformance();
        Assertions.assertThrows(MisdirectedRequestException.class, () -> interceptor.process((HttpRequest)request, (EntityDetails)request.getEntity(), (HttpContext)context));
    }

    @Test
    void testResponseConformanceNoContent() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(204, "No Content");
        ResponseConformance interceptor = new ResponseConformance();
        Assertions.assertDoesNotThrow(() -> TestStandardInterceptors.lambda$testResponseConformanceNoContent$29(interceptor, (ClassicHttpResponse)response, context));
    }

    @Test
    void testResponseConformanceNotModified() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(304, "Not Modified");
        ResponseConformance interceptor = new ResponseConformance();
        Assertions.assertDoesNotThrow(() -> TestStandardInterceptors.lambda$testResponseConformanceNotModified$30(interceptor, (ClassicHttpResponse)response, context));
    }

    @Test
    void testResponseConformanceNoContentWithEntity() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(204, "No Content");
        response.setEntity((HttpEntity)new StringEntity("stuff"));
        ResponseConformance interceptor = new ResponseConformance();
        Assertions.assertThrows(ProtocolException.class, () -> TestStandardInterceptors.lambda$testResponseConformanceNoContentWithEntity$31(interceptor, (ClassicHttpResponse)response, context));
    }

    @Test
    void testResponseConformanceNotModifiedWithEntity() {
        HttpCoreContext context = HttpCoreContext.create();
        BasicClassicHttpResponse response = new BasicClassicHttpResponse(304, "Not Modified");
        response.setEntity((HttpEntity)new StringEntity("stuff"));
        ResponseConformance interceptor = new ResponseConformance();
        Assertions.assertThrows(ProtocolException.class, () -> TestStandardInterceptors.lambda$testResponseConformanceNotModifiedWithEntity$32(interceptor, (ClassicHttpResponse)response, context));
    }

    private static /* synthetic */ void lambda$testResponseConformanceNotModifiedWithEntity$32(ResponseConformance interceptor, ClassicHttpResponse response, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseConformanceNoContentWithEntity$31(ResponseConformance interceptor, ClassicHttpResponse response, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseConformanceNotModified$30(ResponseConformance interceptor, ClassicHttpResponse response, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseConformanceNoContent$29(ResponseConformance interceptor, ClassicHttpResponse response, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response, (EntityDetails)response.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseContentInvalidResponseState$16(ResponseContent interceptor, ClassicHttpResponse response2, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response2, (EntityDetails)response2.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseContentInvalidResponseState$15(ResponseContent interceptor, ClassicHttpResponse response1, HttpCoreContext context) throws Throwable {
        interceptor.process((HttpResponse)response1, (EntityDetails)response1.getEntity(), (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testResponseConnControlHostInvalidInput$13(ResponseConnControl interceptor, ClassicHttpResponse response) throws Throwable {
        interceptor.process((HttpResponse)response, null, null);
    }
}

