/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.bq;

import com.google.cloud.bigquery.BigQuery;
import com.google.cloud.bigquery.BigQueryOptions;
import com.google.cloud.bigquery.Field;
import com.google.cloud.bigquery.FieldList;
import com.google.cloud.bigquery.Schema;
import com.google.cloud.bigquery.Table;
import com.google.cloud.bigquery.TableDefinition;
import org.apache.commons.lang.StringUtils;
import org.apache.hop.beam.core.fn.BQSchemaAndRecordToHopFn;
import org.apache.hop.beam.transforms.bq.BQField;
import org.apache.hop.beam.transforms.bq.BeamBQInputMeta;
import org.apache.hop.core.Const;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaFactory;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.variables.Variables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class BeamBQInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = BeamBQInputDialog.class;
    private final BeamBQInputMeta input;
    int middle;
    int margin;
    private TextVar wProjectId;
    private TextVar wDatasetId;
    private TextVar wTableId;
    private TextVar wQuery;
    private TableView wFields;

    public BeamBQInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (BeamBQInputMeta)in;
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.DialogTitle", (String[])new String[0]));
        this.middle = this.props.getMiddlePct();
        this.margin = 4;
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"System.Label.TransformName", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.top = new FormAttachment(0, this.margin);
        this.fdlTransformName.right = new FormAttachment(this.middle, -this.margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(this.middle, 0);
        this.fdTransformName.top = new FormAttachment((Control)this.wlTransformName, 0, 0x1000000);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Text lastControl = this.wTransformName;
        Label wlProjectId = new Label((Composite)this.shell, 131072);
        wlProjectId.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.ProjectId", (String[])new String[0]));
        this.props.setLook((Control)wlProjectId);
        FormData fdlProjectId = new FormData();
        fdlProjectId.left = new FormAttachment(0, 0);
        fdlProjectId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlProjectId.right = new FormAttachment(this.middle, -this.margin);
        wlProjectId.setLayoutData((Object)fdlProjectId);
        this.wProjectId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wProjectId);
        FormData fdProjectId = new FormData();
        fdProjectId.left = new FormAttachment(this.middle, 0);
        fdProjectId.top = new FormAttachment((Control)wlProjectId, 0, 0x1000000);
        fdProjectId.right = new FormAttachment(100, 0);
        this.wProjectId.setLayoutData((Object)fdProjectId);
        lastControl = this.wProjectId;
        Label wlDatasetId = new Label((Composite)this.shell, 131072);
        wlDatasetId.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.DatasetId", (String[])new String[0]));
        this.props.setLook((Control)wlDatasetId);
        FormData fdlDatasetId = new FormData();
        fdlDatasetId.left = new FormAttachment(0, 0);
        fdlDatasetId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlDatasetId.right = new FormAttachment(this.middle, -this.margin);
        wlDatasetId.setLayoutData((Object)fdlDatasetId);
        this.wDatasetId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDatasetId);
        FormData fdDatasetId = new FormData();
        fdDatasetId.left = new FormAttachment(this.middle, 0);
        fdDatasetId.top = new FormAttachment((Control)wlDatasetId, 0, 0x1000000);
        fdDatasetId.right = new FormAttachment(100, 0);
        this.wDatasetId.setLayoutData((Object)fdDatasetId);
        lastControl = this.wDatasetId;
        Label wlTableId = new Label((Composite)this.shell, 131072);
        wlTableId.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.TableId", (String[])new String[0]));
        this.props.setLook((Control)wlTableId);
        FormData fdlTableId = new FormData();
        fdlTableId.left = new FormAttachment(0, 0);
        fdlTableId.top = new FormAttachment((Control)lastControl, this.margin);
        fdlTableId.right = new FormAttachment(this.middle, -this.margin);
        wlTableId.setLayoutData((Object)fdlTableId);
        this.wTableId = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wTableId);
        FormData fdTableId = new FormData();
        fdTableId.left = new FormAttachment(this.middle, 0);
        fdTableId.top = new FormAttachment((Control)wlTableId, 0, 0x1000000);
        fdTableId.right = new FormAttachment(100, 0);
        this.wTableId.setLayoutData((Object)fdTableId);
        lastControl = this.wTableId;
        Label wlQuery = new Label((Composite)this.shell, 16384);
        wlQuery.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.Query", (String[])new String[0]));
        this.props.setLook((Control)wlQuery);
        FormData fdlQuery = new FormData();
        fdlQuery.left = new FormAttachment(0, 0);
        fdlQuery.top = new FormAttachment((Control)lastControl, this.margin);
        fdlQuery.right = new FormAttachment(100, 0);
        wlQuery.setLayoutData((Object)fdlQuery);
        this.wQuery = new TextVar(this.variables, (Composite)this.shell, 17154);
        this.props.setLook((Control)this.wQuery, 1);
        FormData fdQuery = new FormData();
        fdQuery.left = new FormAttachment(0, 0);
        fdQuery.top = new FormAttachment((Control)wlQuery, this.margin);
        fdQuery.right = new FormAttachment(100, 0);
        fdQuery.bottom = new FormAttachment((Control)wlQuery, 250);
        this.wQuery.setLayoutData((Object)fdQuery);
        lastControl = this.wQuery;
        Label wlFields = new Label((Composite)this.shell, 16384);
        wlFields.setText(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.Fields", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)lastControl, this.margin);
        fdlFields.right = new FormAttachment(this.middle, -this.margin);
        wlFields.setLayoutData((Object)fdlFields);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"System.Button.GetFields", (String[])new String[0]));
        this.wGet.addListener(13, e -> this.getFields());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, this.margin, null);
        ColumnInfo[] columns = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.Fields.Column.Name", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.Fields.Column.NewName", (String[])new String[0]), 1, false, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"BeamBQInputDialog.Fields.Column.HopType", (String[])new String[0]), 2, ValueMetaFactory.getValueMetaNames(), false)};
        this.wFields = new TableView(Variables.getADefaultVariableSpace(), (Composite)this.shell, 0, columns, this.input.getFields().size(), null, this.props);
        this.props.setLook((Control)this.wFields);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, this.margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * this.margin);
        this.wFields.setLayoutData((Object)fdFields);
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    public void getFields() {
        try {
            BeamBQInputMeta meta = new BeamBQInputMeta();
            this.getInfo(meta);
            BigQuery bigQuery = (BigQuery)BigQueryOptions.getDefaultInstance().getService();
            if (StringUtils.isNotEmpty((String)meta.getDatasetId()) && StringUtils.isNotEmpty((String)meta.getTableId())) {
                Table table = bigQuery.getTable(this.variables.resolve(meta.getDatasetId()), this.variables.resolve(meta.getTableId()), new BigQuery.TableOption[0]);
                TableDefinition definition = table.getDefinition();
                Schema schema = definition.getSchema();
                FieldList fieldList = schema.getFields();
                RowMeta rowMeta = new RowMeta();
                for (int i = 0; i < fieldList.size(); ++i) {
                    Field field = fieldList.get(i);
                    String name = field.getName();
                    String type = field.getType().name();
                    int hopType = BQSchemaAndRecordToHopFn.AvroType.valueOf(type).getHopType();
                    rowMeta.addValueMeta(ValueMetaFactory.createValueMeta((String)name, (int)hopType));
                }
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)rowMeta, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[]{3}, (int)-1, (int)-1, (boolean)true, null);
            }
        }
        catch (Exception e) {
            new ErrorDialog(this.shell, "Error", "Error getting BQ fields", e);
        }
    }

    public void getData() {
        this.wTransformName.setText(this.transformName);
        this.wProjectId.setText(Const.NVL((String)this.input.getProjectId(), (String)""));
        this.wDatasetId.setText(Const.NVL((String)this.input.getDatasetId(), (String)""));
        this.wTableId.setText(Const.NVL((String)this.input.getTableId(), (String)""));
        this.wQuery.setText(Const.NVL((String)this.input.getQuery(), (String)""));
        for (int i = 0; i < this.input.getFields().size(); ++i) {
            BQField field = this.input.getFields().get(i);
            TableItem item = this.wFields.table.getItem(i);
            item.setText(1, Const.NVL((String)field.getName(), (String)""));
            item.setText(2, Const.NVL((String)field.getNewName(), (String)""));
            item.setText(3, Const.NVL((String)field.getHopType(), (String)""));
        }
        this.wFields.removeEmptyRows();
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.getInfo(this.input);
        this.dispose();
    }

    private void getInfo(BeamBQInputMeta in) {
        this.transformName = this.wTransformName.getText();
        in.setProjectId(this.wProjectId.getText());
        in.setDatasetId(this.wDatasetId.getText());
        in.setTableId(this.wTableId.getText());
        in.setQuery(this.wQuery.getText());
        in.getFields().clear();
        for (int i = 0; i < this.wFields.nrNonEmpty(); ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            String name = item.getText(1);
            String newName = item.getText(2);
            String hopType = item.getText(3);
            in.getFields().add(new BQField(name, newName, hopType));
        }
        this.input.setChanged();
    }
}

