/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure;

import com.microsoft.azure.Page;
import com.microsoft.rest.RestException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public abstract class PagedList<E>
implements List<E> {
    private List<E> items = new ArrayList();
    private Page<E> currentPage;
    private Page<E> cachedPage;

    public PagedList() {
    }

    public PagedList(Page<E> page) {
        this();
        if (page == null) {
            return;
        }
        List<E> retrievedItems = page.items();
        if (retrievedItems != null) {
            this.items.addAll(retrievedItems);
        }
        this.currentPage = page;
        super.cachePage(page.nextPageLink());
    }

    private void cachePage(String nextPageLink) {
        try {
            while (nextPageLink != null && nextPageLink != "") {
                this.cachedPage = this.nextPage(nextPageLink);
                if (this.cachedPage != null) {
                    nextPageLink = this.cachedPage.nextPageLink();
                    if (!this.hasNextPage()) continue;
                }
                break;
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    public abstract Page<E> nextPage(String var1) throws RestException, IOException;

    public boolean hasNextPage() {
        return this.cachedPage != null && this.cachedPage.items() != null && !this.cachedPage.items().isEmpty();
    }

    public void loadNextPage() {
        this.currentPage = this.cachedPage;
        this.cachedPage = null;
        this.items.addAll(this.currentPage.items());
        this.cachePage(this.currentPage.nextPageLink());
    }

    public void loadAll() {
        while (this.hasNextPage()) {
            this.loadNextPage();
        }
    }

    public Page<E> currentPage() {
        return this.currentPage;
    }

    protected void setCurrentPage(Page<E> currentPage) {
        this.currentPage = currentPage;
        List<E> retrievedItems = currentPage.items();
        if (retrievedItems != null) {
            this.items.addAll(retrievedItems);
        }
        this.cachePage(currentPage.nextPageLink());
    }

    @Override
    public int size() {
        this.loadAll();
        return this.items.size();
    }

    @Override
    public boolean isEmpty() {
        return this.items.isEmpty() && !this.hasNextPage();
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public Iterator<E> iterator() {
        return new ListItr(0);
    }

    @Override
    public Object[] toArray() {
        this.loadAll();
        return this.items.toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        this.loadAll();
        return this.items.toArray(a);
    }

    @Override
    public boolean add(E e) {
        return this.items.add(e);
    }

    @Override
    public boolean remove(Object o) {
        return this.items.remove(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        for (Object e : c) {
            if (this.contains(e)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.items.addAll(c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        return this.items.addAll(index, c);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        return this.items.removeAll(c);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        return this.items.retainAll(c);
    }

    @Override
    public void clear() {
        this.items.clear();
    }

    @Override
    public E get(int index) {
        while (index >= this.items.size() && this.hasNextPage()) {
            this.loadNextPage();
        }
        return this.items.get(index);
    }

    @Override
    public E set(int index, E element) {
        return this.items.set(index, element);
    }

    @Override
    public void add(int index, E element) {
        this.items.add(index, element);
    }

    @Override
    public E remove(int index) {
        return this.items.remove(index);
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        if (o == null) {
            for (E item : this) {
                if (item == null) {
                    return index;
                }
                ++index;
            }
        } else {
            for (E item : this) {
                if (item == o) {
                    return index;
                }
                ++index;
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        this.loadAll();
        return this.items.lastIndexOf(o);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new ListItr(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        while (index >= this.items.size() && this.hasNextPage()) {
            this.loadNextPage();
        }
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        while ((fromIndex >= this.items.size() || toIndex >= this.items.size()) && this.hasNextPage()) {
            this.loadNextPage();
        }
        return this.items.subList(fromIndex, toIndex);
    }

    private class ListItr
    implements ListIterator<E> {
        private int nextIndex;
        private int lastRetIndex = -1;

        ListItr(int index) {
            this.nextIndex = index;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex != PagedList.this.items.size() || PagedList.this.hasNextPage();
        }

        @Override
        public E next() {
            if (this.nextIndex >= PagedList.this.items.size()) {
                if (!PagedList.this.hasNextPage()) {
                    throw new NoSuchElementException();
                }
                PagedList.this.loadNextPage();
                return this.next();
            }
            try {
                Object nextItem = PagedList.this.items.get(this.nextIndex);
                this.lastRetIndex = this.nextIndex++;
                return nextItem;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRetIndex < 0) {
                throw new IllegalStateException();
            }
            try {
                PagedList.this.items.remove(this.lastRetIndex);
                this.nextIndex = this.lastRetIndex;
                this.lastRetIndex = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex != 0;
        }

        @Override
        public E previous() {
            int i = this.nextIndex - 1;
            if (i < 0) {
                throw new NoSuchElementException();
            }
            if (i >= PagedList.this.items.size()) {
                throw new ConcurrentModificationException();
            }
            try {
                this.nextIndex = i;
                this.lastRetIndex = i;
                return PagedList.this.items.get(this.lastRetIndex);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void set(E e) {
            if (this.lastRetIndex < 0) {
                throw new IllegalStateException();
            }
            try {
                PagedList.this.items.set(this.lastRetIndex, e);
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E e) {
            try {
                PagedList.this.items.add(this.nextIndex, e);
                ++this.nextIndex;
                this.lastRetIndex = -1;
            }
            catch (IndexOutOfBoundsException ex) {
                throw new ConcurrentModificationException();
            }
        }
    }
}

