/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.ui.core.dialog;

import com.google.common.annotations.VisibleForTesting;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.function.Function;
import org.apache.hop.core.Const;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.ui.core.PropsUi;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.gui.GuiResource;
import org.apache.hop.ui.core.gui.WindowProperty;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ErrorDialog
extends Dialog {
    private static final Class<?> PKG = ErrorDialog.class;
    private Button wCancel;
    private Shell shell;
    private PropsUi props;
    private boolean cancelled;
    private Function<String, String> exMsgFunction = Function.identity();

    public ErrorDialog(Shell parent, String title, String message, Throwable throwable) {
        this(parent, title, message, throwable, Function.identity());
    }

    public ErrorDialog(Shell parent, String title, String message, Throwable throwable, Function<String, String> exMsgFunction) {
        super(parent, 0);
        this.exMsgFunction = exMsgFunction;
        throwable.printStackTrace();
        if (throwable instanceof Exception) {
            this.showErrorDialog(parent, title, message, (Exception)throwable, false);
        } else {
            this.showErrorDialog(parent, title, message + Const.CR + Const.getStackTracker((Throwable)throwable), null, false);
        }
    }

    public ErrorDialog(Shell parent, String title, String message, Exception exception) {
        super(parent, 0);
        this.showErrorDialog(parent, title, message, exception, false);
    }

    public ErrorDialog(Shell parent, String title, String message, Exception exception, boolean showCancelButton) {
        super(parent, 0);
        this.showErrorDialog(parent, title, message, exception, showCancelButton);
    }

    private void showErrorDialog(Shell parent, String title, String message, Exception exception, boolean showCancelButton) {
        if (parent.isDisposed()) {
            exception.printStackTrace();
            return;
        }
        this.props = PropsUi.getInstance();
        Font largeFont = GuiResource.getInstance().getFontBold();
        Color gray = GuiResource.getInstance().getColorDemoGray();
        StringBuilder text = new StringBuilder();
        StringBuilder details = new StringBuilder();
        if (exception != null) {
            this.handleException(message, exception, text, details);
        } else {
            text.append(message);
        }
        this.shell = new Shell(parent, 268504304);
        this.props.setLook((Control)this.shell);
        this.shell.setImage(GuiResource.getInstance().getImageError());
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(title);
        int margin = this.props.getMargin();
        Button wOk = new Button((Composite)this.shell, 8);
        wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        wOk.addListener(13, e -> this.ok());
        if (showCancelButton) {
            this.wCancel = new Button((Composite)this.shell, 8);
            this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
            this.wCancel.addListener(13, e -> this.cancel());
        }
        Button wDetails = new Button((Composite)this.shell, 8);
        wDetails.setText(BaseMessages.getString(PKG, (String)"System.Button.Details", (String[])new String[0]));
        wDetails.addListener(13, e -> this.showDetails(details.toString()));
        Button[] buttons = showCancelButton ? new Button[]{wOk, this.wCancel, wDetails} : new Button[]{wOk, wDetails};
        BaseTransformDialog.positionBottomButtons((Composite)this.shell, buttons, margin, null);
        Label wlDesc = new Label((Composite)this.shell, 0);
        wlDesc.setText(message);
        this.props.setLook((Control)wlDesc);
        FormData fdlDesc = new FormData();
        fdlDesc.left = new FormAttachment(0, 0);
        fdlDesc.top = new FormAttachment(0, margin);
        wlDesc.setLayoutData((Object)fdlDesc);
        wlDesc.setFont(largeFont);
        Text wDesc = new Text((Composite)this.shell, 19202);
        this.props.setLook((Control)wDesc);
        wDesc.setText(this.exMsgFunction.apply(text.toString()));
        wDesc.setBackground(gray);
        FormData fdDesc = new FormData();
        fdDesc.left = new FormAttachment(0, 0);
        fdDesc.top = new FormAttachment((Control)wlDesc, margin);
        fdDesc.right = new FormAttachment(100, 0);
        fdDesc.bottom = new FormAttachment((Control)wOk, -2 * margin);
        wDesc.setLayoutData((Object)fdDesc);
        wDesc.setEditable(false);
        wOk.setFocus();
        BaseDialog.defaultShellHandling(this.shell, c -> this.ok(), c -> this.cancel());
    }

    @VisibleForTesting
    protected void handleException(String message, Exception exception, StringBuilder text, StringBuilder details) {
        text.append(Const.getSimpleStackTrace((Throwable)exception));
        text.append(Const.CR);
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        exception.printStackTrace(pw);
        details.append(sw.getBuffer());
    }

    protected void showDetails(String details) {
        EnterTextDialog dialog = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"ErrorDialog.ShowDetails.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"ErrorDialog.ShowDetails.Message", (String[])new String[0]), details);
        dialog.setReadOnly();
        dialog.open();
    }

    public void dispose() {
        this.props.setScreen(new WindowProperty(this.shell));
        this.shell.dispose();
    }

    private void ok() {
        this.dispose();
    }

    private void cancel() {
        this.cancelled = true;
        this.dispose();
    }

    public boolean isCancelled() {
        return this.cancelled;
    }
}

