/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.serde2;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.serde2.Deserializer;
import org.apache.hadoop.hive.serde2.SerDeException;
import org.apache.hadoop.hive.serde2.SerDeStats;
import org.apache.hadoop.hive.serde2.SerDeUtils;
import org.apache.hadoop.hive.serde2.Serializer;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoUtils;
import org.apache.hadoop.io.Writable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSerDe
implements Deserializer,
Serializer {
    protected Logger log = LoggerFactory.getLogger(this.getClass());
    protected Optional<Configuration> configuration;
    protected Properties properties;
    protected Properties tableProperties;
    protected Optional<Properties> partitionProperties;
    private List<String> columnNames;
    private List<TypeInfo> columnTypes;
    private List<String> columnComments;
    private List<String> partitionColumnNames;
    private List<TypeInfo> partitionColumnTypes;
    private List<String> partitionColumnComments;

    public void initialize(Configuration configuration, Properties tableProperties, Properties partitionProperties) throws SerDeException {
        this.configuration = Optional.ofNullable(configuration);
        this.tableProperties = Objects.requireNonNull(tableProperties);
        this.partitionProperties = Optional.ofNullable(partitionProperties);
        this.properties = SerDeUtils.createOverlayedProperties(tableProperties, partitionProperties);
        this.columnNames = this.parseColumnNames();
        this.columnTypes = this.parseColumnTypes();
        this.columnComments = this.parseColumnComments("columns.comments");
        this.partitionColumnNames = this.parseColumnNames("partition.columns");
        this.partitionColumnTypes = this.parseColumnTypes("partition.columns.types");
        this.partitionColumnComments = this.parseColumnComments("partition.columns.comments");
        Preconditions.checkArgument((this.columnNames.size() == this.columnTypes.size() ? 1 : 0) != 0, (Object)"Column names must match count of column types");
        this.log.debug("SerDe initialized: [{}][{}]", this.configuration, (Object)this.properties);
    }

    protected List<String> parseColumnNames() {
        return this.parseColumnNames("columns");
    }

    protected List<String> parseColumnNames(String key) {
        String columnNameProperty = this.properties.getProperty(key, "");
        String columnNameDelimiter = this.properties.getProperty("column.name.delimiter", String.valueOf(','));
        return columnNameProperty.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(columnNameProperty.split(columnNameDelimiter)));
    }

    protected List<TypeInfo> parseColumnTypes() {
        return this.parseColumnTypes("columns.types");
    }

    protected List<TypeInfo> parseColumnTypes(String key) {
        String columnTypeProperty = this.properties.getProperty(key, "");
        return columnTypeProperty.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(TypeInfoUtils.getTypeInfosFromTypeString(columnTypeProperty));
    }

    protected List<String> parseColumnComments(String key) {
        String columnCommentProperty = this.properties.getProperty(key, "");
        return columnCommentProperty.isEmpty() ? Collections.emptyList() : Collections.unmodifiableList(Arrays.asList(columnCommentProperty.split(Character.toString('\u0000'))));
    }

    @Override
    public abstract Class<? extends Writable> getSerializedClass();

    @Override
    public SerDeStats getSerDeStats() {
        return null;
    }

    @Override
    public Writable serialize(Object obj, ObjectInspector objInspector) throws SerDeException {
        throw new SerDeException("Serialize is not implemented");
    }

    @Override
    public Object deserialize(Writable blob) throws SerDeException {
        throw new SerDeException("Deserialize is not implemented");
    }

    public boolean shouldStoreFieldsInMetastore(Map<String, String> tableParams) {
        return false;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    public List<TypeInfo> getColumnTypes() {
        return this.columnTypes;
    }

    public List<String> getColumnComments() {
        return this.columnComments;
    }

    public List<String> getPartitionColumnNames() {
        return this.partitionColumnNames;
    }

    public List<TypeInfo> getPartitionColumnTypes() {
        return this.partitionColumnTypes;
    }

    public List<String> getPartitionColumnComments() {
        return this.partitionColumnComments;
    }

    public Optional<Configuration> getConfiguration() {
        return this.configuration;
    }

    public String toString() {
        return "AbstractSerDe [log=" + this.log + ", configuration=" + this.configuration + ", properties=" + this.properties + ", tableProperties=" + this.tableProperties + ", partitionProperties=" + this.partitionProperties + ", columnNames=" + this.columnNames + ", columnTypes=" + this.columnTypes + ", getClass()=" + this.getClass() + "]";
    }
}

