/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.workflow.engine;

import org.apache.commons.lang.StringUtils;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.plugins.IPlugin;
import org.apache.hop.core.plugins.PluginRegistry;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.workflow.WorkflowMeta;
import org.apache.hop.workflow.config.IWorkflowEngineRunConfiguration;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;
import org.apache.hop.workflow.engine.IWorkflowEngine;
import org.apache.hop.workflow.engine.WorkflowEnginePluginType;
import org.apache.hop.workflow.engines.local.LocalWorkflowEngine;

public class WorkflowEngineFactory {
    public static final <T extends WorkflowMeta> IWorkflowEngine<T> createWorkflowEngine(IVariables variables, String runConfigurationName, IHopMetadataProvider metadataProvider, T workflowMeta, ILoggingObject parentLogging) throws HopException {
        WorkflowRunConfiguration runConfiguration;
        if (StringUtils.isEmpty((String)runConfigurationName)) {
            throw new HopException("You need to specify a workflow run configuration to execute this workflow");
        }
        try {
            runConfiguration = (WorkflowRunConfiguration)metadataProvider.getSerializer(WorkflowRunConfiguration.class).load(runConfigurationName);
        }
        catch (Exception e) {
            throw new HopException("Error loading workflow run configuration '" + runConfigurationName + "'", (Throwable)e);
        }
        if (runConfiguration == null) {
            throw new HopException("Workflow run configuration '" + runConfigurationName + "' could not be found");
        }
        IWorkflowEngine<T> workflowEngine = WorkflowEngineFactory.createWorkflowEngine(runConfiguration, workflowMeta, parentLogging);
        workflowEngine.initializeFrom(variables);
        workflowEngine.setInternalHopVariables();
        workflowEngine.copyParametersFromDefinitions(workflowMeta);
        workflowEngine.setMetadataProvider(metadataProvider);
        workflowMeta.setMetadataProvider(metadataProvider);
        return workflowEngine;
    }

    private static final <T extends WorkflowMeta> IWorkflowEngine<T> createWorkflowEngine(WorkflowRunConfiguration workflowRunConfiguration, T workflowMeta, ILoggingObject parentLogging) throws HopException {
        IWorkflowEngineRunConfiguration engineRunConfiguration = workflowRunConfiguration.getEngineRunConfiguration();
        if (engineRunConfiguration == null) {
            throw new HopException("There is no pipeline execution engine specified in run configuration '" + workflowRunConfiguration.getName() + "'");
        }
        String enginePluginId = engineRunConfiguration.getEnginePluginId();
        PluginRegistry pluginRegistry = PluginRegistry.getInstance();
        IPlugin plugin = pluginRegistry.findPluginWithId(WorkflowEnginePluginType.class, enginePluginId);
        if (plugin == null) {
            throw new HopException("Unable to find pipeline engine plugin type with ID '" + enginePluginId + "'");
        }
        IWorkflowEngine workflowEngine = (IWorkflowEngine)pluginRegistry.loadClass(plugin, IWorkflowEngine.class);
        workflowEngine.setWorkflowRunConfiguration(workflowRunConfiguration);
        if (workflowEngine instanceof LocalWorkflowEngine) {
            ((LocalWorkflowEngine)workflowEngine).setParentLoggingObject(parentLogging);
        }
        workflowEngine.setWorkflowMeta(workflowMeta);
        return workflowEngine;
    }
}

