/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.core.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.hop.core.search.BaseMetadataSearchableAnalyser;
import org.apache.hop.core.search.ISearchQuery;
import org.apache.hop.core.search.ISearchResult;
import org.apache.hop.core.search.ISearchable;
import org.apache.hop.core.search.ISearchableAnalyser;
import org.apache.hop.core.search.SearchableAnalyserPlugin;
import org.apache.hop.workflow.config.WorkflowRunConfiguration;

@SearchableAnalyserPlugin(id="WorkflowRunConfigurationSearchableAnalyser", name="Search in workflow run configuration metadata")
public class WorkflowRunConfigurationSearchableAnalyser
extends BaseMetadataSearchableAnalyser<WorkflowRunConfiguration>
implements ISearchableAnalyser<WorkflowRunConfiguration> {
    @Override
    public Class<WorkflowRunConfiguration> getSearchableClass() {
        return WorkflowRunConfiguration.class;
    }

    public List<ISearchResult> search(ISearchable<WorkflowRunConfiguration> searchable, ISearchQuery searchQuery) {
        WorkflowRunConfiguration runConfig = (WorkflowRunConfiguration)searchable.getSearchableObject();
        String component = this.getMetadataComponent();
        ArrayList<ISearchResult> results = new ArrayList<ISearchResult>();
        this.matchProperty(searchable, results, searchQuery, "Workflow run configuration name", runConfig.getName(), component);
        this.matchProperty(searchable, results, searchQuery, "Workflow run configuration description", runConfig.getDescription(), component);
        this.matchObjectFields(searchable, results, searchQuery, runConfig.getEngineRunConfiguration(), "Workflow run configuration property", null);
        return results;
    }
}

