/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction;

import com.google.cloud.Timestamp;
import java.io.Serializable;
import java.util.Objects;
import java.util.Optional;
import org.apache.beam.sdk.io.gcp.spanner.changestreams.restriction.PartitionMode;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.checkerframework.checker.nullness.qual.Nullable;

public class PartitionPosition
implements Serializable {
    private static final long serialVersionUID = -9088898012221404492L;
    private final Optional<Timestamp> maybeTimestamp;
    private final PartitionMode mode;

    public static PartitionPosition updateState() {
        return new PartitionPosition(Optional.empty(), PartitionMode.UPDATE_STATE);
    }

    public static PartitionPosition queryChangeStream(Timestamp timestamp) {
        return new PartitionPosition(Optional.of(timestamp), PartitionMode.QUERY_CHANGE_STREAM);
    }

    public static PartitionPosition waitForChildPartitions() {
        return new PartitionPosition(Optional.empty(), PartitionMode.WAIT_FOR_CHILD_PARTITIONS);
    }

    public static PartitionPosition done() {
        return new PartitionPosition(Optional.empty(), PartitionMode.DONE);
    }

    public static PartitionPosition stop() {
        return new PartitionPosition(Optional.empty(), PartitionMode.STOP);
    }

    @VisibleForTesting
    public PartitionPosition(Optional<Timestamp> maybeTimestamp, PartitionMode mode) {
        this.maybeTimestamp = maybeTimestamp;
        this.mode = mode;
    }

    public Optional<Timestamp> getTimestamp() {
        return this.maybeTimestamp;
    }

    public PartitionMode getMode() {
        return this.mode;
    }

    public boolean equals(@Nullable Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PartitionPosition)) {
            return false;
        }
        PartitionPosition that = (PartitionPosition)o;
        return Objects.equals(this.maybeTimestamp, that.maybeTimestamp) && this.mode == that.mode;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.maybeTimestamp, this.mode});
    }

    public String toString() {
        return "PartitionPosition{maybeTimestamp=" + this.maybeTimestamp + ", mode=" + (Object)((Object)this.mode) + '}';
    }
}

