/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink.translation.utils;

import com.fasterxml.jackson.databind.type.TypeFactory;
import java.lang.reflect.Field;
import org.apache.beam.runners.core.TimerInternals;
import org.apache.flink.runtime.state.InternalPriorityQueue;
import org.apache.flink.streaming.api.operators.InternalTimer;
import org.apache.flink.streaming.api.operators.InternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimerServiceImpl;

public class Workarounds {
    public static void deleteStaticCaches() {
        TypeFactory.defaultInstance().clearCache();
    }

    public static InternalPriorityQueue<InternalTimer<Object, TimerInternals.TimerData>> retrieveInternalProcessingTimerQueue(InternalTimerService<TimerInternals.TimerData> timerService) {
        Field internalProcessingTimerQueue = null;
        try {
            internalProcessingTimerQueue = InternalTimerServiceImpl.class.getDeclaredField("processingTimeTimersQueue");
            internalProcessingTimerQueue.setAccessible(true);
            InternalPriorityQueue internalPriorityQueue = (InternalPriorityQueue)internalProcessingTimerQueue.get(timerService);
            return internalPriorityQueue;
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to retrieve processing timer queue.", e);
        }
        finally {
            if (internalProcessingTimerQueue != null) {
                internalProcessingTimerQueue.setAccessible(false);
            }
        }
    }
}

