/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.flink;

import org.apache.beam.runners.core.construction.resources.PipelineResources;
import org.apache.beam.runners.flink.FlinkBatchPipelineTranslator;
import org.apache.beam.runners.flink.FlinkExecutionEnvironments;
import org.apache.beam.runners.flink.FlinkPipelineOptions;
import org.apache.beam.runners.flink.FlinkPipelineTranslator;
import org.apache.beam.runners.flink.FlinkStreamingPipelineTranslator;
import org.apache.beam.runners.flink.FlinkTransformOverrides;
import org.apache.beam.runners.flink.PipelineTranslationModeOptimizer;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.options.FileStagingOptions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.java.ExecutionEnvironment;
import org.apache.flink.runtime.jobgraph.JobGraph;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class FlinkPipelineExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(FlinkPipelineExecutionEnvironment.class);
    private final FlinkPipelineOptions options;
    private ExecutionEnvironment flinkBatchEnv;
    private StreamExecutionEnvironment flinkStreamEnv;

    FlinkPipelineExecutionEnvironment(FlinkPipelineOptions options) {
        this.options = (FlinkPipelineOptions)Preconditions.checkNotNull((Object)options);
    }

    public void translate(Pipeline pipeline) {
        FlinkPipelineTranslator translator;
        this.flinkBatchEnv = null;
        this.flinkStreamEnv = null;
        boolean hasUnboundedOutput = PipelineTranslationModeOptimizer.hasUnboundedOutput(pipeline);
        if (hasUnboundedOutput) {
            LOG.info("Found unbounded PCollection. Switching to streaming execution.");
            this.options.setStreaming(true);
        }
        FlinkPipelineExecutionEnvironment.prepareFilesToStageForRemoteClusterExecution(this.options);
        if (this.options.isStreaming()) {
            this.flinkStreamEnv = FlinkExecutionEnvironments.createStreamExecutionEnvironment(this.options);
            if (hasUnboundedOutput && !this.flinkStreamEnv.getCheckpointConfig().isCheckpointingEnabled()) {
                LOG.warn("UnboundedSources present which rely on checkpointing, but checkpointing is disabled.");
            }
            translator = new FlinkStreamingPipelineTranslator(this.flinkStreamEnv, this.options);
        } else {
            this.flinkBatchEnv = FlinkExecutionEnvironments.createBatchExecutionEnvironment(this.options);
            translator = new FlinkBatchPipelineTranslator(this.flinkBatchEnv, this.options);
        }
        pipeline.replaceAll(FlinkTransformOverrides.getDefaultOverrides(this.options));
        translator.translate(pipeline);
    }

    private static void prepareFilesToStageForRemoteClusterExecution(FlinkPipelineOptions options) {
        if (!options.getFlinkMaster().matches("\\[auto\\]|\\[collection\\]|\\[local\\]")) {
            PipelineResources.prepareFilesForStaging((FileStagingOptions)options);
        }
    }

    public JobExecutionResult executePipeline() throws Exception {
        String jobName = this.options.getJobName();
        if (this.flinkBatchEnv != null) {
            return this.flinkBatchEnv.execute(jobName);
        }
        if (this.flinkStreamEnv != null) {
            return this.flinkStreamEnv.execute(jobName);
        }
        throw new IllegalStateException("The Pipeline has not yet been translated.");
    }

    @VisibleForTesting
    JobGraph getJobGraph(Pipeline p) {
        this.translate(p);
        StreamGraph streamGraph = this.flinkStreamEnv.getStreamGraph();
        streamGraph.setJobName(p.getOptions().getJobName());
        return streamGraph.getJobGraph();
    }

    @VisibleForTesting
    ExecutionEnvironment getBatchExecutionEnvironment() {
        return this.flinkBatchEnv;
    }

    @VisibleForTesting
    StreamExecutionEnvironment getStreamExecutionEnvironment() {
        return this.flinkStreamEnv;
    }
}

