/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cassandrainput;

import org.apache.hop.core.Const;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.databases.cassandra.metadata.CassandraConnection;
import org.apache.hop.databases.cassandra.spi.Connection;
import org.apache.hop.databases.cassandra.spi.Keyspace;
import org.apache.hop.databases.cassandra.util.CassandraUtils;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.PipelinePreviewFactory;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transforms.cassandrainput.CassandraInputMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.EnterNumberDialog;
import org.apache.hop.ui.core.dialog.EnterTextDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.PreviewRowsDialog;
import org.apache.hop.ui.core.dialog.ShowMessageDialog;
import org.apache.hop.ui.core.widget.MetaSelectionLine;
import org.apache.hop.ui.core.widget.StyledTextComp;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.dialog.PipelinePreviewProgressDialog;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class CassandraInputDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = CassandraInputMeta.class;
    private final CassandraInputMeta input;
    private MetaSelectionLine<CassandraConnection> wConnection;
    private TextVar wMaxLength;
    private Label wlPosition;
    private StyledTextComp wCql;
    private Button wExecuteForEachRow;

    public CassandraInputDialog(Shell parent, IVariables variables, Object in, PipelineMeta tr, String name) {
        super(parent, variables, (BaseTransformMeta)in, tr, name);
        this.input = (CassandraInputMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wOk.addListener(13, e -> this.ok());
        this.wPreview = new Button((Composite)this.shell, 8);
        this.wPreview.setText(BaseMessages.getString(PKG, (String)"System.Button.Preview", (String[])new String[0]));
        this.wPreview.addListener(13, e -> this.preview());
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.wCancel.addListener(13, e -> this.cancel());
        this.setButtonPositions(new Button[]{this.wOk, this.wPreview, this.wCancel}, margin, null);
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.transformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        FormData fdlTransformName = new FormData();
        fdlTransformName.left = new FormAttachment(0, 0);
        fdlTransformName.right = new FormAttachment(middle, -margin);
        fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        FormData fdTransformName = new FormData();
        fdTransformName.left = new FormAttachment(middle, 0);
        fdTransformName.top = new FormAttachment(0, margin);
        fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)fdTransformName);
        this.wConnection = new MetaSelectionLine(this.variables, this.metadataProvider, CassandraConnection.class, (Composite)this.shell, 0, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Connection.Label", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.Connection.Tooltip", (String[])new String[0]));
        this.props.setLook(this.wConnection);
        FormData fdConnection = new FormData();
        fdConnection.left = new FormAttachment(0, 0);
        fdConnection.right = new FormAttachment(100, 0);
        fdConnection.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wConnection.setLayoutData((Object)fdConnection);
        try {
            this.wConnection.fillItems();
        }
        catch (Exception e2) {
            new ErrorDialog(this.shell, "Error", "Error listing Cassandra connection metadata objects", e2);
        }
        Label wlMaxLength = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlMaxLength);
        wlMaxLength.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.TransportMaxLength.Label", (String[])new String[0]));
        FormData fdlMaxLength = new FormData();
        fdlMaxLength.left = new FormAttachment(0, 0);
        fdlMaxLength.top = new FormAttachment(this.wConnection, margin);
        fdlMaxLength.right = new FormAttachment(middle, -margin);
        wlMaxLength.setLayoutData((Object)fdlMaxLength);
        this.wMaxLength = new TextVar(this.variables, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wMaxLength);
        this.wMaxLength.addModifyListener(e -> this.wMaxLength.setToolTipText(this.variables.resolve(this.wMaxLength.getText())));
        FormData fdMaxLength = new FormData();
        fdMaxLength.right = new FormAttachment(100, 0);
        fdMaxLength.top = new FormAttachment((Control)wlMaxLength, 0, 0x1000000);
        fdMaxLength.left = new FormAttachment(middle, 0);
        this.wMaxLength.setLayoutData((Object)fdMaxLength);
        Label wlExecuteForEach = new Label((Composite)this.shell, 131072);
        this.props.setLook((Control)wlExecuteForEach);
        wlExecuteForEach.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.ExecuteForEachRow.Label", (String[])new String[0]));
        FormData fdlExecuteForEach = new FormData();
        fdlExecuteForEach.right = new FormAttachment(middle, -margin);
        fdlExecuteForEach.left = new FormAttachment(0, 0);
        fdlExecuteForEach.top = new FormAttachment((Control)this.wMaxLength, margin);
        wlExecuteForEach.setLayoutData((Object)fdlExecuteForEach);
        this.wExecuteForEachRow = new Button((Composite)this.shell, 32);
        this.props.setLook((Control)this.wExecuteForEachRow);
        FormData fdExecuteForEach = new FormData();
        fdExecuteForEach.right = new FormAttachment(100, 0);
        fdExecuteForEach.left = new FormAttachment(middle, 0);
        fdExecuteForEach.top = new FormAttachment((Control)wlExecuteForEach, 0, 0x1000000);
        this.wExecuteForEachRow.setLayoutData((Object)fdExecuteForEach);
        this.wlPosition = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)this.wlPosition);
        FormData fdlPosition = new FormData();
        fdlPosition.left = new FormAttachment(0, 0);
        fdlPosition.right = new FormAttachment(middle, -margin);
        fdlPosition.bottom = new FormAttachment((Control)this.wOk, -margin);
        this.wlPosition.setLayoutData((Object)fdlPosition);
        Button wbShowSchema = new Button((Composite)this.shell, 8);
        wbShowSchema.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Schema.Button", (String[])new String[0]));
        this.props.setLook((Control)wbShowSchema);
        FormData fdbShowSchema = new FormData();
        fdbShowSchema.right = new FormAttachment(100, 0);
        fdbShowSchema.bottom = new FormAttachment((Control)this.wOk, -margin);
        wbShowSchema.setLayoutData((Object)fdbShowSchema);
        wbShowSchema.addListener(13, e -> this.popupSchemaInfo());
        Label wlCql = new Label((Composite)this.shell, 0);
        this.props.setLook((Control)wlCql);
        wlCql.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.CQL.Label", (String[])new String[0]));
        FormData fdlCql = new FormData();
        fdlCql.left = new FormAttachment(0, 0);
        fdlCql.top = new FormAttachment((Control)this.wExecuteForEachRow, margin);
        fdlCql.right = new FormAttachment(middle, -margin);
        wlCql.setLayoutData((Object)fdlCql);
        this.wCql = new StyledTextComp(this.variables, (Composite)this.shell, 19202);
        this.props.setLook((Control)this.wCql, 1);
        FormData fdCql = new FormData();
        fdCql.left = new FormAttachment(0, 0);
        fdCql.top = new FormAttachment((Control)wlCql, margin);
        fdCql.right = new FormAttachment(100, -2 * margin);
        fdCql.bottom = new FormAttachment((Control)wbShowSchema, -margin);
        this.wCql.setLayoutData((Object)fdCql);
        this.wCql.addModifyListener(e -> {
            this.setPosition();
            this.wCql.setToolTipText(this.variables.resolve(this.wCql.getText()));
        });
        this.wCql.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void keyReleased(KeyEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.wCql.addFocusListener(new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void focusLost(FocusEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.wCql.addMouseListener(new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseDown(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }

            public void mouseUp(MouseEvent e) {
                CassandraInputDialog.this.setPosition();
            }
        });
        this.getData();
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void getInfo(CassandraInputMeta meta) {
        meta.setConnectionName(this.wConnection.getText());
        meta.setMaxLength(this.wMaxLength.getText());
        meta.setCqlSelectQuery(this.wCql.getText());
        meta.setExecuteForEachIncomingRow(this.wExecuteForEachRow.getSelection());
    }

    protected void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        this.transformName = this.wTransformName.getText();
        this.getInfo(this.input);
        this.input.setChanged();
        this.dispose();
    }

    protected void cancel() {
        this.transformName = null;
        this.dispose();
    }

    protected void getData() {
        this.wConnection.setText(Const.NVL((String)this.input.getConnectionName(), (String)""));
        this.wMaxLength.setText(Const.NVL((String)this.input.getMaxLength(), (String)""));
        this.wExecuteForEachRow.setSelection(this.input.isExecuteForEachIncomingRow());
        if (!Utils.isEmpty((CharSequence)this.input.getCqlSelectQuery())) {
            this.wCql.setText(this.input.getCqlSelectQuery());
        }
    }

    protected void setPosition() {
        int lineNr = this.wCql.getLineNumber();
        int colNr = this.wCql.getColumnNumber();
        this.wlPosition.setText(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Position.Label", (String[])new String[]{"" + lineNr, "" + colNr}));
    }

    private boolean checkForUnresolved(CassandraInputMeta meta, String title) {
        boolean notOk;
        String query = this.variables.resolve(meta.getCqlSelectQuery());
        boolean bl = notOk = query.contains("${") || query.contains("?{");
        if (notOk) {
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 40, title, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Warning.Message.CassandraQueryContainsUnresolvedVarsFieldSubs", (String[])new String[0]));
            smd.open();
        }
        return !notOk;
    }

    private void preview() {
        CassandraInputMeta oneMeta = new CassandraInputMeta();
        this.getInfo(oneMeta);
        oneMeta.setExecuteForEachIncomingRow(false);
        if (!this.checkForUnresolved(oneMeta, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Warning.Message.CassandraQueryContainsUnresolvedVarsFieldSubs.PreviewTitle", (String[])new String[0]))) {
            return;
        }
        PipelineMeta previewMeta = PipelinePreviewFactory.generatePreviewPipeline((IHopMetadataProvider)this.pipelineMeta.getMetadataProvider(), (ITransformMeta)oneMeta, (String)this.wTransformName.getText());
        EnterNumberDialog numberDialog = new EnterNumberDialog(this.shell, this.props.getDefaultPreviewSize(), BaseMessages.getString(PKG, (String)"CassandraInputDialog.PreviewSize.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.PreviewSize.DialogMessage", (String[])new String[0]));
        int previewSize = numberDialog.open();
        if (previewSize > 0) {
            PipelinePreviewProgressDialog progressDialog = new PipelinePreviewProgressDialog(this.shell, this.variables, previewMeta, new String[]{this.wTransformName.getText()}, new int[]{previewSize});
            progressDialog.open();
            Pipeline pipeline = progressDialog.getPipeline();
            String loggingText = progressDialog.getLoggingText();
            if (!progressDialog.isCancelled() && pipeline.getResult() != null && pipeline.getResult().getNrErrors() > 0L) {
                EnterTextDialog etd = new EnterTextDialog(this.shell, BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"System.Dialog.PreviewError.Message", (String[])new String[0]), loggingText, true);
                etd.setReadOnly();
                etd.open();
            }
            PreviewRowsDialog prd = new PreviewRowsDialog(this.shell, this.variables, 0, this.wTransformName.getText(), progressDialog.getPreviewRowsMeta(this.wTransformName.getText()), progressDialog.getPreviewRows(this.wTransformName.getText()), loggingText);
            prd.open();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void popupSchemaInfo() {
        Connection conn = null;
        Keyspace kSpace = null;
        try {
            CassandraConnection cassandraConnection = (CassandraConnection)this.metadataProvider.getSerializer(CassandraConnection.class).load(this.variables.resolve(this.wConnection.getText()));
            try {
                conn = cassandraConnection.createConnection(this.variables, false);
                kSpace = cassandraConnection.lookupKeyspace(conn, this.variables);
            }
            catch (Exception e) {
                this.logError(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e.getLocalizedMessage(), e);
                if (conn != null) {
                    try {
                        conn.closeConnection();
                    }
                    catch (Exception e2) {
                        this.log.logError(e2.getLocalizedMessage(), (Throwable)e2);
                    }
                }
                return;
            }
            String cqlText = this.variables.resolve(this.wCql.getText());
            String table = CassandraUtils.getTableNameFromCQLSelectQuery(cqlText);
            if (Utils.isEmpty((CharSequence)table)) {
                throw new Exception(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NoFromClauseInQuery", (String[])new String[0]));
            }
            if (!kSpace.tableExists(table)) {
                throw new Exception(BaseMessages.getString(PKG, (String)"CassandraInput.Error.NonExistentTable", (String[])new String[]{CassandraUtils.removeQuotes(table), cassandraConnection.getKeyspace()}));
            }
            String schemaDescription = kSpace.getTableMetaData(table).describe();
            ShowMessageDialog smd = new ShowMessageDialog(this.shell, 34, "Schema info", schemaDescription, true);
            smd.open();
        }
        catch (Exception e1) {
            this.logError(BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Title", (String[])new String[0]), BaseMessages.getString(PKG, (String)"CassandraInputDialog.Error.ProblemGettingSchemaInfo.Message", (String[])new String[0]) + ":\n\n" + e1.getMessage(), e1);
        }
        finally {
            if (conn != null) {
                try {
                    conn.closeConnection();
                }
                catch (Exception e) {
                    this.log.logError(e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }
}

