/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.transforms;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.auto.value.AutoValue;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.schemas.Schema;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_JsonToRowWithErrFn;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_JsonToRowWithErrFn_ParseWithError;
import org.apache.beam.sdk.transforms.AutoValue_JsonToRow_ParseResult;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.util.RowJson;
import org.apache.beam.sdk.util.RowJsonUtils;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionTuple;
import org.apache.beam.sdk.values.PInput;
import org.apache.beam.sdk.values.POutput;
import org.apache.beam.sdk.values.PValue;
import org.apache.beam.sdk.values.Row;
import org.apache.beam.sdk.values.TupleTag;
import org.apache.beam.sdk.values.TupleTagList;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableMap;
import org.checkerframework.checker.nullness.qual.Nullable;

@Experimental(value=Experimental.Kind.SCHEMAS)
public class JsonToRow {
    public static PTransform<PCollection<String>, PCollection<Row>> withSchema(Schema rowSchema) {
        RowJson.verifySchemaSupported(rowSchema);
        return new JsonToRowFn(rowSchema, RowJson.RowJsonDeserializer.NullBehavior.ACCEPT_MISSING_OR_NULL);
    }

    public static PTransform<PCollection<String>, PCollection<Row>> withSchemaAndNullBehavior(Schema rowSchema, RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
        RowJson.verifySchemaSupported(rowSchema);
        return new JsonToRowFn(rowSchema, nullBehavior);
    }

    @Experimental(value=Experimental.Kind.SCHEMAS)
    public static JsonToRowWithErrFn withExceptionReporting(Schema rowSchema) {
        return JsonToRowWithErrFn.forSchema(rowSchema);
    }

    @AutoValue
    public static abstract class ParseResult
    implements POutput {
        abstract JsonToRowWithErrFn getJsonToRowWithErrFn();

        abstract PCollection<Row> getParsedLine();

        abstract PCollection<Row> getFailedParse();

        abstract Builder toBuilder();

        abstract Pipeline getCallingPipeline();

        public static Builder resultBuilder() {
            return new AutoValue_JsonToRow_ParseResult.Builder();
        }

        @Override
        public Pipeline getPipeline() {
            return this.getCallingPipeline();
        }

        @Override
        public Map<TupleTag<?>, PValue> expand() {
            return ImmutableMap.of(JsonToRowWithErrFn.PARSED_LINE, this.getParsedLine(), JsonToRowWithErrFn.PARSE_ERROR, this.getFailedParse());
        }

        @Override
        public void finishSpecifyingOutput(String transformName, PInput input, PTransform<?, ?> transform) {
        }

        public PCollection<Row> getResults() {
            return this.getParsedLine();
        }

        public PCollection<Row> getFailedToParseLines() {
            return this.getFailedParse();
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract Builder setJsonToRowWithErrFn(JsonToRowWithErrFn var1);

            abstract Builder setParsedLine(PCollection<Row> var1);

            abstract Builder setFailedParse(PCollection<Row> var1);

            abstract Builder setCallingPipeline(Pipeline var1);

            abstract ParseResult build();
        }
    }

    @AutoValue
    public static abstract class JsonToRowWithErrFn
    extends PTransform<PCollection<String>, ParseResult> {
        private static final String LINE_FIELD_NAME = "line";
        private static final String ERROR_FIELD_NAME = "err";
        public static final Schema ERROR_ROW_SCHEMA = Schema.of(Schema.Field.of("line", Schema.FieldType.STRING));
        public static final Schema ERROR_ROW_WITH_ERR_MSG_SCHEMA = Schema.of(Schema.Field.of("line", Schema.FieldType.STRING), Schema.Field.of("err", Schema.FieldType.STRING));
        static final TupleTag<Row> PARSED_LINE = new TupleTag<Row>(){};
        static final TupleTag<Row> PARSE_ERROR = new TupleTag<Row>(){};

        abstract Schema getSchema();

        abstract String getLineFieldName();

        abstract String getErrorFieldName();

        abstract boolean getExtendedErrorInfo();

        abstract RowJson.RowJsonDeserializer.NullBehavior getNullBehavior();

        abstract Builder toBuilder();

        static JsonToRowWithErrFn forSchema(Schema rowSchema) {
            RowJson.verifySchemaSupported(rowSchema);
            return new AutoValue_JsonToRow_JsonToRowWithErrFn.Builder().setSchema(rowSchema).setNullBehavior(RowJson.RowJsonDeserializer.NullBehavior.ACCEPT_MISSING_OR_NULL).setExtendedErrorInfo(false).setLineFieldName(LINE_FIELD_NAME).setErrorFieldName(ERROR_FIELD_NAME).build();
        }

        public JsonToRowWithErrFn withExtendedErrorInfo() {
            return this.toBuilder().setExtendedErrorInfo(true).build();
        }

        public JsonToRowWithErrFn setLineField(String lineField) {
            return this.toBuilder().setLineFieldName(lineField).build();
        }

        public JsonToRowWithErrFn setErrorField(String errorField) {
            if (!this.getExtendedErrorInfo()) {
                throw new IllegalArgumentException("This option is only available with Extended Error Info.");
            }
            return this.toBuilder().setErrorFieldName(errorField).build();
        }

        public JsonToRowWithErrFn withNullBehavior(RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
            return this.toBuilder().setNullBehavior(nullBehavior).build();
        }

        @Override
        public ParseResult expand(PCollection<String> jsonStrings) {
            PCollectionTuple result = (PCollectionTuple)((Object)jsonStrings.apply(ParDo.of(ParseWithError.create(this)).withOutputTags(PARSED_LINE, TupleTagList.of(PARSE_ERROR))));
            PCollection<Row> failures = this.getExtendedErrorInfo() ? result.get(PARSE_ERROR).setRowSchema(ERROR_ROW_WITH_ERR_MSG_SCHEMA) : result.get(PARSE_ERROR).setRowSchema(ERROR_ROW_SCHEMA);
            return ParseResult.resultBuilder().setCallingPipeline(jsonStrings.getPipeline()).setJsonToRowWithErrFn(this).setParsedLine(result.get(PARSED_LINE).setRowSchema(this.getSchema())).setFailedParse(failures).build();
        }

        @AutoValue
        protected static abstract class ParseWithError
        extends DoFn<String, Row> {
            private volatile transient @Nullable ObjectMapper objectMapper;

            protected ParseWithError() {
            }

            public abstract JsonToRowWithErrFn getJsonToRowWithErrFn();

            public abstract Builder toBuilder();

            public static ParseWithError create(JsonToRowWithErrFn jsonToRowWithErrFn) {
                return new AutoValue_JsonToRow_JsonToRowWithErrFn_ParseWithError.Builder().setJsonToRowWithErrFn(jsonToRowWithErrFn).build();
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element String element, DoFn.MultiOutputReceiver output) {
                try {
                    output.get(PARSED_LINE).output(RowJsonUtils.jsonToRow(this.objectMapper(), element));
                }
                catch (Exception ex) {
                    if (this.getJsonToRowWithErrFn().getExtendedErrorInfo()) {
                        output.get(PARSE_ERROR).output(Row.withSchema(ERROR_ROW_WITH_ERR_MSG_SCHEMA).addValue(element).addValue(ex.getMessage()).build());
                    }
                    output.get(PARSE_ERROR).output(Row.withSchema(ERROR_ROW_SCHEMA).addValue(element).build());
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private ObjectMapper objectMapper() {
                if (this.objectMapper == null) {
                    ParseWithError parseWithError = this;
                    synchronized (parseWithError) {
                        if (this.objectMapper == null) {
                            this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(this.getJsonToRowWithErrFn().getSchema()).withNullBehavior(this.getJsonToRowWithErrFn().getNullBehavior()));
                        }
                    }
                }
                return this.objectMapper;
            }

            @AutoValue.Builder
            public static abstract class Builder {
                public abstract Builder setJsonToRowWithErrFn(JsonToRowWithErrFn var1);

                public abstract ParseWithError build();
            }
        }

        @AutoValue.Builder
        public static abstract class Builder {
            abstract Builder setSchema(Schema var1);

            abstract Builder setLineFieldName(String var1);

            abstract Builder setErrorFieldName(String var1);

            abstract Builder setExtendedErrorInfo(boolean var1);

            abstract Builder setNullBehavior(RowJson.RowJsonDeserializer.NullBehavior var1);

            abstract JsonToRowWithErrFn build();
        }
    }

    static class JsonToRowFn
    extends PTransform<PCollection<String>, PCollection<Row>> {
        private volatile transient @Nullable ObjectMapper objectMapper;
        private final Schema schema;
        private final RowJson.RowJsonDeserializer.NullBehavior nullBehavior;

        private JsonToRowFn(Schema schema, RowJson.RowJsonDeserializer.NullBehavior nullBehavior) {
            this.schema = schema;
            this.nullBehavior = nullBehavior;
        }

        @Override
        public PCollection<Row> expand(PCollection<String> jsonStrings) {
            return ((PCollection)((Object)jsonStrings.apply(ParDo.of(new DoFn<String, Row>(){

                @DoFn.ProcessElement
                public void processElement(DoFn.ProcessContext context) {
                    context.output(RowJsonUtils.jsonToRow(this.objectMapper(), (String)context.element()));
                }
            })))).setRowSchema(this.schema);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ObjectMapper objectMapper() {
            if (this.objectMapper == null) {
                JsonToRowFn jsonToRowFn = this;
                synchronized (jsonToRowFn) {
                    if (this.objectMapper == null) {
                        this.objectMapper = RowJsonUtils.newObjectMapperWith(RowJson.RowJsonDeserializer.forSchema(this.schema).withNullBehavior(this.nullBehavior));
                    }
                }
            }
            return this.objectMapper;
        }
    }
}

