/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.options;

import com.fasterxml.jackson.annotation.JsonCreator;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.DefaultValueFactory;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.util.InstanceBuilder;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.index.qual.NonNegative;

@Description(value="Options that are used to control configuration of the SDK harness.")
@Experimental(value=Experimental.Kind.PORTABILITY)
public interface SdkHarnessOptions
extends PipelineOptions {
    @Description(value="Controls the default log level of all loggers without a log level override.")
    @Default.Enum(value="INFO")
    public LogLevel getDefaultSdkHarnessLogLevel();

    public void setDefaultSdkHarnessLogLevel(LogLevel var1);

    @Description(value="This option controls the log levels for specifically named loggers. The expected format is {\"Name\":\"LogLevel\",...}. The SDK harness supports a logging hierarchy based off of names that are '.' separated. For example, by specifying the value {\"a.b.c.Foo\":\"DEBUG\"}, the logger for the class 'a.b.c.Foo' will be configured to output logs at the DEBUG level. Similarly, by specifying the value {\"a.b.c\":\"WARN\"}, all loggers underneath the 'a.b.c' package will be configured to output logs at the WARN level. System.out and System.err levels are configured via loggers of the corresponding name. Also, note that when multiple overrides are specified, the exact name followed by the closest parent takes precedence.")
    public SdkHarnessLogLevelOverrides getSdkHarnessLogLevelOverrides();

    public void setSdkHarnessLogLevelOverrides(SdkHarnessLogLevelOverrides var1);

    @Description(value="The size (in MB) of the grouping tables used to pre-combine elements before shuffling. If unset, defaults to 100 MB. Larger values may reduce the amount of data shuffled. CAUTION: If set too large, workers may run into OOM conditions more easily, each worker may have many grouping tables in-memory concurrently. CAUTION: This option does not apply to portable runners such as Dataflow Prime. See --maxCacheMemoryUsageMb, --maxCacheMemoryUsagePercent, or --maxCacheMemoryUsageMbClass to configure memory thresholds that apply to the grouping table and other cached objects.")
    @Default.Integer(value=100)
    public int getGroupingTableMaxSizeMb();

    public void setGroupingTableMaxSizeMb(int var1);

    @Description(value="The size (in MB) for the process wide cache within the SDK harness. The cache is responsible for storing all values which are cached within a bundle and across bundles such as side inputs and user state. CAUTION: If set too large, SDK harness instances may run into OOM conditions more easily.")
    @Default.InstanceFactory(value=DefaultMaxCacheMemoryUsageMbFactory.class)
    public @NonNegative int getMaxCacheMemoryUsageMb();

    public void setMaxCacheMemoryUsageMb(@NonNegative int var1);

    @Description(value="The size (in % [0 - 100]) for the process wide cache within the SDK harness. The cache is responsible for storing all values which are cached within a bundle and across bundles such as side inputs and user state. CAUTION: If set too large, SDK harness instances may run into OOM conditions more easily.")
    @Default.Float(value=20.0f)
    public @NonNegative float getMaxCacheMemoryUsagePercent();

    public void setMaxCacheMemoryUsagePercent(@NonNegative float var1);

    @Description(value="An instance of this class will be used to specify the maximum amount of memory to allocate to a  process wide cache within an SDK harness instance. This parameter will only be used if an explicit value was not specified for --maxCacheMemoryUsageMb.")
    @Default.Class(value=DefaultMaxCacheMemoryUsageMb.class)
    public Class<? extends MaxCacheMemoryUsageMb> getMaxCacheMemoryUsageMbClass();

    public void setMaxCacheMemoryUsageMbClass(Class<? extends MaxCacheMemoryUsageMb> var1);

    @Description(value="Open modules needed for reflection with Java 17+.")
    public List<String> getJdkAddOpenModules();

    public void setJdkAddOpenModules(List<String> var1);

    public static class SdkHarnessLogLevelOverrides
    extends HashMap<String, LogLevel> {
        public SdkHarnessLogLevelOverrides addOverrideForClass(Class<?> klass, LogLevel logLevel) {
            Preconditions.checkNotNull(klass, (Object)"Expected class to be not null.");
            this.addOverrideForName(klass.getName(), logLevel);
            return this;
        }

        public SdkHarnessLogLevelOverrides addOverrideForPackage(Package pkg, LogLevel logLevel) {
            Preconditions.checkNotNull((Object)pkg, (Object)"Expected package to be not null.");
            this.addOverrideForName(pkg.getName(), logLevel);
            return this;
        }

        public SdkHarnessLogLevelOverrides addOverrideForName(String name, LogLevel logLevel) {
            Preconditions.checkNotNull((Object)name, (Object)"Expected name to be not null.");
            Preconditions.checkNotNull((Object)((Object)logLevel), (String)"Expected logLevel to be one of %s.", (Object)Arrays.toString((Object[])LogLevel.values()));
            this.put(name, logLevel);
            return this;
        }

        @JsonCreator
        public static SdkHarnessLogLevelOverrides from(Map<String, String> values) {
            Preconditions.checkNotNull(values, (Object)"Expected values to be not null.");
            SdkHarnessLogLevelOverrides overrides = new SdkHarnessLogLevelOverrides();
            for (Map.Entry<String, String> entry : values.entrySet()) {
                try {
                    overrides.addOverrideForName(entry.getKey(), LogLevel.valueOf(entry.getValue()));
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException(String.format("Unsupported log level '%s' requested for %s. Must be one of %s.", entry.getValue(), entry.getKey(), Arrays.toString((Object[])LogLevel.values())));
                }
            }
            return overrides;
        }
    }

    public static class DefaultMaxCacheMemoryUsageMb
    implements MaxCacheMemoryUsageMb {
        @Override
        public int getMaxCacheMemoryUsage(PipelineOptions options) {
            return this.getMaxCacheMemoryUsage(options, Runtime.getRuntime().maxMemory());
        }

        @VisibleForTesting
        int getMaxCacheMemoryUsage(PipelineOptions options, long maxMemory) {
            if (maxMemory == Long.MAX_VALUE) {
                return 100;
            }
            float maxPercent = options.as(SdkHarnessOptions.class).getMaxCacheMemoryUsagePercent();
            if (maxPercent < 0.0f || maxPercent > 100.0f) {
                throw new IllegalArgumentException("--maxCacheMemoryUsagePercent must be between 0 and 100.");
            }
            return (int)((double)maxMemory / 1048576.0 * (double)maxPercent / 100.0);
        }
    }

    public static interface MaxCacheMemoryUsageMb {
        public @NonNegative int getMaxCacheMemoryUsage(PipelineOptions var1);
    }

    public static class DefaultMaxCacheMemoryUsageMbFactory
    implements DefaultValueFactory<Integer> {
        @Override
        public @NonNegative Integer create(PipelineOptions options) {
            SdkHarnessOptions sdkHarnessOptions = options.as(SdkHarnessOptions.class);
            return (Integer)Preconditions.checkNotNull((Object)InstanceBuilder.ofType(MaxCacheMemoryUsageMb.class).fromClass(sdkHarnessOptions.getMaxCacheMemoryUsageMbClass()).build().getMaxCacheMemoryUsage(options));
        }
    }

    public static enum LogLevel {
        OFF,
        ERROR,
        WARN,
        INFO,
        DEBUG,
        TRACE;

    }
}

