/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.coders;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.beam.sdk.coders.AtomicCoder;
import org.apache.beam.sdk.coders.CoderException;
import org.apache.beam.sdk.coders.VarLongCoder;
import org.apache.beam.sdk.util.common.ElementByteSizeObserver;
import org.apache.beam.sdk.values.TypeDescriptor;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;

public class DurationCoder
extends AtomicCoder<ReadableDuration> {
    private static final DurationCoder INSTANCE = new DurationCoder();
    private static final TypeDescriptor<ReadableDuration> TYPE_DESCRIPTOR = new TypeDescriptor<ReadableDuration>(){};
    private static final VarLongCoder LONG_CODER = VarLongCoder.of();

    public static DurationCoder of() {
        return INSTANCE;
    }

    private DurationCoder() {
    }

    private Long toLong(ReadableDuration value) {
        return value.getMillis();
    }

    private ReadableDuration fromLong(Long decoded) {
        return Duration.millis((long)decoded);
    }

    @Override
    public void encode(ReadableDuration value, OutputStream outStream) throws CoderException, IOException {
        if (value == null) {
            throw new CoderException("cannot encode a null ReadableDuration");
        }
        LONG_CODER.encode(this.toLong(value), outStream);
    }

    @Override
    public ReadableDuration decode(InputStream inStream) throws CoderException, IOException {
        return this.fromLong(LONG_CODER.decode(inStream));
    }

    @Override
    public void verifyDeterministic() {
        LONG_CODER.verifyDeterministic();
    }

    @Override
    public boolean consistentWithEquals() {
        return true;
    }

    @Override
    public boolean isRegisterByteSizeObserverCheap(ReadableDuration value) {
        return LONG_CODER.isRegisterByteSizeObserverCheap(this.toLong(value));
    }

    @Override
    public void registerByteSizeObserver(ReadableDuration value, ElementByteSizeObserver observer) throws Exception {
        LONG_CODER.registerByteSizeObserver(this.toLong(value), observer);
    }

    @Override
    public TypeDescriptor<ReadableDuration> getEncodedTypeDescriptor() {
        return TYPE_DESCRIPTOR;
    }
}

