/*
 * Decompiled with CFR 0.152.
 */
package com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2;

import com.google.bigtable.repackaged.com.google.api.core.ApiFunction;
import com.google.bigtable.repackaged.com.google.api.core.ApiFuture;
import com.google.bigtable.repackaged.com.google.api.core.ApiFutures;
import com.google.bigtable.repackaged.com.google.api.core.BetaApi;
import com.google.bigtable.repackaged.com.google.api.core.InternalApi;
import com.google.bigtable.repackaged.com.google.api.gax.batching.Batcher;
import com.google.bigtable.repackaged.com.google.api.gax.grpc.GrpcCallContext;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ApiExceptions;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ResponseObserver;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStream;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.ServerStreamingCallable;
import com.google.bigtable.repackaged.com.google.api.gax.rpc.UnaryCallable;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.BigtableDataSettings;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.BulkMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ConditionalRowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Filters;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.KeyOffset;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Query;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.ReadModifyWriteRow;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.Row;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowAdapter;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutation;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.models.RowMutationEntry;
import com.google.bigtable.repackaged.com.google.cloud.bigtable.data.v2.stub.EnhancedBigtableStub;
import com.google.bigtable.repackaged.com.google.common.util.concurrent.MoreExecutors;
import com.google.bigtable.repackaged.com.google.protobuf.ByteString;
import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class BigtableDataClient
implements AutoCloseable {
    private final EnhancedBigtableStub stub;

    public static BigtableDataClient create(String projectId, String instanceId) throws IOException {
        BigtableDataSettings settings = BigtableDataSettings.newBuilder().setProjectId(projectId).setInstanceId(instanceId).build();
        return BigtableDataClient.create(settings);
    }

    public static BigtableDataClient create(BigtableDataSettings settings) throws IOException {
        EnhancedBigtableStub stub = EnhancedBigtableStub.create(settings.getStubSettings());
        return new BigtableDataClient(stub);
    }

    @InternalApi(value="Visible for testing")
    BigtableDataClient(EnhancedBigtableStub stub) {
        this.stub = stub;
    }

    public boolean exists(String tableId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    public boolean exists(String tableId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.existsAsync(tableId, rowKey));
    }

    public ApiFuture<Boolean> existsAsync(String tableId, String rowKey) {
        return this.existsAsync(tableId, ByteString.copyFromUtf8(rowKey));
    }

    public ApiFuture<Boolean> existsAsync(String tableId, ByteString rowKey) {
        Query query = Query.create(tableId).rowKey(rowKey).filter(Filters.FILTERS.chain().filter(Filters.FILTERS.limit().cellsPerRow(1)).filter(Filters.FILTERS.value().strip()));
        ApiFuture<Row> resultFuture = this.stub.readRowCallable().futureCall(query);
        return ApiFutures.transform(resultFuture, new ApiFunction<Row, Boolean>(){

            @Override
            public Boolean apply(Row row) {
                return row != null;
            }
        }, MoreExecutors.directExecutor());
    }

    public Row readRow(String tableId, ByteString rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, null));
    }

    public Row readRow(String tableId, String rowKey) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), null));
    }

    public Row readRow(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), filter));
    }

    public Row readRow(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        return ApiExceptions.callAndTranslateApiException(this.readRowAsync(tableId, rowKey, filter));
    }

    public ApiFuture<Row> readRowAsync(String tableId, String rowKey) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), null);
    }

    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey) {
        return this.readRowAsync(tableId, rowKey, null);
    }

    public ApiFuture<Row> readRowAsync(String tableId, String rowKey, @Nullable Filters.Filter filter) {
        return this.readRowAsync(tableId, ByteString.copyFromUtf8(rowKey), filter);
    }

    public ApiFuture<Row> readRowAsync(String tableId, ByteString rowKey, @Nullable Filters.Filter filter) {
        Query query = Query.create(tableId).rowKey(rowKey);
        if (filter != null) {
            query = query.filter(filter);
        }
        return this.readRowCallable().futureCall(query);
    }

    public UnaryCallable<Query, Row> readRowCallable() {
        return this.stub.readRowCallable();
    }

    public <RowT> UnaryCallable<Query, RowT> readRowCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowCallable(rowAdapter);
    }

    public ServerStream<Row> readRows(Query query) {
        return this.readRowsCallable().call(query);
    }

    public void readRowsAsync(Query query, ResponseObserver<Row> observer) {
        this.readRowsCallable().call(query, observer);
    }

    public ServerStreamingCallable<Query, Row> readRowsCallable() {
        return this.stub.readRowsCallable();
    }

    public <RowT> ServerStreamingCallable<Query, RowT> readRowsCallable(RowAdapter<RowT> rowAdapter) {
        return this.stub.createReadRowsCallable(rowAdapter);
    }

    public List<KeyOffset> sampleRowKeys(String tableId) {
        return ApiExceptions.callAndTranslateApiException(this.sampleRowKeysAsync(tableId));
    }

    public ApiFuture<List<KeyOffset>> sampleRowKeysAsync(String tableId) {
        return this.sampleRowKeysCallable().futureCall(tableId);
    }

    public UnaryCallable<String, List<KeyOffset>> sampleRowKeysCallable() {
        return this.stub.sampleRowKeysCallable();
    }

    public void mutateRow(RowMutation rowMutation) {
        ApiExceptions.callAndTranslateApiException(this.mutateRowAsync(rowMutation));
    }

    public ApiFuture<Void> mutateRowAsync(RowMutation rowMutation) {
        return this.mutateRowCallable().futureCall(rowMutation);
    }

    public UnaryCallable<RowMutation, Void> mutateRowCallable() {
        return this.stub.mutateRowCallable();
    }

    public void bulkMutateRows(BulkMutation mutation) {
        ApiExceptions.callAndTranslateApiException(this.bulkMutateRowsAsync(mutation));
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId) {
        return this.newBulkMutationBatcher(tableId, null);
    }

    @BetaApi(value="This surface is likely to change as the batching surface evolves.")
    public Batcher<RowMutationEntry, Void> newBulkMutationBatcher(@Nonnull String tableId, @Nullable GrpcCallContext ctx) {
        return this.stub.newMutateRowsBatcher(tableId, ctx);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId) {
        return this.newBulkReadRowsBatcher(tableId, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter) {
        return this.newBulkReadRowsBatcher(tableId, filter, null);
    }

    public Batcher<ByteString, Row> newBulkReadRowsBatcher(String tableId, @Nullable Filters.Filter filter, @Nullable GrpcCallContext ctx) {
        Query query = Query.create(tableId);
        if (filter != null) {
            query.filter(filter);
        }
        return this.stub.newBulkReadRowsBatcher(query, ctx);
    }

    public ApiFuture<Void> bulkMutateRowsAsync(BulkMutation mutation) {
        return this.bulkMutationCallable().futureCall(mutation);
    }

    public UnaryCallable<BulkMutation, Void> bulkMutationCallable() {
        return this.stub.bulkMutateRowsCallable();
    }

    public Boolean checkAndMutateRow(ConditionalRowMutation mutation) {
        return ApiExceptions.callAndTranslateApiException(this.checkAndMutateRowAsync(mutation));
    }

    public ApiFuture<Boolean> checkAndMutateRowAsync(ConditionalRowMutation mutation) {
        return this.checkAndMutateRowCallable().futureCall(mutation);
    }

    public UnaryCallable<ConditionalRowMutation, Boolean> checkAndMutateRowCallable() {
        return this.stub.checkAndMutateRowCallable();
    }

    public Row readModifyWriteRow(ReadModifyWriteRow mutation) {
        return ApiExceptions.callAndTranslateApiException(this.readModifyWriteRowAsync(mutation));
    }

    public ApiFuture<Row> readModifyWriteRowAsync(ReadModifyWriteRow mutation) {
        return this.readModifyWriteRowCallable().futureCall(mutation);
    }

    public UnaryCallable<ReadModifyWriteRow, Row> readModifyWriteRowCallable() {
        return this.stub.readModifyWriteRowCallable();
    }

    @Override
    public void close() {
        this.stub.close();
    }
}

