/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.uniquerows;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.IntStream;
import org.apache.hop.core.Const;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.util.Utils;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.PipelineHopMeta;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.ITransformDialog;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueField;
import org.apache.hop.pipeline.transforms.uniquerows.UniqueRowsMeta;
import org.apache.hop.ui.core.dialog.BaseDialog;
import org.apache.hop.ui.core.dialog.ErrorDialog;
import org.apache.hop.ui.core.dialog.MessageDialogWithToggle;
import org.apache.hop.ui.core.widget.ColumnInfo;
import org.apache.hop.ui.core.widget.TableView;
import org.apache.hop.ui.core.widget.TextVar;
import org.apache.hop.ui.pipeline.transform.BaseTransformDialog;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;

public class UniqueRowsDialog
extends BaseTransformDialog
implements ITransformDialog {
    private static final Class<?> PKG = UniqueRowsMeta.class;
    public static final String STRING_SORT_WARNING_PARAMETER = "UniqueSortWarning";
    private final UniqueRowsMeta input;
    private Button wCount;
    private Label wlCountField;
    private Text wCountField;
    private TableView wFields;
    private ColumnInfo[] colinf;
    private final Map<String, Integer> inputFields;
    private Button wRejectDuplicateRow;
    private Label wlErrorDesc;
    private TextVar wErrorDesc;

    public UniqueRowsDialog(Shell parent, IVariables variables, Object in, PipelineMeta pipelineMeta, String sname) {
        super(parent, variables, (BaseTransformMeta)in, pipelineMeta, sname);
        this.input = (UniqueRowsMeta)((Object)in);
        this.inputFields = new HashMap<String, Integer>();
    }

    public String open() {
        Shell parent = this.getParent();
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, (ITransformMeta)this.input);
        ModifyListener lsMod = e -> this.input.setChanged();
        this.changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Shell.Title", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = this.props.getMargin();
        this.wlTransformName = new Label((Composite)this.shell, 131072);
        this.wlTransformName.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.TransformName.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlTransformName);
        this.fdlTransformName = new FormData();
        this.fdlTransformName.left = new FormAttachment(0, 0);
        this.fdlTransformName.right = new FormAttachment(middle, -margin);
        this.fdlTransformName.top = new FormAttachment(0, margin);
        this.wlTransformName.setLayoutData((Object)this.fdlTransformName);
        this.wTransformName = new Text((Composite)this.shell, 18436);
        this.wTransformName.setText(this.transformName);
        this.props.setLook((Control)this.wTransformName);
        this.wTransformName.addModifyListener(lsMod);
        this.fdTransformName = new FormData();
        this.fdTransformName.left = new FormAttachment(middle, 0);
        this.fdTransformName.top = new FormAttachment(0, margin);
        this.fdTransformName.right = new FormAttachment(100, 0);
        this.wTransformName.setLayoutData((Object)this.fdTransformName);
        Group wSettings = new Group((Composite)this.shell, 32);
        this.props.setLook((Control)wSettings);
        wSettings.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Settings.Label", (String[])new String[0]));
        FormLayout settingsgroupLayout = new FormLayout();
        settingsgroupLayout.marginWidth = 10;
        settingsgroupLayout.marginHeight = 10;
        wSettings.setLayout((Layout)settingsgroupLayout);
        Label wlCount = new Label((Composite)wSettings, 131072);
        wlCount.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Count.Label", (String[])new String[0]));
        this.props.setLook((Control)wlCount);
        FormData fdlCount = new FormData();
        fdlCount.left = new FormAttachment(0, 0);
        fdlCount.top = new FormAttachment((Control)this.wTransformName, margin);
        fdlCount.right = new FormAttachment(middle, -margin);
        wlCount.setLayoutData((Object)fdlCount);
        this.wCount = new Button((Composite)wSettings, 32);
        this.props.setLook((Control)this.wCount);
        this.wCount.setToolTipText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Count.ToolTip", (String[])new String[]{Const.CR}));
        FormData fdCount = new FormData();
        fdCount.left = new FormAttachment(middle, 0);
        fdCount.top = new FormAttachment((Control)wlCount, 0, 0x1000000);
        this.wCount.setLayoutData((Object)fdCount);
        this.wCount.addListener(13, e -> {
            this.input.setChanged();
            this.setFlags();
        });
        this.wlCountField = new Label((Composite)wSettings, 16384);
        this.wlCountField.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.CounterField.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlCountField);
        FormData fdlCountField = new FormData();
        fdlCountField.left = new FormAttachment((Control)this.wCount, margin);
        fdlCountField.top = new FormAttachment((Control)this.wTransformName, margin);
        this.wlCountField.setLayoutData((Object)fdlCountField);
        this.wCountField = new Text((Composite)wSettings, 18436);
        this.props.setLook((Control)this.wCountField);
        this.wCountField.addModifyListener(lsMod);
        FormData fdCountField = new FormData();
        fdCountField.left = new FormAttachment((Control)this.wlCountField, margin);
        fdCountField.top = new FormAttachment((Control)this.wTransformName, margin);
        fdCountField.right = new FormAttachment(100, 0);
        this.wCountField.setLayoutData((Object)fdCountField);
        Label wlRejectDuplicateRow = new Label((Composite)wSettings, 131072);
        wlRejectDuplicateRow.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.RejectDuplicateRow.Label", (String[])new String[0]));
        this.props.setLook((Control)wlRejectDuplicateRow);
        FormData fdlRejectDuplicateRow = new FormData();
        fdlRejectDuplicateRow.left = new FormAttachment(0, 0);
        fdlRejectDuplicateRow.top = new FormAttachment((Control)this.wCountField, margin);
        fdlRejectDuplicateRow.right = new FormAttachment(middle, -margin);
        wlRejectDuplicateRow.setLayoutData((Object)fdlRejectDuplicateRow);
        this.wRejectDuplicateRow = new Button((Composite)wSettings, 32);
        this.props.setLook((Control)this.wRejectDuplicateRow);
        this.wRejectDuplicateRow.setToolTipText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.RejectDuplicateRow.ToolTip", (String[])new String[]{Const.CR}));
        FormData fdRejectDuplicateRow = new FormData();
        fdRejectDuplicateRow.left = new FormAttachment(middle, 0);
        fdRejectDuplicateRow.top = new FormAttachment((Control)wlRejectDuplicateRow, 0, 0x1000000);
        this.wRejectDuplicateRow.setLayoutData((Object)fdRejectDuplicateRow);
        this.wRejectDuplicateRow.addListener(13, e -> {
            this.input.setChanged();
            this.setErrorDesc();
        });
        this.wlErrorDesc = new Label((Composite)wSettings, 16384);
        this.wlErrorDesc.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.ErrorDescription.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlErrorDesc);
        FormData fdlErrorDesc = new FormData();
        fdlErrorDesc.left = new FormAttachment((Control)this.wRejectDuplicateRow, margin);
        fdlErrorDesc.top = new FormAttachment((Control)this.wCountField, margin);
        this.wlErrorDesc.setLayoutData((Object)fdlErrorDesc);
        this.wErrorDesc = new TextVar(this.variables, (Composite)wSettings, 18436);
        this.props.setLook((Control)this.wErrorDesc);
        this.wErrorDesc.addModifyListener(lsMod);
        FormData fdErrorDesc = new FormData();
        fdErrorDesc.left = new FormAttachment((Control)this.wlErrorDesc, margin);
        fdErrorDesc.top = new FormAttachment((Control)this.wCountField, margin);
        fdErrorDesc.right = new FormAttachment(100, 0);
        this.wErrorDesc.setLayoutData((Object)fdErrorDesc);
        FormData fdSettings = new FormData();
        fdSettings.left = new FormAttachment(0, margin);
        fdSettings.top = new FormAttachment((Control)this.wTransformName, margin);
        fdSettings.right = new FormAttachment(100, -margin);
        wSettings.setLayoutData((Object)fdSettings);
        this.wOk = new Button((Composite)this.shell, 8);
        this.wOk.setText(BaseMessages.getString(PKG, (String)"System.Button.OK", (String[])new String[0]));
        this.wGet = new Button((Composite)this.shell, 8);
        this.wGet.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Get.Button", (String[])new String[0]));
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText(BaseMessages.getString(PKG, (String)"System.Button.Cancel", (String[])new String[0]));
        this.setButtonPositions(new Button[]{this.wOk, this.wGet, this.wCancel}, margin, null);
        Label wlFields = new Label((Composite)this.shell, 0);
        wlFields.setText(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.Fields.Label", (String[])new String[0]));
        this.props.setLook((Control)wlFields);
        FormData fdlFields = new FormData();
        fdlFields.left = new FormAttachment(0, 0);
        fdlFields.top = new FormAttachment((Control)wSettings, margin);
        wlFields.setLayoutData((Object)fdlFields);
        int fieldsRows = this.input.getCompareFields() == null ? 0 : this.input.getCompareFields().size();
        this.colinf = new ColumnInfo[]{new ColumnInfo(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.ColumnInfo.Fieldname", (String[])new String[0]), 2, new String[]{""}, false), new ColumnInfo(BaseMessages.getString(PKG, (String)"UniqueRowsDialog.ColumnInfo.IgnoreCase", (String[])new String[0]), 2, new String[]{"Y", "N"}, true)};
        this.wFields = new TableView(this.variables, (Composite)this.shell, 67586, this.colinf, fieldsRows, lsMod, this.props);
        FormData fdFields = new FormData();
        fdFields.left = new FormAttachment(0, 0);
        fdFields.top = new FormAttachment((Control)wlFields, margin);
        fdFields.right = new FormAttachment(100, 0);
        fdFields.bottom = new FormAttachment((Control)this.wOk, -2 * margin);
        this.wFields.setLayoutData((Object)fdFields);
        Runnable runnable = () -> {
            TransformMeta transformMeta = this.pipelineMeta.findTransform(this.transformName);
            if (transformMeta != null) {
                try {
                    IRowMeta row = this.pipelineMeta.getPrevTransformFields(this.variables, transformMeta);
                    for (int i = 0; i < row.size(); ++i) {
                        this.inputFields.put(row.getValueMeta(i).getName(), i);
                    }
                    this.setComboBoxes();
                }
                catch (HopException e) {
                    this.logError(BaseMessages.getString(PKG, (String)"System.Dialog.GetFieldsFailed.Message", (String[])new String[0]));
                }
            }
        };
        new Thread(runnable).start();
        this.wCancel.addListener(13, e -> this.cancel());
        this.wGet.addListener(13, e -> this.get());
        this.wOk.addListener(13, e -> this.ok());
        this.getData();
        this.input.setChanged(this.changed);
        BaseDialog.defaultShellHandling((Shell)this.shell, c -> this.ok(), c -> this.cancel());
        return this.transformName;
    }

    private void setErrorDesc() {
        this.wlErrorDesc.setEnabled(this.wRejectDuplicateRow.getSelection());
        this.wErrorDesc.setEnabled(this.wRejectDuplicateRow.getSelection());
    }

    protected void setComboBoxes() {
        HashMap<String, Integer> fields = new HashMap<String, Integer>();
        fields.putAll(this.inputFields);
        Set keySet = fields.keySet();
        ArrayList entries = new ArrayList(keySet);
        String[] fieldNames = entries.toArray(new String[entries.size()]);
        Const.sortStrings((String[])fieldNames);
        this.colinf[0].setComboValues(fieldNames);
    }

    public void setFlags() {
        this.wlCountField.setEnabled(this.wCount.getSelection());
        this.wCountField.setEnabled(this.wCount.getSelection());
    }

    public void getData() {
        this.wCount.setSelection(this.input.isCountRows());
        if (this.input.getCountField() != null) {
            this.wCountField.setText(this.input.getCountField());
        }
        this.setFlags();
        this.wRejectDuplicateRow.setSelection(this.input.isRejectDuplicateRow());
        if (this.input.getErrorDescription() != null) {
            this.wErrorDesc.setText(this.input.getErrorDescription());
        }
        this.setErrorDesc();
        int i = 0;
        for (UniqueField field : this.input.getCompareFields()) {
            TableItem item = this.wFields.table.getItem(i++);
            if (field != null) {
                item.setText(1, field.getName());
            }
            item.setText(2, field.isCaseInsensitive() ? "Y" : "N");
        }
        this.wFields.setRowNums();
        this.wFields.optWidth(true);
        this.wTransformName.selectAll();
        this.wTransformName.setFocus();
    }

    private void cancel() {
        this.transformName = null;
        this.input.setChanged(this.changed);
        this.dispose();
    }

    private void ok() {
        if (Utils.isEmpty((CharSequence)this.wTransformName.getText())) {
            return;
        }
        int nrFields = this.wFields.nrNonEmpty();
        ArrayList<UniqueField> fields = new ArrayList<UniqueField>(nrFields);
        for (int i = 0; i < nrFields; ++i) {
            TableItem item = this.wFields.getNonEmpty(i);
            UniqueField field = new UniqueField();
            field.setName(item.getText(1));
            field.setCaseInsensitive("Y".equalsIgnoreCase(item.getText(2)));
            fields.add(field);
        }
        this.input.setCountField(this.wCountField.getText());
        this.input.setCountRows(this.wCount.getSelection());
        this.input.setRejectDuplicateRow(this.wRejectDuplicateRow.getSelection());
        this.input.setErrorDescription(this.wErrorDesc.getText());
        this.input.setCompareFields(fields);
        if ("Y".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y"))) {
            MessageDialogWithToggle md = new MessageDialogWithToggle(this.shell, BaseMessages.getString(PKG, (String)"UniqueRowsDialog.InputNeedSort.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UniqueRowsDialog.InputNeedSort.DialogMessage", (String[])new String[]{Const.CR}) + Const.CR, 8, new String[]{BaseMessages.getString(PKG, (String)"UniqueRowsDialog.InputNeedSort.Option1", (String[])new String[0])}, BaseMessages.getString(PKG, (String)"UniqueRowsDialog.InputNeedSort.Option2", (String[])new String[0]), "N".equalsIgnoreCase(this.props.getCustomParameter(STRING_SORT_WARNING_PARAMETER, "Y")));
            md.open();
            this.props.setCustomParameter(STRING_SORT_WARNING_PARAMETER, md.getToggleState() ? "N" : "Y");
        }
        if (!this.wRejectDuplicateRow.getSelection()) {
            List hops = this.pipelineMeta.getPipelineHops();
            IntStream.range(0, hops.size() - 1).filter(hopInd -> {
                PipelineHopMeta hop = (PipelineHopMeta)hops.get(hopInd);
                return hop.isErrorHop() && hop.getFromTransform().getName().equals(this.transformName);
            }).forEach(hopInd -> this.pipelineMeta.removePipelineHop(hopInd));
        }
        this.transformName = this.wTransformName.getText();
        this.dispose();
    }

    private void get() {
        try {
            IRowMeta r = this.pipelineMeta.getPrevTransformFields(this.variables, this.transformName);
            if (r != null && !r.isEmpty()) {
                BaseTransformDialog.getFieldsFromPrevious((IRowMeta)r, (TableView)this.wFields, (int)1, (int[])new int[]{1}, (int[])new int[0], (int)-1, (int)-1, null);
            }
        }
        catch (HopException ke) {
            new ErrorDialog(this.shell, BaseMessages.getString(PKG, (String)"UniqueRowsDialog.FailedToGetFields.DialogTitle", (String[])new String[0]), BaseMessages.getString(PKG, (String)"UniqueRowsDialog.FailedToGetFields.DialogMessage", (String[])new String[0]), (Exception)((Object)ke));
        }
    }
}

