/*
 * Decompiled with CFR 0.152.
 */
package org.odftoolkit.simple.common.navigation;

import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import java.util.TreeMap;
import org.odftoolkit.odfdom.dom.OdfContentDom;
import org.odftoolkit.odfdom.dom.OdfDocumentNamespace;
import org.odftoolkit.odfdom.dom.OdfStylesDom;
import org.odftoolkit.odfdom.dom.element.OdfStylableElement;
import org.odftoolkit.odfdom.dom.element.OdfStyleBase;
import org.odftoolkit.odfdom.dom.element.dc.DcCreatorElement;
import org.odftoolkit.odfdom.dom.element.dc.DcDateElement;
import org.odftoolkit.odfdom.dom.element.office.OfficeAnnotationElement;
import org.odftoolkit.odfdom.dom.element.style.StyleTextPropertiesElement;
import org.odftoolkit.odfdom.dom.element.text.TextAElement;
import org.odftoolkit.odfdom.dom.element.text.TextPElement;
import org.odftoolkit.odfdom.dom.element.text.TextSElement;
import org.odftoolkit.odfdom.dom.element.text.TextSpanElement;
import org.odftoolkit.odfdom.dom.style.OdfStyleFamily;
import org.odftoolkit.odfdom.dom.style.props.OdfStylePropertiesSet;
import org.odftoolkit.odfdom.dom.style.props.OdfStyleProperty;
import org.odftoolkit.odfdom.incubator.doc.office.OdfOfficeAutomaticStyles;
import org.odftoolkit.odfdom.incubator.doc.style.OdfStyle;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextHeading;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextParagraph;
import org.odftoolkit.odfdom.incubator.doc.text.OdfTextSpan;
import org.odftoolkit.odfdom.pkg.OdfElement;
import org.odftoolkit.odfdom.pkg.OdfFileDom;
import org.odftoolkit.simple.Document;
import org.odftoolkit.simple.common.TextExtractor;
import org.odftoolkit.simple.common.navigation.InvalidNavigationException;
import org.odftoolkit.simple.common.navigation.Selection;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextSelection
extends Selection {
    String mMatchedText;
    private OdfTextParagraph mParagraph;
    private OdfTextHeading mHeading;
    private int mIndexInContainer;
    private boolean mIsInserted;

    TextSelection(String text, OdfElement containerElement, int index) {
        this.mMatchedText = text;
        if (containerElement instanceof OdfTextParagraph) {
            this.mParagraph = (OdfTextParagraph)containerElement;
        } else if (containerElement instanceof OdfTextHeading) {
            this.mHeading = (OdfTextHeading)containerElement;
        }
        this.mIndexInContainer = index;
    }

    public static TextSelection newTextSelection(String text, OdfElement containerElement, int index) {
        TextSelection selection = new TextSelection(text, containerElement, index);
        Selection.SelectionManager.registerItem(selection);
        return selection;
    }

    @Override
    public OdfElement getElement() {
        return this.getContainerElement();
    }

    public OdfElement getContainerElement() {
        if (this.mParagraph != null) {
            return this.mParagraph;
        }
        return this.mHeading;
    }

    @Override
    public int getIndex() {
        return this.mIndexInContainer;
    }

    public String getText() {
        return this.mMatchedText;
    }

    @Override
    public void cut() throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement container = this.getContainerElement();
        this.delete(this.mIndexInContainer, this.mMatchedText.length(), (Node)container);
        Selection.SelectionManager.refreshAfterCut(this);
        this.mMatchedText = "";
    }

    public void applyStyle(OdfStyleBase style) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.appendStyle(index, leftLength, (Node)parentElement, style);
    }

    public void replaceWith(String newText) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.delete(index, leftLength, (Node)parentElement);
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
        textSpan.addContentWhitespace(newText);
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, index, (Node)parentElement);
        this.optimize((Node)parentElement);
        int offset = newText.length() - leftLength;
        Selection.SelectionManager.refresh(this.getContainerElement(), offset, index + this.getText().length());
        this.mMatchedText = newText;
    }

    public TextSpanElement createSpanElement() throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.delete(index, leftLength, (Node)parentElement);
        OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)parentElement.getOwnerDocument());
        textSpan.addContentWhitespace(this.getText());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, index, (Node)parentElement);
        this.optimize((Node)parentElement);
        return textSpan;
    }

    @Override
    public void pasteAtFrontOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, indexOfNew, (Node)newElement);
        this.adjustStyle((Node)newElement, textSpan, null);
        Selection.SelectionManager.refreshAfterPasteAtFrontOf(this, positionItem);
    }

    @Override
    public void pasteAtEndOf(Selection positionItem) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        int indexOfNew = 0;
        OdfElement newElement = positionItem.getElement();
        if (positionItem instanceof TextSelection) {
            indexOfNew = ((TextSelection)positionItem).getIndex() + ((TextSelection)positionItem).getText().length();
            newElement = ((TextSelection)positionItem).getContainerElement();
        }
        OdfTextSpan textSpan = this.getSpan((OdfFileDom)positionItem.getElement().getOwnerDocument());
        this.mIsInserted = false;
        this.insertOdfElement((OdfElement)textSpan, indexOfNew, (Node)newElement);
        this.adjustStyle((Node)newElement, textSpan, null);
        Selection.SelectionManager.refreshAfterPasteAtEndOf(this, positionItem);
    }

    public void addHref(URL url) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        int leftLength = this.getText().length();
        int index = this.mIndexInContainer;
        this.addHref(index, leftLength, (Node)parentElement, url.toString());
    }

    public void addComment(String content, String creator) throws InvalidNavigationException {
        if (!this.validate()) {
            throw new InvalidNavigationException("No matched string at this position");
        }
        OdfElement parentElement = this.getContainerElement();
        OdfFileDom dom = (OdfFileDom)parentElement.getOwnerDocument();
        OfficeAnnotationElement annotationElement = (OfficeAnnotationElement)dom.newOdfElement(OfficeAnnotationElement.class);
        DcCreatorElement dcCreatorElement = annotationElement.newDcCreatorElement();
        if (creator == null) {
            creator = System.getProperty("user.name");
        }
        dcCreatorElement.setTextContent(creator);
        String dcDate = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").format(new Date());
        DcDateElement dcDateElement = annotationElement.newDcDateElement();
        dcDateElement.setTextContent(dcDate);
        TextPElement notePElement = annotationElement.newTextPElement();
        TextSpanElement noteSpanElement = notePElement.newTextSpanElement();
        OdfOfficeAutomaticStyles styles = null;
        if (dom instanceof OdfContentDom) {
            styles = ((OdfContentDom)dom).getAutomaticStyles();
        } else if (dom instanceof OdfStylesDom) {
            styles = ((OdfStylesDom)dom).getAutomaticStyles();
        }
        OdfStyle textStyle = styles.newStyle(OdfStyleFamily.Text);
        StyleTextPropertiesElement styleTextPropertiesElement = textStyle.newStyleTextPropertiesElement(null);
        styleTextPropertiesElement.setStyleFontNameAttribute("Tahoma");
        styleTextPropertiesElement.setFoFontSizeAttribute("10pt");
        styleTextPropertiesElement.setStyleFontNameAsianAttribute("Lucida Sans Unicode");
        styleTextPropertiesElement.setStyleFontSizeAsianAttribute("12pt");
        noteSpanElement.setStyleName(textStyle.getStyleNameAttribute());
        noteSpanElement.setTextContent(content);
        this.insertOdfElement((OdfElement)annotationElement, this.mIndexInContainer, (Node)parentElement);
        int offset = content.length() + 1 + dcDate.length() + 1 + creator.length();
        Selection.SelectionManager.refresh(this.getContainerElement(), offset, this.getIndex());
    }

    public String toString() {
        return "[" + this.mMatchedText + "] started from " + this.mIndexInContainer + " in paragraph:" + TextExtractor.getText(this.getContainerElement());
    }

    @Override
    protected void refreshAfterFrontalDelete(Selection deleteItem) {
        if (deleteItem instanceof TextSelection) {
            this.mIndexInContainer -= ((TextSelection)deleteItem).getText().length();
        }
    }

    @Override
    protected void refreshAfterFrontalInsert(Selection pasteItem) {
        if (pasteItem instanceof TextSelection) {
            this.mIndexInContainer += ((TextSelection)pasteItem).getText().length();
        }
    }

    @Override
    protected void refresh(int offset) {
        this.mIndexInContainer += offset;
        if (this.mIndexInContainer < 0) {
            this.mIndexInContainer = 0;
        }
    }

    private OdfTextSpan getSpan(OdfFileDom ownerDoc) {
        OdfElement parentElement = this.getContainerElement();
        if (parentElement != null) {
            OdfElement copyParentNode = (OdfElement)parentElement.cloneNode(true);
            if (ownerDoc != parentElement.getOwnerDocument()) {
                copyParentNode = (OdfElement)ownerDoc.adoptNode((Node)copyParentNode);
            }
            OdfTextSpan textSpan = new OdfTextSpan(ownerDoc);
            int sIndex = this.mIndexInContainer;
            int eIndex = sIndex + this.mMatchedText.length();
            this.delete(eIndex, TextExtractor.getText(copyParentNode).length() - eIndex, (Node)copyParentNode);
            this.delete(0, sIndex, (Node)copyParentNode);
            this.optimize((Node)copyParentNode);
            for (Node childNode = copyParentNode.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
                textSpan.appendChild(childNode.cloneNode(true));
            }
            if (copyParentNode instanceof OdfStylableElement) {
                this.applyTextStyleProperties(this.getTextStylePropertiesDeep((OdfStylableElement)copyParentNode), (OdfStylableElement)textSpan);
            }
            return textSpan;
        }
        return null;
    }

    private void optimize(Node pNode) {
        Node node = pNode.getFirstChild();
        while (node != null) {
            Node nextNode = node.getNextSibling();
            if (node instanceof OdfTextSpan) {
                if (TextExtractor.getText((OdfElement)((OdfTextSpan)node)).length() == 0) {
                    node.getParentNode().removeChild(node);
                } else {
                    this.optimize(node);
                }
            }
            node = nextNode;
        }
    }

    private void applyTextStyleProperties(Map<OdfStyleProperty, String> styleMap, OdfStylableElement toElement) {
        if (styleMap != null) {
            OdfStyle resultStyleElement = toElement.getAutomaticStyles().newStyle(OdfStyleFamily.Text);
            for (Map.Entry<OdfStyleProperty, String> entry : styleMap.entrySet()) {
                if (toElement.hasProperty(entry.getKey())) {
                    resultStyleElement.setProperty(entry.getKey(), toElement.getProperty(entry.getKey()));
                    continue;
                }
                resultStyleElement.setProperty(entry.getKey(), entry.getValue());
            }
            toElement.setStyleName(resultStyleElement.getStyleNameAttribute());
        }
    }

    private void insertOdfElement(OdfElement odfElement, int fromIndex, Node pNode) {
        if (fromIndex < 0) {
            fromIndex = 0;
        }
        if (fromIndex == 0 && this.mIsInserted) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex <= 0 && this.mIsInserted) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
                if (fromIndex != 0 && nodeLength < fromIndex) {
                    fromIndex -= nodeLength;
                    continue;
                }
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                node.setNodeValue(buffer.toString());
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                Node newNode = node.cloneNode(true);
                newNode.setNodeValue(value.substring(fromIndex, value.length()));
                if (nextNode != null) {
                    parNode.insertBefore((Node)odfElement, nextNode);
                    parNode.insertBefore(newNode, nextNode);
                } else {
                    parNode.appendChild((Node)odfElement);
                    parNode.appendChild(newNode);
                }
                this.mIsInserted = true;
                return;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                try {
                    nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                }
                catch (Exception e) {
                    nodeLength = 1;
                }
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getLocalName().equals("line-break")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            if (node.getLocalName().equals("tab")) {
                nodeLength = 1;
                --fromIndex;
                continue;
            }
            nodeLength = TextExtractor.getText((OdfElement)node).length();
            this.insertOdfElement(odfElement, fromIndex, node);
            fromIndex -= nodeLength;
        }
    }

    private void adjustStyle(Node parentNode, OdfTextSpan textSpan, Map<OdfStyleProperty, String> styleMap) {
        if (parentNode instanceof OdfStylableElement) {
            OdfStylableElement pStyleNode = (OdfStylableElement)parentNode;
            if (styleMap == null) {
                styleMap = this.getTextStylePropertiesDeep(pStyleNode);
            }
            for (Node node = parentNode.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (node.getNodeType() == 3) {
                    if (node.getTextContent().length() <= 0) continue;
                    Node nextNode = node.getNextSibling();
                    OdfTextSpan span = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                    span.appendChild(node);
                    if (nextNode != null) {
                        parentNode.insertBefore((Node)span, nextNode);
                    } else {
                        parentNode.appendChild((Node)span);
                    }
                    node = span;
                    this.applyTextStyleProperties(styleMap, (OdfStylableElement)node);
                    continue;
                }
                if (!(node instanceof OdfStylableElement) || node.equals(textSpan)) continue;
                Map<OdfStyleProperty, String> styles = this.getTextStylePropertiesDeep(pStyleNode);
                Map<OdfStyleProperty, String> styles1 = this.getTextStylePropertiesDeep((OdfStylableElement)node);
                if (styles == null) {
                    styles = styles1;
                } else if (styles1 != null) {
                    styles.putAll(styles1);
                }
                short comp = node.compareDocumentPosition((Node)textSpan);
                if ((comp & 0x10) > 0) {
                    this.adjustStyle(node, textSpan, styles);
                    continue;
                }
                this.applyTextStyleProperties(styles, (OdfStylableElement)node);
            }
            pStyleNode.removeAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "style-name");
        }
    }

    private void delete(int fromIndex, int leftLength, Node pNode) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                StringBuffer buffer = new StringBuffer();
                buffer.append(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                fromIndex = 0;
                if (nextLength >= 0) {
                    buffer.append(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    leftLength = endLength - value.length();
                }
                node.setNodeValue(buffer.toString());
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.delete(fromIndex, leftLength, node);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    private void addHref(int fromIndex, int leftLength, Node pNode, String href) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                TextAElement textLink = new TextAElement((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textLink.setTextContent(value.substring(fromIndex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textLink.setTextContent(value.substring(fromIndex, value.length()));
                    leftLength = endLength - value.length();
                }
                textLink.setXlinkTypeAttribute("simple");
                textLink.setXlinkHrefAttribute(href);
                if (nextNode != null) {
                    parNode.insertBefore((Node)textLink, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild((Node)textLink);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromIndex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textLink;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.addHref(fromIndex, leftLength, node, href);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }

    private Map<OdfStyleProperty, String> getTextStyleProperties(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyle styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        if (styleElement != null) {
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((Document)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
            OdfStyleFamily family = OdfStyleFamily.Text;
            if (family != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            return result;
        }
        return null;
    }

    private Map<OdfStyleProperty, String> getTextStylePropertiesDeep(OdfStylableElement element) {
        String styleName = element.getStyleName();
        OdfStyle styleElement = element.getAutomaticStyles().getStyle(styleName, element.getStyleFamily());
        if (styleElement == null) {
            styleElement = element.getDocumentStyle();
        }
        TreeMap<OdfStyleProperty, String> result = new TreeMap<OdfStyleProperty, String>();
        while (styleElement != null) {
            OdfStyleFamily family;
            if (styleElement.getPropertiesElement(OdfStylePropertiesSet.ParagraphProperties) == null && styleElement.getPropertiesElement(OdfStylePropertiesSet.TextProperties) == null) {
                styleElement = ((Document)((OdfFileDom)styleElement.getOwnerDocument()).getDocument()).getDocumentStyles().getDefaultStyle(styleElement.getFamily());
            }
            if ((family = OdfStyleFamily.Text) != null) {
                for (OdfStyleProperty property : family.getProperties()) {
                    if (!styleElement.hasProperty(property)) continue;
                    result.put(property, styleElement.getProperty(property));
                }
            }
            styleElement = styleElement.getParentStyle();
        }
        return result;
    }

    private boolean validate() {
        if (this.getContainerElement() == null) {
            return false;
        }
        OdfElement container = this.getContainerElement();
        if (container == null) {
            return false;
        }
        String content = TextExtractor.getText(container);
        return content.indexOf(this.mMatchedText, this.mIndexInContainer) == this.mIndexInContainer;
    }

    private void appendStyle(int fromIndex, int leftLength, Node pNode, OdfStyleBase style) {
        if (fromIndex == 0 && leftLength == 0) {
            return;
        }
        int nodeLength = 0;
        for (Node node = pNode.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (fromIndex == 0 && leftLength == 0) {
                return;
            }
            if (node.getNodeType() == 3) {
                nodeLength = node.getNodeValue().length();
            } else if (node.getNodeType() == 1) {
                if (node.getLocalName().equals("s")) {
                    try {
                        nodeLength = Integer.parseInt(((Element)node).getAttributeNS(OdfDocumentNamespace.TEXT.getUri(), "c"));
                    }
                    catch (Exception e) {
                        nodeLength = 1;
                    }
                } else {
                    nodeLength = node.getLocalName().equals("line-break") ? 1 : (node.getLocalName().equals("tab") ? 1 : TextExtractor.getText((OdfElement)node).length());
                }
            }
            if (nodeLength <= fromIndex) {
                fromIndex -= nodeLength;
                continue;
            }
            if (node.getNodeType() == 3) {
                String value = node.getNodeValue();
                node.setNodeValue(value.substring(0, fromIndex));
                int endLength = fromIndex + leftLength;
                int nextLength = value.length() - endLength;
                Node nextNode = node.getNextSibling();
                Node parNode = node.getParentNode();
                OdfTextSpan textSpan = new OdfTextSpan((OdfFileDom)node.getOwnerDocument());
                Node newNode = null;
                if (nextLength >= 0) {
                    textSpan.setTextContent(value.substring(fromIndex, endLength));
                    newNode = node.cloneNode(true);
                    newNode.setNodeValue(value.substring(endLength, value.length()));
                    leftLength = 0;
                } else {
                    textSpan.setTextContent(value.substring(fromIndex, value.length()));
                    leftLength = endLength - value.length();
                }
                textSpan.setProperties(style.getStyleProperties());
                if (nextNode != null) {
                    parNode.insertBefore((Node)textSpan, nextNode);
                    if (newNode != null) {
                        parNode.insertBefore(newNode, nextNode);
                    }
                } else {
                    parNode.appendChild((Node)textSpan);
                    if (newNode != null) {
                        parNode.appendChild(newNode);
                    }
                }
                fromIndex = 0;
                if (nextNode != null) {
                    node = nextNode;
                    continue;
                }
                node = textSpan;
                continue;
            }
            if (node.getNodeType() != 1) continue;
            if (node.getLocalName().equals("s")) {
                ((TextSElement)node).setTextCAttribute(new Integer(nodeLength - fromIndex));
                leftLength -= nodeLength - fromIndex;
                fromIndex = 0;
                continue;
            }
            if (node.getLocalName().equals("line-break") || node.getLocalName().equals("tab")) {
                fromIndex = 0;
                --leftLength;
                continue;
            }
            this.appendStyle(fromIndex, leftLength, node, style);
            int length = fromIndex + leftLength - nodeLength;
            leftLength = length > 0 ? length : 0;
            fromIndex = 0;
        }
    }
}

