/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.cluster.impl;

import java.lang.invoke.MethodHandles;
import java.util.Collections;
import java.util.List;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.RefCountMessage;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.Consumer;
import org.apache.activemq.artemis.core.server.HandleStatus;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Redistributor
implements Consumer {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private boolean active;
    private final PostOffice postOffice;
    private final Queue queue;
    private final long sequentialID;

    public Redistributor(Queue queue, long sequentialID, PostOffice postOffice) {
        this.queue = queue;
        this.sequentialID = sequentialID;
        this.postOffice = postOffice;
    }

    @Override
    public long sequentialID() {
        return this.sequentialID;
    }

    @Override
    public Filter getFilter() {
        return null;
    }

    @Override
    public String debug() {
        return this.toString();
    }

    @Override
    public String toManagementString() {
        return "Redistributor[" + this.queue.getName() + "/" + this.queue.getID() + "]";
    }

    @Override
    public void disconnect() {
    }

    public synchronized void start() {
        this.active = true;
    }

    public synchronized void stop() throws Exception {
        this.active = false;
    }

    public synchronized void close() {
        this.active = false;
    }

    @Override
    public synchronized HandleStatus handle(MessageReference reference) throws Exception {
        Pair<RoutingContext, Message> routingInfo;
        if (!this.active) {
            return HandleStatus.BUSY;
        }
        if (reference.getMessage().getGroupID() != null) {
            return HandleStatus.NO_MATCH;
        }
        if (logger.isDebugEnabled()) {
            logger.debug("Redistributing message {}, originatingQueue={}", (Object)reference.getMessage(), (Object)this.queue.getName());
        }
        if ((routingInfo = this.postOffice.redistribute(reference.getMessage(), this.queue)) == null) {
            logger.debug("postOffice.redistribute return null for message {}", (Object)reference);
            return HandleStatus.BUSY;
        }
        RoutingContext context = (RoutingContext)routingInfo.getA();
        Message message = (Message)routingInfo.getB();
        try {
            this.postOffice.processRoute(message, context, false);
            if (RefCountMessage.isRefTraceEnabled()) {
                RefCountMessage.deferredDebug((Message)reference.getMessage(), (String)"redistributing", (Object[])new Object[0]);
            }
            this.ackRedistribution(reference, context.getTransaction());
        }
        catch (Throwable e) {
            if (context.getTransaction() != null) {
                context.getTransaction().setAsync(true).rollback();
            }
            ActiveMQServerLogger.LOGGER.errorRedistributing(String.valueOf(this.queue.getName()), String.valueOf(message), e);
            return HandleStatus.NO_MATCH;
        }
        return HandleStatus.HANDLED;
    }

    @Override
    public void proceedDeliver(MessageReference ref) {
    }

    @Override
    public void failed(Throwable t) {
    }

    private void ackRedistribution(MessageReference reference, Transaction tx) throws Exception {
        reference.handled();
        this.queue.acknowledge(tx, reference);
        tx.commit();
    }

    @Override
    public List<MessageReference> getDeliveringMessages() {
        return Collections.emptyList();
    }
}

