/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.server.management;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.rmi.server.RMIServerSocketFactory;
import java.rmi.server.UnicastRemoteObject;
import javax.net.ServerSocketFactory;
import javax.net.SocketFactory;

public class RmiRegistryFactory {
    private int port = 1099;
    private Registry registry;
    private String host;
    private HostLimitedServerSocketFactory socketFactory;

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    ServerSocket createTestSocket() throws IOException {
        return this.socketFactory.createServerSocket(0);
    }

    public Object getObject() throws Exception {
        return this.registry;
    }

    public void init() throws RemoteException, UnknownHostException {
        this.socketFactory = new HostLimitedServerSocketFactory();
        this.registry = LocateRegistry.createRegistry(this.port, new PassThroughToDefaultSocketFactory(), this.socketFactory);
    }

    public void destroy() throws RemoteException {
        if (this.registry != null) {
            UnicastRemoteObject.unexportObject(this.registry, true);
        }
    }

    private static class PassThroughToDefaultSocketFactory
    implements RMIClientSocketFactory {
        private PassThroughToDefaultSocketFactory() {
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return SocketFactory.getDefault().createSocket(host, port);
        }
    }

    class HostLimitedServerSocketFactory
    implements RMIServerSocketFactory {
        HostLimitedServerSocketFactory() {
        }

        @Override
        public ServerSocket createServerSocket(int port) throws IOException {
            InetAddress hostAddress = RmiRegistryFactory.this.host != null ? InetAddress.getByName(RmiRegistryFactory.this.host) : null;
            return ServerSocketFactory.getDefault().createServerSocket(port, 0, hostAddress);
        }
    }
}

