/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.runtime.parser.node;

import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.StringUtils;
import org.apache.velocity.exception.VelocityException;
import org.apache.velocity.runtime.parser.node.SetExecutor;
import org.apache.velocity.util.introspection.Introspector;
import org.slf4j.Logger;

public class SetPropertyExecutor
extends SetExecutor {
    private final Introspector introspector;

    public SetPropertyExecutor(Logger logger, Introspector introspector, Class clazz, String string, Object object) {
        this.log = logger;
        this.introspector = introspector;
        if (StringUtils.isNotEmpty(string)) {
            this.discover(clazz, string, object);
        }
    }

    protected Introspector getIntrospector() {
        return this.introspector;
    }

    protected void discover(Class clazz, String string, Object object) {
        Object[] objectArray = new Object[]{object};
        try {
            StringBuilder stringBuilder = new StringBuilder("set");
            stringBuilder.append(string);
            this.setMethod(this.introspector.getMethod(clazz, stringBuilder.toString(), objectArray));
            if (!this.isAlive()) {
                char c = stringBuilder.charAt(3);
                if (Character.isLowerCase(c)) {
                    stringBuilder.setCharAt(3, Character.toUpperCase(c));
                } else {
                    stringBuilder.setCharAt(3, Character.toLowerCase(c));
                }
                this.setMethod(this.introspector.getMethod(clazz, stringBuilder.toString(), objectArray));
            }
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            String string2 = "Exception while looking for property setter for '" + string;
            this.log.error(string2, exception);
            throw new VelocityException(string2, exception);
        }
    }

    @Override
    public Object execute(Object object, Object object2) throws IllegalAccessException, InvocationTargetException {
        Object[] objectArray = new Object[]{object2};
        return this.isAlive() ? this.getMethod().invoke(object, objectArray) : null;
    }
}

