/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.configuration;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;

public class SAXNestedTagHandler
extends DefaultHandler {
    private static final Locator NOOP_LOCATOR = new Locator(){

        public int getColumnNumber() {
            return -1;
        }

        public int getLineNumber() {
            return -1;
        }

        public String getPublicId() {
            return "<unknown>";
        }

        public String getSystemId() {
            return "<unknown>";
        }
    };
    protected XMLReader parser;
    protected ContentHandler parentHandler;
    protected Locator locator;

    public SAXNestedTagHandler(XMLReader parser, SAXNestedTagHandler parentHandler) {
        this.parentHandler = parentHandler;
        this.parser = parser;
        if (parentHandler != null) {
            this.locator = parentHandler.locator;
        }
        if (this.locator == null) {
            this.locator = NOOP_LOCATOR;
        }
    }

    protected String unexpectedTagMessage(String tagFound, String ... tagsExpected) {
        List<Object> expected = tagsExpected != null ? Arrays.asList(tagsExpected) : Collections.emptyList();
        return String.format("tag <%s> is unexpected at [%d,%d]. The following tags are allowed here: %s", tagFound, this.locator.getColumnNumber(), this.locator.getLineNumber(), expected);
    }

    protected ContentHandler createChildTagHandler(String namespaceURI, String localName, String qName, Attributes attributes) {
        return new SAXNestedTagHandler(this.parser, this);
    }

    protected void stop() {
        this.parser.setContentHandler(this.parentHandler);
    }

    public final void startElement(String namespaceURI, String localName, String qName, Attributes attributes) throws SAXException {
        ContentHandler childHandler = this.createChildTagHandler(namespaceURI, localName, qName, attributes);
        this.parser.setContentHandler(childHandler);
    }

    public void endElement(String namespaceURI, String localName, String qName) throws SAXException {
        this.stop();
    }

    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }
}

