/* THIS FILE IS AUTOGENERATED FROM MediaKeyMessageEvent.webidl BY Codegen.py - DO NOT EDIT */

#ifndef mozilla_dom_MediaKeyMessageEventBinding_h
#define mozilla_dom_MediaKeyMessageEventBinding_h

#include "EventBinding.h"
#include "js/CallAndConstruct.h"
#include "js/RootingAPI.h"
#include "js/TypeDecls.h"
#include "mozilla/ArrayUtils.h"
#include "mozilla/Span.h"
#include "mozilla/dom/BindingDeclarations.h"
#include "mozilla/dom/Nullable.h"
#include "mozilla/dom/PrototypeList.h"
#include "mozilla/dom/TypedArray.h"

namespace mozilla {
namespace dom {

class MediaKeyMessageEvent;
struct MediaKeyMessageEventInitAtoms;
struct NativePropertyHooks;
class ProtoAndIfaceCache;

} // namespace dom
} // namespace mozilla

namespace mozilla::dom {

enum class MediaKeyMessageType : uint8_t {
  License_request,
  License_renewal,
  License_release,
  Individualization_request,
  EndGuard_
};

namespace MediaKeyMessageTypeValues {
extern const EnumEntry strings[5];

static constexpr size_t Count = 4;

// Our "strings" contains an extra entry with a null string.
static_assert(mozilla::ArrayLength(strings) - 1 == Count,
              "Mismatch between enum strings and enum count");

static_assert(static_cast<size_t>(MediaKeyMessageType::EndGuard_) == Count,
              "Mismatch between enum value and enum count");

inline auto GetString(MediaKeyMessageType stringId) {
  MOZ_ASSERT(static_cast<uint8_t>(stringId) < Count);
  const EnumEntry& entry = strings[static_cast<uint8_t>(stringId)];
  return Span<const char>{entry.value, entry.length};
}
} // namespace MediaKeyMessageTypeValues

bool
ToJSValue(JSContext* aCx, MediaKeyMessageType aArgument, JS::MutableHandle<JS::Value> aValue);


struct MediaKeyMessageEventInit : public EventInit
{
  MOZ_INIT_OUTSIDE_CTOR ArrayBuffer mMessage;
  MOZ_INIT_OUTSIDE_CTOR MediaKeyMessageType mMessageType;

  MediaKeyMessageEventInit();

  explicit inline MediaKeyMessageEventInit(const FastDictionaryInitializer& )
    : EventInit(FastDictionaryInitializer())
  {
    // Do nothing here; this is used by our "Fast" subclass
  }

  MediaKeyMessageEventInit(MediaKeyMessageEventInit&& aOther) = default;

private:
  MediaKeyMessageEventInit(const MediaKeyMessageEventInit&) = delete;
  MediaKeyMessageEventInit& operator=(const MediaKeyMessageEventInit&) = delete;

  static bool
  InitIds(JSContext* cx, MediaKeyMessageEventInitAtoms* atomsCache);

public:
  bool
  Init(BindingCallContext& cx, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  bool
  Init(JSContext* cx_, JS::Handle<JS::Value> val, const char* sourceDescription = "Value", bool passedToJSImpl = false);

  void
  TraceDictionary(JSTracer* trc);
};

namespace binding_detail {
struct FastMediaKeyMessageEventInit : public MediaKeyMessageEventInit
{
  inline FastMediaKeyMessageEventInit()
    : MediaKeyMessageEventInit(FastDictionaryInitializer())
  {
    // Doesn't matter what int we pass to the parent constructor
  }
};
} // namespace binding_detail


namespace MediaKeyMessageEvent_Binding {

  typedef mozilla::dom::MediaKeyMessageEvent NativeType;

  bool
  Wrap(JSContext* aCx, mozilla::dom::MediaKeyMessageEvent* aObject, nsWrapperCache* aCache, JS::Handle<JSObject*> aGivenProto, JS::MutableHandle<JSObject*> aReflector);

  template <class T>
  inline JSObject* Wrap(JSContext* aCx, T* aObject, JS::Handle<JSObject*> aGivenProto)
  {
    JS::Rooted<JSObject*> reflector(aCx);
    return Wrap(aCx, aObject, aObject, aGivenProto, &reflector) ? reflector.get() : nullptr;
  }

  void
  CreateInterfaceObjects(JSContext* aCx, JS::Handle<JSObject*> aGlobal, ProtoAndIfaceCache& aProtoAndIfaceCache, DefineInterfaceProperty aDefineOnGlobal);

  inline JS::Handle<JSObject*> GetProtoObjectHandle(JSContext* aCx)
  {
    /* Get the interface prototype object for this class.  This will create the
       object as needed. */
    return GetPerInterfaceObjectHandle(aCx, prototypes::id::MediaKeyMessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);

  }

  inline JS::Handle<JSObject*> GetConstructorObjectHandle(JSContext* aCx)
  {
    /* Get the interface object for this class.  This will create the object as
       needed. */

    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaKeyMessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::CheckExposure);
  }

  JSObject*
  GetConstructorObject(JSContext* aCx);

  inline bool CreateAndDefineOnGlobal(JSContext* aCx)
  {
    // Get the interface or namespace object for this class. This will
    // create the object as needed and always define the properties for
    // it on the global. The caller should make sure the interface or
    // namespace is exposed on the global before calling this.
    return GetPerInterfaceObjectHandle(aCx, constructors::id::MediaKeyMessageEvent,
                                       &CreateInterfaceObjects,
                                       DefineInterfaceProperty::Always);

  }

} // namespace MediaKeyMessageEvent_Binding



} // namespace mozilla::dom

#endif // mozilla_dom_MediaKeyMessageEventBinding_h
