/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wildwebdeveloper.tests;

import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4j.Hover;
import org.eclipse.lsp4j.HoverParams;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.services.LanguageServer;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.tests.harness.util.DisplayHelper;
import org.eclipse.ui.texteditor.AbstractTextEditor;
import org.eclipse.ui.texteditor.ITextEditor;
import org.eclipse.wildwebdeveloper.tests.AllCleanRule;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={AllCleanRule.class})
public class TestTypeScript {
    private IProject project;

    @BeforeEach
    public void setUpProject() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(this.getClass().getName() + System.nanoTime());
        this.project.create(null);
        this.project.open(null);
        IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IViewReference[] iViewReferenceArray = activePage.getViewReferences();
        int n = iViewReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IViewReference ref = iViewReferenceArray[n2];
            activePage.hideView(ref);
            ++n2;
        }
    }

    @Test
    public void testHTMLinTSXFile() throws Exception {
        IFile file = this.project.getFile("test.tsx");
        file.create(this.getClass().getResourceAsStream("/testProjects/htmlIn.tsx"), true, null);
        AbstractTextEditor editor = (AbstractTextEditor)IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)file);
        IDocument document = LSPEclipseUtils.getDocument((ITextEditor)editor);
        DisplayHelper.sleep((long)2000L);
        HoverParams params = new HoverParams(new TextDocumentIdentifier(LSPEclipseUtils.toUri((IDocument)document).toString()), new Position(0, 18));
        ArrayList languageServers = new ArrayList();
        ((CompletableFuture)((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)document).withCapability(ServerCapabilities::getHoverProvider)).collectAll((w, ls) -> CompletableFuture.completedFuture(ls)).thenAccept(languageServers::addAll)).get(500L, TimeUnit.MILLISECONDS);
        Assertions.assertFalse((boolean)languageServers.isEmpty());
        Hover hover = (Hover)((LanguageServer)languageServers.get(0)).getTextDocumentService().hover(params).get();
        Assertions.assertTrue((boolean)hover.getContents().toString().contains("button"));
    }
}

