/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.filepath.participants;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.Predicate;
import org.eclipse.lemminx.utils.FilesUtils;
import org.eclipse.lemminx.utils.StringUtils;

public class FilePathCompletionResult {
    private static final Predicate<Character> isStartValidCharForSimplePath = c -> c.charValue() != '/' && c.charValue() != '\\';
    private final int startOffset;
    private final int endOffset;
    private final Path baseDir;

    public FilePathCompletionResult(int startOffset, int endOffset, Path baseDir) {
        this.startOffset = startOffset;
        this.endOffset = endOffset;
        this.baseDir = baseDir;
    }

    public int getStartOffset() {
        return this.startOffset;
    }

    public int getEndOffset() {
        return this.endOffset;
    }

    public Path getBaseDir() {
        return this.baseDir;
    }

    public static FilePathCompletionResult create(String content, String fileUri, int startNodeOffset, int endNodeOffset, int completionOffset, Character separator) {
        Path baseDir;
        int tmp;
        boolean isMultiFilePath = separator != null;
        Predicate<Character> isStartValidChar = isStartValidCharForSimplePath;
        int endPathOffset = endNodeOffset;
        if (isMultiFilePath) {
            isStartValidChar = c -> c != separator && isStartValidCharForSimplePath.test((Character)c);
            endPathOffset = StringUtils.findEndWord(content, completionOffset - 1, endNodeOffset, c -> c != separator);
            if (endPathOffset == -1) {
                endPathOffset = endNodeOffset;
            }
        }
        int startPathOffset = StringUtils.findStartWord(content, completionOffset, startNodeOffset, isStartValidChar);
        int startBaseDirOffset = startNodeOffset;
        if (isMultiFilePath && !isStartValidChar.test(Character.valueOf(content.charAt(startPathOffset - 1))) && (tmp = StringUtils.findStartWord(content, completionOffset, startNodeOffset, c -> c != separator)) != -1) {
            startBaseDirOffset = tmp;
        }
        if ((baseDir = FilePathCompletionResult.getBaseDir(content, fileUri, startBaseDirOffset, startPathOffset)) == null || !Files.exists(baseDir, new LinkOption[0])) {
            baseDir = null;
        }
        return new FilePathCompletionResult(startPathOffset, endPathOffset, baseDir);
    }

    private static Path getBaseDir(String content, String fileUri, int start, int end) {
        if (end > start) {
            String basePath = content.substring(start, end);
            if (!FilePathCompletionResult.hasPathBeginning(basePath)) {
                try {
                    Path baseDir = FilesUtils.getPath(basePath);
                    if (Files.exists(baseDir, new LinkOption[0])) {
                        return baseDir;
                    }
                }
                catch (Exception baseDir) {
                    // empty catch block
                }
            }
            try {
                return FilesUtils.getPath(fileUri).getParent().resolve(basePath);
            }
            catch (Exception e) {
                return null;
            }
        }
        return FilesUtils.getPath(fileUri).getParent();
    }

    private static boolean hasPathBeginning(String currentText) {
        if (currentText.startsWith("/") || currentText.startsWith("./") || currentText.startsWith("../") || currentText.startsWith("..\\") || currentText.startsWith(".\\")) {
            return true;
        }
        return FilePathCompletionResult.isAbsoluteWindowsPath(currentText);
    }

    private static boolean isAbsoluteWindowsPath(String currentText) {
        if (currentText.length() < 3) {
            return false;
        }
        if (!Character.isLetter(currentText.charAt(0))) {
            return false;
        }
        return currentText.charAt(1) == ':' && (currentText.charAt(2) == '\\' || currentText.charAt(2) == '/');
    }
}

