/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lemminx.extensions.references.participants;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.lemminx.dom.DOMAttr;
import org.eclipse.lemminx.dom.DOMDocument;
import org.eclipse.lemminx.dom.DOMElement;
import org.eclipse.lemminx.dom.DOMNode;
import org.eclipse.lemminx.extensions.references.XMLReferencesPlugin;
import org.eclipse.lemminx.extensions.references.search.ReferenceLink;
import org.eclipse.lemminx.extensions.references.search.SearchEngine;
import org.eclipse.lemminx.extensions.references.search.SearchNode;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensParticipant;
import org.eclipse.lemminx.services.extensions.codelens.ICodeLensRequest;
import org.eclipse.lemminx.services.extensions.codelens.ReferenceCommand;
import org.eclipse.lemminx.utils.XMLPositionUtility;
import org.eclipse.lsp4j.CodeLens;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.jsonrpc.CancelChecker;

public class XMLReferencesCodeLensParticipant
implements ICodeLensParticipant {
    private final XMLReferencesPlugin plugin;

    public XMLReferencesCodeLensParticipant(XMLReferencesPlugin plugin) {
        this.plugin = plugin;
    }

    @Override
    public void doCodeLens(ICodeLensRequest request, List<CodeLens> lenses, CancelChecker cancelChecker) {
        DOMDocument document = request.getDocument();
        Collection<ReferenceLink> links = SearchEngine.getInstance().searchLinks(document, this.plugin.getReferencesSettings(), cancelChecker);
        if (links.isEmpty()) {
            return;
        }
        boolean supportedByClient = request.isSupportedByClient("references");
        HashMap<DOMElement, CodeLens> cache = new HashMap<DOMElement, CodeLens>();
        for (ReferenceLink link : links) {
            for (SearchNode to : link.getTos()) {
                DOMNode toNode;
                DOMElement toElement;
                if (document != to.getOwnerDocument() || (toElement = (toNode = to.getNode()).isAttribute() ? ((DOMAttr)toNode).getOwnerElement() : toNode.getParentElement()) == null) continue;
                for (SearchNode from : link.getFroms()) {
                    if (!from.matchesValue(to)) continue;
                    CodeLens codeLens = (CodeLens)cache.get(toElement);
                    if (codeLens == null) {
                        Range range = XMLPositionUtility.createRange(toNode);
                        codeLens = new CodeLens(range);
                        codeLens.setCommand(new ReferenceCommand(document.getDocumentURI(), range.getStart(), supportedByClient));
                        cache.put(toElement, codeLens);
                        lenses.add(codeLens);
                        continue;
                    }
                    ((ReferenceCommand)codeLens.getCommand()).increment();
                }
            }
        }
    }
}

