/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.Messages;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryAnalysisModule;
import org.eclipse.tracecompass.internal.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.dataprovider.IDataProviderFactory;
import org.eclipse.tracecompass.tmf.core.model.DataProviderDescriptor;
import org.eclipse.tracecompass.tmf.core.model.tree.ITmfTreeDataModel;
import org.eclipse.tracecompass.tmf.core.model.xy.ITmfTreeXYDataProvider;
import org.eclipse.tracecompass.tmf.core.model.xy.TmfTreeXYCompositeDataProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceManager;
import org.eclipse.tracecompass.tmf.core.trace.TmfTraceUtils;

public class UstMemoryDataProviderFactory
implements IDataProviderFactory {
    private static final @NonNull String TITLE = Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title);
    private static final Predicate<? super ITmfTrace> PREDICATE = t -> TmfTraceUtils.getAnalysisModuleOfClass((ITmfTrace)t, UstMemoryAnalysisModule.class, (String)"org.eclipse.linuxtools.lttng2.ust.analysis.memory") != null;
    private static final IDataProviderDescriptor DESCRIPTOR = new DataProviderDescriptor.Builder().setId("org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider").setName(Objects.requireNonNull(Messages.MemoryUsageDataProvider_Title)).setDescription(Objects.requireNonNull(Messages.UstMemoryDataProviderFactory_DescriptionText)).setProviderType(IDataProviderDescriptor.ProviderType.TREE_TIME_XY).build();

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    public @Nullable ITmfTreeXYDataProvider<? extends ITmfTreeDataModel> createProvider(@NonNull ITmfTrace trace) {
        @NonNull Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        if (traces.size() == 1) {
            return UstMemoryUsageDataProvider.create(trace);
        }
        return TmfTreeXYCompositeDataProvider.create((Collection)traces, (String)TITLE, (String)"org.eclipse.tracecompass.lttng2.ust.core.analysis.memory.UstMemoryUsageDataProvider");
    }

    public Collection<IDataProviderDescriptor> getDescriptors(@NonNull ITmfTrace trace) {
        Collection traces = TmfTraceManager.getTraceSet((ITmfTrace)trace);
        return Iterables.any((Iterable)traces, PREDICATE) ? Collections.singletonList(DESCRIPTOR) : Collections.emptyList();
    }
}

