/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.core.parser.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class Profiler {
    private Map<String, Timer> timers = new HashMap<String, Timer>();
    private Map<String, int[]> counters = new HashMap<String, int[]>();
    private static ThreadLocal<Profiler> threadProfiler = new ThreadLocal();

    private Profiler() {
    }

    public static void startTimer(String name) {
        Profiler profiler = threadProfiler.get();
        if (profiler != null) {
            Timer timer = profiler.timers.get(name);
            if (timer == null) {
                timer = new Timer();
                profiler.timers.put(name, timer);
            }
            timer.recordEntry();
        }
    }

    public static void stopTimer(String name) {
        Profiler profiler = threadProfiler.get();
        if (profiler != null) {
            Timer timer = profiler.timers.get(name);
            timer.recordExit();
        }
    }

    public static void incrementCounter(String name) {
        Profiler profiler = threadProfiler.get();
        if (profiler != null) {
            int[] n = profiler.counters.get(name);
            if (n == null) {
                n = new int[]{1};
            } else {
                n[0] = n[0] + 1;
            }
            profiler.counters.put(name, n);
        }
    }

    public static void activate() {
        threadProfiler.set(new Profiler());
    }

    public static void deactivate() {
        threadProfiler.set(null);
    }

    public static void printStats() {
        Profiler profiler = threadProfiler.get();
        if (profiler != null) {
            ArrayList<Map.Entry<String, Timer>> list = new ArrayList<Map.Entry<String, Timer>>(profiler.timers.entrySet());
            Comparator<Map.Entry<String, Timer>> c = new Comparator<Map.Entry<String, Timer>>(){

                @Override
                public int compare(Map.Entry<String, Timer> o1, Map.Entry<String, Timer> o2) {
                    long diff = o2.getValue().getElapsedTime() - o1.getValue().getElapsedTime();
                    return diff < 0L ? -1 : (diff > 0L ? 1 : 0);
                }
            };
            Collections.sort(list, c);
            System.out.println("===");
            for (Map.Entry entry : list) {
                System.out.println("===\t" + (((Timer)entry.getValue()).getElapsedTime() + 500000L) / 1000000L + "\t" + ((Timer)entry.getValue()).getCounter() + "\t" + (String)entry.getKey());
            }
            if (!profiler.counters.isEmpty()) {
                ArrayList<Map.Entry<String, int[]>> arrayList = new ArrayList<Map.Entry<String, int[]>>(profiler.counters.entrySet());
                Comparator<Map.Entry<String, int[]>> c2 = new Comparator<Map.Entry<String, int[]>>(){

                    @Override
                    public int compare(Map.Entry<String, int[]> o1, Map.Entry<String, int[]> o2) {
                        return o2.getValue()[0] - o1.getValue()[0];
                    }
                };
                Collections.sort(arrayList, c2);
                System.out.println("===");
                System.out.println("===\t" + profiler.counters.size() + " counters");
                for (Map.Entry entry : arrayList) {
                    System.out.println("===\t" + ((int[])entry.getValue())[0] + "\t" + (String)entry.getKey());
                }
            }
        }
    }

    private static class Timer {
        long elapsedTime;
        long counter;
        long startTime;
        int recursionDepth;

        private Timer() {
        }

        final long getElapsedTime() {
            return this.elapsedTime;
        }

        final long getCounter() {
            return this.counter;
        }

        final void recordEntry() {
            if (this.recursionDepth++ == 0) {
                this.startTime = System.nanoTime();
            }
        }

        final void recordExit() {
            if (--this.recursionDepth == 0) {
                this.elapsedTime += System.nanoTime() - this.startTime;
                ++this.counter;
            }
        }
    }
}

