/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader;

import org.eclipse.tracecompass.tmf.core.signal.TmfSelectionRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfSignal;
import org.eclipse.tracecompass.tmf.core.signal.TmfWindowRangeUpdatedSignal;
import org.eclipse.tracecompass.tmf.core.timestamp.ITmfTimestamp;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimeRange;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;
import org.eclipse.tracecompass.tmf.ui.tests.shared.WaitUtils;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDSignalValidator;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestFacility;
import org.eclipse.tracecompass.tmf.ui.tests.views.uml2sd.loader.Uml2SDTestTimestamp;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.GraphNode;
import org.eclipse.tracecompass.tmf.ui.views.uml2sd.core.SyncMessage;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class TmfUml2SDSyncLoaderSignalTest {
    private static Uml2SDTestFacility fFacility;
    private static Uml2SDSignalValidator fTmfComponent;
    private static TmfTimeRange range;
    private static TmfTimestamp rangeWindow;

    @BeforeClass
    public static void setUpClass() {
        fFacility = Uml2SDTestFacility.getInstance();
        fFacility.init();
        fFacility.selectExperiment();
        range = new TmfTimeRange((ITmfTimestamp)new Uml2SDTestTimestamp(9789689220871L), (ITmfTimestamp)new Uml2SDTestTimestamp(9789773881426L));
        rangeWindow = (TmfTimestamp)range.getEndTime().getDelta(range.getStartTime());
        Uml2SDTestTimestamp currentTime = new Uml2SDTestTimestamp(9789773782043L);
        fFacility.getTrace().broadcast((TmfSignal)new TmfWindowRangeUpdatedSignal((Object)fFacility, range));
        fFacility.getTrace().broadcast((TmfSignal)new TmfSelectionRangeUpdatedSignal((Object)fFacility, (ITmfTimestamp)currentTime));
        fFacility.delay(2000L);
        fTmfComponent = new Uml2SDSignalValidator();
    }

    @AfterClass
    public static void tearDownClass() {
        fFacility.disposeExperiment();
        fFacility.dispose();
        fFacility = null;
    }

    @Test
    public void verifyFirstPageSignal() {
        Uml2SDTestTimestamp currentTime = new Uml2SDTestTimestamp(9788641608418L);
        range = new TmfTimeRange((ITmfTimestamp)currentTime, (ITmfTimestamp)new Uml2SDTestTimestamp(currentTime.getValue() + rangeWindow.getValue()));
        fTmfComponent.setSignalError(false);
        fTmfComponent.setSourceError(false);
        fTmfComponent.setRangeError(false);
        fTmfComponent.setWindowRangeSignalReceived(false);
        fTmfComponent.setSource(fFacility.getLoader());
        fTmfComponent.setCurrentRange(range);
        fFacility.firstPage();
        WaitUtils.waitUntil(validator -> validator.isWindowRangeSignalReceived(), fTmfComponent, "Window range signal not received");
        Assert.assertFalse((String)"TmfRangeSynchSignal", (boolean)fTmfComponent.isSignalError());
        Assert.assertFalse((String)"TmfRangeSynchSignal", (boolean)fTmfComponent.isSourceError());
        Assert.assertFalse((String)"TmfRangeSynchSignal", (boolean)fTmfComponent.isRangeError());
    }

    @Test
    public void verifySelectionSignal() {
        int count = fFacility.getSdView().getFrame().syncMessageCount();
        Assert.assertEquals((String)"Test Preparation", (long)10000L, (long)count);
        SyncMessage node = fFacility.getSdView().getFrame().getSyncMessage(3);
        fTmfComponent.setSignalError(false);
        fTmfComponent.setSourceError(false);
        fTmfComponent.setCurrentTimeError(false);
        fTmfComponent.setSelectionRangeSignalReceived(false);
        fTmfComponent.setSource(fFacility.getLoader());
        fTmfComponent.setCurrentTime((ITmfTimestamp)new Uml2SDTestTimestamp(9788642113228L));
        fFacility.getSdView().getSDWidget().moveTo((GraphNode)node);
        WaitUtils.waitUntil(validator -> validator.isSelectionRangeSignalReceived(), fTmfComponent, "Selection range signal not received");
        Assert.assertFalse((String)"TmfTimeSynchSignal", (boolean)fTmfComponent.isSignalError());
        Assert.assertFalse((String)"TmfTimeSynchSignal", (boolean)fTmfComponent.isSourceError());
        Assert.assertFalse((String)"TmfTimeSynchSignal", (boolean)fTmfComponent.isCurrentTimeError());
        fTmfComponent.dispose();
    }
}

