/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.statesystem.core.tests.backend.historytree;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTInterval;
import org.eclipse.tracecompass.internal.statesystem.core.backend.historytree.HTNode;
import org.eclipse.tracecompass.statesystem.core.tests.stubs.backend.HistoryTreeBackendStub;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class HistoryTreeWithBackendTest {
    private static final String SSID = "test";
    private static final int PROVIDER_VERSION = 0;
    private static final int MAX_CHILDREN = 3;
    private static final int BLOCK_SIZE = 4096;
    private final HistoryTreeBackendStub.HistoryTreeType fHtType;

    @Parameterized.Parameters(name="{0}")
    public static Iterable<Object[]> getParameters() {
        return Arrays.asList(new Object[][]{{HistoryTreeBackendStub.HistoryTreeType.CLASSIC}});
    }

    public HistoryTreeWithBackendTest(HistoryTreeBackendStub.HistoryTreeType htType) {
        this.fHtType = htType;
    }

    @Test
    public void testFillNodes() {
        try {
            int nbAttr = 5;
            int depthToRead = 3;
            long startTime = 1L;
            File historyTreeFile = (File)NonNullUtils.checkNotNull((Object)File.createTempFile("HistoryTreeBackendTest", ".ht"));
            HistoryTreeBackendStub.setTreeType(this.fHtType);
            HistoryTreeBackendStub backend = new HistoryTreeBackendStub(SSID, historyTreeFile, 0, startTime, 4096, 3);
            int duration = 5;
            int quarkTest = 5;
            long time = startTime + (long)duration;
            HTInterval interval = new HTInterval(startTime, time, quarkTest, (Object)time);
            backend.insertPastState(interval.getStartTime(), interval.getEndTime(), interval.getAttribute(), interval.getValue());
            while (backend.getHistoryTree().getDepth() < 3) {
                backend.insertPastState(Math.max(startTime, time - (long)duration), time - 1L, (int)time % 5, time);
                ++time;
            }
            HTNode latestLeaf = backend.getHistoryTree().getLatestLeaf();
            while (interval.getSizeOnDisk() <= latestLeaf.getNodeFreeSpace() || latestLeaf.isOnDisk()) {
                backend.insertPastState(Math.max(startTime, time - (long)duration), time - 1L, (int)time % 5, time);
                ++time;
            }
            backend.insertPastState(interval.getEndTime() + 1L, time, quarkTest, time);
            backend.getHistoryTree().assertIntegrity();
        }
        catch (IOException e) {
            Assert.fail((String)e.getMessage());
        }
    }
}

