/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swtchart.internal.series;

import java.util.List;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swtchart.Chart;
import org.eclipse.swtchart.IAxis;
import org.eclipse.swtchart.ICircularSeries;
import org.eclipse.swtchart.internal.axis.Axis;
import org.eclipse.swtchart.internal.compress.Compress;
import org.eclipse.swtchart.internal.compress.CompressCircularSeries;
import org.eclipse.swtchart.internal.series.PieSeries;
import org.eclipse.swtchart.internal.series.Series;
import org.eclipse.swtchart.model.Node;
import org.eclipse.swtchart.model.NodeDataModel;

public abstract class CircularSeries
extends Series
implements ICircularSeries {
    private Color sliceColor = Display.getDefault().getSystemColor(2);
    private Color borderColor = Display.getDefault().getSystemColor(15);
    private int borderWidth = 1;
    private int borderStyle = 1;
    private Color sliceColorHighlight = Display.getDefault().getSystemColor(3);
    private Color borderColorHighlight = Display.getDefault().getSystemColor(4);
    private int borderWidthHighlight = 3;
    private int borderStyleHighlight = 1;
    private Chart chart;
    private NodeDataModel nodeDataModel;
    private Node rootNode;
    private Node rootPointer;
    private int maxTreeDepth = 1;
    private Node highlightedNode;

    public CircularSeries(Chart chart, String id) {
        super(chart, id);
        this.chart = chart;
        this.initialize();
        this.nodeDataModel = new NodeDataModel(id);
        this.rootNode = this.nodeDataModel.getRootNode();
        this.rootPointer = this.nodeDataModel.getRootPointer();
        this.compressor = this.nodeDataModel.getCompressor();
    }

    @Override
    public Color getSliceColor() {
        return this.sliceColor;
    }

    @Override
    public void setSliceColor(Color sliceColor) {
        this.sliceColor = sliceColor;
    }

    @Override
    public Color getBorderColor() {
        return this.borderColor;
    }

    @Override
    public void setBorderColor(Color borderColor) {
        this.borderColor = borderColor;
    }

    @Override
    public int getBorderWidth() {
        return this.borderWidth;
    }

    @Override
    public void setBorderWidth(int borderWidth) {
        this.borderWidth = borderWidth;
    }

    @Override
    public int getBorderStyle() {
        return this.borderStyle;
    }

    @Override
    public void setBorderStyle(int borderStyle) {
        this.borderStyle = borderStyle;
    }

    @Override
    public Color getSliceColorHighlight() {
        return this.sliceColorHighlight;
    }

    @Override
    public void setSliceColorHighlight(Color sliceColor) {
        this.sliceColorHighlight = sliceColor;
    }

    @Override
    public Color getBorderColorHighlight() {
        return this.borderColorHighlight;
    }

    @Override
    public void setBorderColorHighlight(Color borderColor) {
        this.borderColorHighlight = borderColor;
    }

    @Override
    public int getBorderWidthHighlight() {
        return this.borderWidthHighlight;
    }

    @Override
    public void setBorderWidthHighlight(int borderWidth) {
        this.borderWidthHighlight = borderWidth;
    }

    @Override
    public int getBorderStyleHighlight() {
        return this.borderStyleHighlight;
    }

    @Override
    public void setBorderStyleHighlight(int borderStyle) {
        this.borderStyleHighlight = borderStyle;
    }

    @Override
    public Compress getCompressor() {
        return (Compress)this.compressor;
    }

    @Override
    public Node getRootNode() {
        return this.rootNode;
    }

    public Node getRootPointer() {
        return this.nodeDataModel.getRootPointer();
    }

    @Override
    public Node getNodeById(String id) {
        return this.nodeDataModel.getTree().get(id);
    }

    @Override
    public List<Node> getSeries() {
        return this.rootNode.getChildren();
    }

    @Override
    public void addNode(String id, double val) {
        this.rootNode.addChild(id, val);
    }

    @Override
    public String[] getLabels() {
        List<Node>[] nodes = this.nodeDataModel.getNodes();
        int tot = 0;
        int index = 0;
        this.maxTreeDepth = this.getRootPointer().getMaxSubTreeDepth() - 1;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            tot += nodes[i].size();
            ++i;
        }
        String[] labels = new String[tot];
        int i2 = 1;
        while (i2 <= this.maxTreeDepth) {
            int len = nodes[i2].size();
            int j = 0;
            while (j != len) {
                labels[index] = nodes[i2].get(j).getId();
                ++index;
                ++j;
            }
            ++i2;
        }
        return labels;
    }

    @Override
    public Color[] getColors() {
        List<Node>[] nodes = this.nodeDataModel.getNodes();
        int tot = 0;
        int ind = 0;
        int i = 1;
        while (i <= this.maxTreeDepth) {
            tot += nodes[i].size();
            ++i;
        }
        Color[] colors = new Color[tot];
        int i2 = 1;
        while (i2 <= this.maxTreeDepth) {
            int len = nodes[i2].size();
            int j = 0;
            while (j != len) {
                colors[ind] = nodes[i2].get(j).getSliceColor();
                ++ind;
                ++j;
            }
            ++i2;
        }
        return colors;
    }

    @Override
    public void setColor(Color[] colors) {
        int length = this.getLabels().length;
        int cfr_ignored_0 = colors.length;
        int i = 0;
        while (i != length) {
            if (colors[i] != null) {
                this.nodeDataModel.getNodeById(this.getLabels()[i]).setSliceColor(colors[i]);
            }
            ++i;
        }
    }

    @Override
    public void setColor(String label, Color color) {
        Node node = this.nodeDataModel.getNodeById(label);
        if (node != null) {
            node.setSliceColor(color);
        }
    }

    @Override
    public void setSeries(String[] labels, double[] values) {
        int length = labels.length;
        int cfr_ignored_0 = values.length;
        int i = 0;
        while (i != length) {
            new Node(labels[i], values[i], this.rootNode);
            ++i;
        }
        this.nodeDataModel.update();
    }

    @Override
    public Node getHighlightedNode() {
        return this.highlightedNode;
    }

    @Override
    public void setHighlightedNode(Node highlightedNode) {
        if (highlightedNode == null) {
            this.highlightedNode = null;
            return;
        }
        Node node = highlightedNode;
        while (node != this.getRootPointer() && node != this.getRootNode()) {
            node = node.getParent();
        }
        if (node != this.getRootPointer()) {
            return;
        }
        this.borderColorHighlight = this.borderColorHighlight == null ? Display.getDefault().getSystemColor(2) : this.borderColorHighlight;
        this.highlightedNode = highlightedNode;
    }

    @Override
    protected void draw(GC gc, int width, int height, Axis xAxis, Axis yAxis) {
        this.setBothAxisRange(width, height, xAxis, yAxis);
        gc.setForeground(this.sliceColor != null ? this.sliceColor : Display.getDefault().getSystemColor(2));
        gc.setLineStyle(this.borderStyle);
        gc.setLineWidth(this.borderWidth);
        this.drawNode(this.getRootPointer(), gc, xAxis, yAxis);
        if (this.highlightedNode != null && this.borderColorHighlight != null) {
            gc.setForeground(this.borderColorHighlight);
            gc.setLineStyle(this.borderStyleHighlight);
            gc.setLineWidth(this.borderWidthHighlight);
            int level = this.highlightedNode.getLevel() - this.getRootPointer().getLevel() + (this instanceof PieSeries ? 0 : 1);
            int xStart = xAxis.getPixelCoordinate(-level);
            int yStart = yAxis.getPixelCoordinate(level);
            int xWidth = xAxis.getPixelCoordinate(level) - xStart;
            int yWidth = yAxis.getPixelCoordinate(-level) - yStart;
            int angleStart = this.highlightedNode.getAngleBounds().x;
            int angleWidth = this.highlightedNode.getAngleBounds().y;
            gc.drawArc(xStart, yStart, xWidth, yWidth, angleStart, angleWidth);
            if (this.highlightedNode == this.getRootPointer()) {
                return;
            }
            int xParentStart = xAxis.getPixelCoordinate(-level + 1);
            int yParentStart = yAxis.getPixelCoordinate(level - 1);
            int xParentWidth = xAxis.getPixelCoordinate(level - 1) - xParentStart;
            int yParentWidth = yAxis.getPixelCoordinate(-level + 1) - yParentStart;
            gc.drawArc(xParentStart, yParentStart, xParentWidth, yParentWidth, angleStart, angleWidth);
            double xParentStartCoordinate = (double)(level - 1) * Math.cos(Math.toRadians(angleStart));
            double yParentStartCoordinate = (double)(level - 1) * Math.sin(Math.toRadians(angleStart));
            int xParentStartPixelCoordinate = xAxis.getPixelCoordinate(xParentStartCoordinate);
            int yParentStartPixelCoordinate = yAxis.getPixelCoordinate(yParentStartCoordinate);
            double xStartCoordinate = (double)level * Math.cos(Math.toRadians(angleStart));
            double yStartCoordinate = (double)level * Math.sin(Math.toRadians(angleStart));
            int xStartPixelCoordinate = xAxis.getPixelCoordinate(xStartCoordinate);
            int yStartPixelCoordinate = yAxis.getPixelCoordinate(yStartCoordinate);
            gc.drawLine(xParentStartPixelCoordinate, yParentStartPixelCoordinate, xStartPixelCoordinate, yStartPixelCoordinate);
            double xEndCoordinate = (double)level * Math.cos(Math.toRadians(angleStart + angleWidth));
            double yEndCoordinate = (double)level * Math.sin(Math.toRadians(angleStart + angleWidth));
            int xEndPixelCoordinate = xAxis.getPixelCoordinate(xEndCoordinate);
            int yEndPixelCoordinate = yAxis.getPixelCoordinate(yEndCoordinate);
            double xParentEndCoordinate = (double)(level - 1) * Math.cos(Math.toRadians(angleStart + angleWidth));
            double yParentEndCoordinate = (double)(level - 1) * Math.sin(Math.toRadians(angleStart + angleWidth));
            int xParentEndPixelCoordinate = xAxis.getPixelCoordinate(xParentEndCoordinate);
            int yParentEndPixelCoordinate = yAxis.getPixelCoordinate(yParentEndCoordinate);
            gc.drawLine(xParentEndPixelCoordinate, yParentEndPixelCoordinate, xEndPixelCoordinate, yEndPixelCoordinate);
        }
    }

    protected abstract void setBothAxisRange(int var1, int var2, Axis var3, Axis var4);

    protected abstract void drawNode(Node var1, GC var2, Axis var3, Axis var4);

    @Override
    protected void setCompressor() {
        ((CompressCircularSeries)this.compressor).update();
    }

    @Override
    public int getMaxTreeDepth() {
        return this.rootPointer.getMaxSubTreeDepth() - 1;
    }

    public void setMaxTreeDepth(int maxTreeDepth) {
        this.maxTreeDepth = maxTreeDepth;
    }

    private void initialize() {
        IAxis[] axes;
        IAxis[] iAxisArray = axes = this.chart.getAxisSet().getAxes();
        int n = axes.length;
        int n2 = 0;
        while (n2 < n) {
            IAxis axis = iAxisArray[n2];
            axis.getTick().setVisible(false);
            axis.getGrid().setVisible(false);
            axis.getTitle().setVisible(false);
            ++n2;
        }
    }

    @Override
    public NodeDataModel getNodeDataModel() {
        return this.nodeDataModel;
    }

    public void setRootPointer(Node rootPointer) {
        if (this.highlightedNode != null) {
            if (this.highlightedNode == this.getRootPointer()) {
                this.highlightedNode = null;
            }
            Node node = this.highlightedNode;
            while (node != this.getRootPointer() && node != this.getRootNode()) {
                node = node.getParent();
            }
            if (node != this.getRootPointer()) {
                this.highlightedNode = null;
            }
        }
        this.rootPointer = rootPointer;
        this.nodeDataModel.setRootPointer(rootPointer);
    }

    @Override
    public void setNodeDataModel(NodeDataModel nodeDataModel) {
        this.nodeDataModel = nodeDataModel;
        this.rootNode = this.nodeDataModel.getRootNode();
        this.rootPointer = this.nodeDataModel.getRootPointer();
        this.maxTreeDepth = this.rootPointer.getMaxSubTreeDepth() - 1;
    }

    @Override
    public double getSlicePercent(String id) {
        Node node = this.getNodeById(id);
        double percent = node.getValue() * 100.0 / this.getRootPointer().getValue();
        return percent;
    }

    @Override
    public Node getPieSliceFromPosition(int x, int y) {
        double primaryX = this.chart.getAxisSet().getXAxis(0).getDataCoordinate(x);
        double primaryY = this.chart.getAxisSet().getYAxis(0).getDataCoordinate(y);
        return this.getPieSliceFromPosition(primaryX, primaryY);
    }
}

