/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.progress;

import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.e4.ui.model.application.ui.MElementContainer;
import org.eclipse.e4.ui.model.application.ui.SideValue;
import org.eclipse.e4.ui.model.application.ui.basic.MTrimBar;
import org.eclipse.e4.ui.model.application.ui.menu.MToolControl;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.internal.TrimUtil;
import org.eclipse.ui.internal.progress.AnimationItem;
import org.eclipse.ui.internal.progress.AnimationManager;
import org.eclipse.ui.internal.progress.JobInfo;
import org.eclipse.ui.internal.progress.ProgressAnimationItem;
import org.eclipse.ui.internal.progress.ProgressCanvasViewer;
import org.eclipse.ui.internal.progress.ProgressManagerUtil;
import org.eclipse.ui.internal.progress.ProgressViewerContentProvider;
import org.eclipse.ui.internal.progress.ProgressViewerLabelProvider;

public class ProgressRegion {
    @Inject
    MToolControl toolControl;
    @Inject
    IWorkbenchWindow workbenchWindow;
    ProgressCanvasViewer viewer;
    ProgressAnimationItem animationItem;
    Composite region;
    private boolean forceHorizontal;

    private SideValue getLocation() {
        if (this.toolControl == null) {
            return SideValue.BOTTOM;
        }
        MElementContainer parent = this.toolControl.getParent();
        while (parent != null) {
            if (parent instanceof MTrimBar) {
                return ((MTrimBar)parent).getSide();
            }
            parent = parent.getParent();
        }
        return SideValue.BOTTOM;
    }

    @PostConstruct
    public Control createContents(Composite parent) {
        GC gc = new GC((Drawable)parent);
        gc.setAdvanced(true);
        this.forceHorizontal = !gc.getAdvanced();
        gc.dispose();
        this.region = new Composite(parent, 0){

            public Point computeSize(int wHint, int hHint, boolean changed) {
                Point size = super.computeSize(wHint, hHint, changed);
                if (ProgressRegion.this.isHorizontal()) {
                    size.y = TrimUtil.TRIM_DEFAULT_HEIGHT;
                } else {
                    size.x = TrimUtil.TRIM_DEFAULT_HEIGHT;
                }
                return size;
            }
        };
        GridLayout gl = new GridLayout();
        gl.marginHeight = 0;
        gl.marginWidth = 0;
        if (this.isHorizontal()) {
            gl.numColumns = 3;
        }
        this.region.setLayout((Layout)gl);
        this.viewer = new ProgressCanvasViewer(this.region, 524288, 1, 36, this.isHorizontal() ? 256 : 512);
        this.viewer.setUseHashlookup(true);
        Control viewerControl = this.viewer.getControl();
        GridData gd = new GridData(4, 4, true, true);
        Point viewerSizeHints = this.viewer.getSizeHints();
        if (this.isHorizontal()) {
            gd.widthHint = viewerSizeHints.x;
            gd.heightHint = viewerSizeHints.y;
        } else {
            gd.widthHint = viewerSizeHints.y;
            gd.heightHint = viewerSizeHints.x;
        }
        viewerControl.setLayoutData((Object)gd);
        int widthPreference = AnimationManager.getInstance().getPreferredWidth() + 25;
        this.animationItem = new ProgressAnimationItem(this, this.isHorizontal() ? 256 : 512);
        this.animationItem.createControl(this.region);
        this.animationItem.setAnimationContainer(new AnimationItem.IAnimationContainer(){

            @Override
            public void animationDone() {
                if (ProgressRegion.this.viewer.getControl().isDisposed()) {
                    return;
                }
                ProgressRegion.this.viewer.refresh();
            }

            @Override
            public void animationStart() {
            }
        });
        if (this.isHorizontal()) {
            gd = new GridData(1040);
            gd.widthHint = widthPreference;
        } else {
            gd = new GridData(768);
            gd.heightHint = widthPreference;
        }
        this.animationItem.getControl().setLayoutData((Object)gd);
        viewerControl.addMouseListener((MouseListener)new MouseAdapter(){

            public void mouseDoubleClick(MouseEvent e) {
                ProgressRegion.this.processDoubleClick();
            }
        });
        ProgressViewerContentProvider provider = new ProgressViewerContentProvider(this.viewer, false, false);
        this.viewer.setContentProvider((IContentProvider)provider);
        this.viewer.setInput(provider);
        this.viewer.setLabelProvider((IBaseLabelProvider)new ProgressViewerLabelProvider(viewerControl));
        this.viewer.setComparator(ProgressManagerUtil.getProgressViewerComparator());
        this.viewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                JobInfo info;
                return !(element instanceof JobInfo) || !(info = (JobInfo)element).isBlocked() && info.getJob().getState() != 2;
            }
        });
        return this.region;
    }

    public AnimationItem getAnimationItem() {
        return this.animationItem;
    }

    public Control getControl() {
        return this.region;
    }

    public void processDoubleClick() {
        ProgressManagerUtil.openProgressView(this.workbenchWindow);
    }

    private boolean isHorizontal() {
        if (this.forceHorizontal) {
            return true;
        }
        SideValue loc = this.getLocation();
        return loc == SideValue.TOP || loc == SideValue.BOTTOM;
    }
}

