/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.trace;

import java.io.IOException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.trace.FtraceTrace;
import org.eclipse.tracecompass.tmf.core.io.BufferedRandomAccessFile;
import org.eclipse.tracecompass.tmf.core.trace.TraceValidationStatus;

public class TrimmedFtraceTrace
extends FtraceTrace {
    @Override
    public IStatus validate(IProject project, String path) {
        IStatus status = super.validate(project, path);
        if (status instanceof TraceValidationStatus) {
            TraceValidationStatus traceValidationStatus = (TraceValidationStatus)status;
            int trimmedConfidence = Math.max(0, traceValidationStatus.getConfidence() - 1);
            status = new TraceValidationStatus(trimmedConfidence, traceValidationStatus.getPlugin());
        }
        return status;
    }

    @Override
    protected long getFileStart() throws IOException {
        long start = 0L;
        Throwable throwable = null;
        Object var4_4 = null;
        try (BufferedRandomAccessFile fileInput = new BufferedRandomAccessFile(this.getFile(), "r");){
            fileInput.readLine();
            String line = fileInput.readLine();
            while (line != null) {
                if (line.trim().startsWith("#")) {
                    start = fileInput.getFilePointer();
                }
                line = fileInput.readLine();
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return start;
    }
}

