/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.PriorityQueue;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.event.BinaryFTraceEvent;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceFileCPU;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.header.BinaryFTraceHeaderInfo;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceCPUSectionIterator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceCPUSectionIteratorComparator;
import org.eclipse.tracecompass.incubator.internal.ftrace.core.binary.iterator.BinaryFTraceResponse;
import org.eclipse.tracecompass.tmf.core.timestamp.TmfTimestamp;

public class BinaryFTraceReader
implements AutoCloseable {
    private static final int MIN_PRIO_SIZE = 16;
    private final BinaryFTraceHeaderInfo fTrace;
    private final List<BinaryFTraceCPUSectionIterator> fIterators = Collections.synchronizedList(new ArrayList());
    private PriorityQueue<BinaryFTraceCPUSectionIterator> fPrio;
    private long[] fEventCountPerTraceFile;
    private long fStartTime;
    private long fEndTime;
    private boolean fClosed = false;

    public BinaryFTraceReader(BinaryFTraceHeaderInfo trace) throws IOException {
        this.fTrace = trace;
        this.fIterators.clear();
        this.createStreamInputReaders();
        this.populateStreamInputReaderHeap();
        this.fStartTime = 0L;
        if (this.hasMoreEvents()) {
            this.fStartTime = this.getTopStream().getCurrentTimeStamp();
            this.setEndTime(this.fStartTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        List<BinaryFTraceCPUSectionIterator> list = this.fIterators;
        synchronized (list) {
            for (BinaryFTraceCPUSectionIterator iterator : this.fIterators) {
                if (iterator == null) continue;
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    Activator.getInstance().logInfo(e.getMessage(), (Throwable)e);
                }
            }
            this.fIterators.clear();
        }
        this.fPrio.clear();
        this.fClosed = true;
    }

    public long getStartTime() {
        return this.fStartTime;
    }

    protected final void setEndTime(long endTime) {
        this.fEndTime = endTime;
    }

    protected PriorityQueue<BinaryFTraceCPUSectionIterator> getPrio() {
        return this.fPrio;
    }

    private void createStreamInputReaders() throws IOException {
        for (BinaryFTraceFileCPU cpu : this.fTrace.getCpus()) {
            BinaryFTraceCPUSectionIterator iterator = new BinaryFTraceCPUSectionIterator(cpu, this.fTrace);
            this.fIterators.add(iterator);
        }
        this.fEventCountPerTraceFile = new long[this.fIterators.size()];
    }

    public boolean isClosed() {
        return this.fClosed;
    }

    private void populateStreamInputReaderHeap() {
        if (this.fIterators.isEmpty()) {
            this.fPrio = new PriorityQueue<BinaryFTraceCPUSectionIterator>(16, new BinaryFTraceCPUSectionIteratorComparator());
            return;
        }
        this.fPrio = new PriorityQueue<BinaryFTraceCPUSectionIterator>(Math.max(this.fIterators.size() * 2, 16), new BinaryFTraceCPUSectionIteratorComparator());
        int pos = 0;
        for (BinaryFTraceCPUSectionIterator iterator : this.fIterators) {
            BinaryFTraceResponse readNextEvent = iterator.readNextEvent();
            if (readNextEvent == BinaryFTraceResponse.ERROR) continue;
            this.fPrio.add(iterator);
            this.fEventCountPerTraceFile[pos] = 0L;
            ++pos;
        }
    }

    public final boolean hasMoreEvents() {
        return !this.fPrio.isEmpty();
    }

    public BinaryFTraceCPUSectionIterator getTopStream() {
        return this.fPrio.peek();
    }

    public boolean seek(long timestamp) throws IOException {
        this.fPrio.clear();
        long newEndTime = TmfTimestamp.BIG_CRUNCH.toNanos();
        int i = 0;
        while (i < this.fIterators.size()) {
            BinaryFTraceCPUSectionIterator currentIterator = this.fIterators.get(i);
            currentIterator.seek(timestamp);
            BinaryFTraceEvent currentEvent = currentIterator.getCurrentEvent();
            if (currentEvent != null) {
                this.fPrio.add(currentIterator);
                newEndTime = Math.min(currentEvent.getTimeSinceBoot(), newEndTime);
            }
            ++i;
        }
        boolean ret = this.hasMoreEvents();
        if (ret) {
            this.setEndTime(Math.max(this.getEndTime(), newEndTime));
        }
        return ret;
    }

    public boolean advance() {
        BinaryFTraceCPUSectionIterator top = this.fPrio.poll();
        if (top == null) {
            return false;
        }
        switch (top.readNextEvent()) {
            case OK: {
                this.fPrio.add(top);
                BinaryFTraceEvent currentEvent = (BinaryFTraceEvent)NonNullUtils.checkNotNull((Object)top.getCurrentEvent());
                this.setEndTime(Math.max(currentEvent.getTimeSinceBoot(), this.getEndTime()));
                break;
            }
        }
        return this.hasMoreEvents();
    }

    public long getEndTime() {
        return this.fEndTime;
    }
}

