/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.eclipse.ease.ScriptEngineInterruptedException;
import org.eclipse.ease.ScriptExecutionException;

public class ScriptResult
implements Future<Object> {
    public static final Object VOID = new Object(){

        public String toString() {
            return "<void>";
        }
    };
    private Object fResult = null;
    private ScriptExecutionException fException = null;
    private boolean fIsDone = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setResult(Object result) {
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            if (this.isDone()) {
                throw new IllegalArgumentException("ScriptResult already completed");
            }
            this.fResult = result;
            this.fIsDone = true;
            this.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setException(ScriptExecutionException e) {
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            if (this.isDone()) {
                throw new IllegalArgumentException("ScriptResult already completed");
            }
            this.fException = e;
            this.fIsDone = true;
            this.notifyAll();
        }
    }

    public final String toString() {
        try {
            Object result = this.get();
            return result == null ? "[null]" : this.fResult.toString();
        }
        catch (ExecutionException e) {
            return "Exception: " + e.getLocalizedMessage();
        }
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return false;
    }

    @Override
    public boolean isCancelled() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isDone() {
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            return this.fIsDone;
        }
    }

    @Override
    public Object get() throws ExecutionException {
        this.waitForResult();
        return this.getResultOrThrow();
    }

    @Override
    public Object get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.waitForResult(unit.toMillis(timeout));
        return this.getResultOrThrow();
    }

    public Object get(long milliSeconds) throws InterruptedException, ExecutionException, TimeoutException {
        return this.get(milliSeconds, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getResultOrThrow() throws ScriptExecutionException {
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            if (this.fException != null) {
                throw this.fException;
            }
            return this.fResult;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void waitForResult() throws ExecutionException {
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            while (!this.isDone()) {
                try {
                    this.wait();
                }
                catch (InterruptedException e) {
                    throw new ScriptEngineInterruptedException(e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public void waitForResult(long milliseconds) throws InterruptedException, TimeoutException {
        long waitUntil = System.currentTimeMillis() + milliseconds;
        ScriptResult scriptResult = this;
        synchronized (scriptResult) {
            while (!this.isDone() && System.currentTimeMillis() < waitUntil) {
                this.wait(waitUntil - System.currentTimeMillis());
            }
            if (!this.isDone()) {
                throw new TimeoutException(String.format("Result not ready after %d milliseconds", milliseconds));
            }
        }
    }

    @Deprecated
    public final boolean isReady() {
        return this.isDone();
    }

    @Deprecated
    public final Object getResult() {
        try {
            return this.get();
        }
        catch (ExecutionException e) {
            throw new RuntimeException("Execution failed", e);
        }
    }

    @Deprecated
    public final Throwable getException() {
        try {
            this.get();
            throw new RuntimeException("Execution did not throw an exception");
        }
        catch (ExecutionException e) {
            return e;
        }
    }

    @Deprecated
    public final boolean hasException() {
        try {
            this.get();
            return false;
        }
        catch (ExecutionException e) {
            return true;
        }
    }
}

