/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ease.lang.python.debugger;

import java.io.File;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.eclipse.ease.Script;
import org.eclipse.ease.debugging.ScriptRegistry;
import org.eclipse.ease.lang.python.debugger.IPythonScriptRegistry;

public class PythonScriptRegistry
extends ScriptRegistry
implements IPythonScriptRegistry {
    private static final List<String> IGNORED_FILES = Arrays.asList("cp1252.py", "bdb.py", "ast.py", "threading.py");
    private final Map<Script, String> fScriptMap = new HashMap<Script, String>();
    private final Map<String, Script> fStringMap = new HashMap<String, Script>();

    public void put(Script script) {
        super.put(script);
        String reference = this.uid(script);
        this.fStringMap.put(reference, script);
        this.fScriptMap.put(script, reference);
    }

    @Override
    public Script getScript(String reference) {
        File file;
        Script script = this.fStringMap.get(reference);
        if (script == null && (file = new File(reference)).exists() && !IGNORED_FILES.contains(file.getName())) {
            script = new Script((Object)file);
            this.put(script);
        }
        return script;
    }

    @Override
    public String getReference(Script script) {
        return this.fScriptMap.get(script);
    }

    private String uid(Script script) {
        Set<String> existingKeys = this.fStringMap.keySet();
        StringBuilder buffer = new StringBuilder("__ref_");
        buffer.append(script.isDynamic() ? "dyn" : script.getCommand().toString());
        buffer.append("_");
        int index = 0;
        while (index < 10) {
            buffer.append((char)(97 + new Random().nextInt(26)));
            ++index;
        }
        if (existingKeys.contains(buffer.toString())) {
            return this.uid(script);
        }
        return buffer.toString();
    }
}

