/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.tmf.analysis.xml.core.module;

import java.io.File;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.Activator;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlPatternCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.compile.TmfXmlStateProviderCu;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.fsm.module.DataDrivenAnalysisModule;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.module.Messages;
import org.eclipse.tracecompass.internal.tmf.analysis.xml.core.pattern.stateprovider.XmlPatternAnalysis;
import org.eclipse.tracecompass.tmf.analysis.xml.core.module.TmfXmlUtils;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModule;
import org.eclipse.tracecompass.tmf.core.analysis.IAnalysisModuleHelper;
import org.eclipse.tracecompass.tmf.core.analysis.TmfAnalysisManager;
import org.eclipse.tracecompass.tmf.core.analysis.requirements.TmfAbstractAnalysisRequirement;
import org.eclipse.tracecompass.tmf.core.exceptions.TmfAnalysisException;
import org.eclipse.tracecompass.tmf.core.project.model.ITmfPropertiesProvider;
import org.eclipse.tracecompass.tmf.core.project.model.TmfTraceType;
import org.eclipse.tracecompass.tmf.core.project.model.TraceTypeHelper;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;
import org.osgi.framework.Bundle;
import org.w3c.dom.Element;

public class TmfAnalysisModuleHelperXml
implements IAnalysisModuleHelper,
ITmfPropertiesProvider {
    private static final String ICON_ANALYSIS = "/icons/analysis.png";
    private final File fSourceFile;
    private final Element fSourceElement;
    private final XmlAnalysisModuleType fType;

    public TmfAnalysisModuleHelperXml(File xmlFile, Element node, XmlAnalysisModuleType type) {
        this.fSourceFile = xmlFile;
        this.fSourceElement = node;
        this.fType = type;
    }

    public String getId() {
        return this.fSourceElement.getAttribute("id");
    }

    public String getName() {
        List<Element> labels;
        String name = null;
        List<Element> head = TmfXmlUtils.getChildElements(this.fSourceElement, "head");
        if (head.size() == 1 && !(labels = TmfXmlUtils.getChildElements(head.get(0), "label")).isEmpty()) {
            name = labels.get(0).getAttribute("value");
        }
        if (name == null) {
            name = this.getId();
        }
        return name;
    }

    public @NonNull String getViewLabelPrefix() {
        List<Element> labels;
        if (!this.fType.equals((Object)XmlAnalysisModuleType.PATTERN)) {
            return "";
        }
        String viewLabel = "";
        List<Element> head = TmfXmlUtils.getChildElements(this.fSourceElement, "head");
        if (head.size() == 1 && !(labels = TmfXmlUtils.getChildElements(head.get(0), "viewLabelPrefix")).isEmpty()) {
            viewLabel = labels.get(0).getAttribute("value");
        }
        return viewLabel;
    }

    public boolean isAutomatic() {
        return false;
    }

    public boolean appliesToExperiment() {
        return false;
    }

    public String getHelpText() {
        return "";
    }

    public String getHelpText(@NonNull ITmfTrace trace) {
        return "";
    }

    public String getIcon() {
        return ICON_ANALYSIS;
    }

    public Bundle getBundle() {
        return Activator.getDefault().getBundle();
    }

    public boolean appliesToTraceType(Class<? extends ITmfTrace> traceClass) {
        List<Element> head = TmfXmlUtils.getChildElements(this.fSourceElement, "head");
        if (head.size() != 1) {
            return true;
        }
        List<Element> elements = TmfXmlUtils.getChildElements(head.get(0), "traceType");
        if (elements.isEmpty()) {
            return true;
        }
        for (Element element : elements) {
            String traceTypeId = element.getAttribute("id");
            TraceTypeHelper helper = TmfTraceType.getTraceType((String)(traceTypeId = TmfTraceType.buildCompatibilityTraceTypeId((String)traceTypeId)));
            if (helper == null || !helper.getTrace().getClass().isAssignableFrom(traceClass)) continue;
            return true;
        }
        return false;
    }

    public Iterable<Class<? extends ITmfTrace>> getValidTraceTypes() {
        return Collections.emptySet();
    }

    public Iterable<TmfAbstractAnalysisRequirement> getAnalysisRequirements() {
        return Collections.emptySet();
    }

    public final @Nullable IAnalysisModule newModule(ITmfTrace trace) throws TmfAnalysisException {
        String analysisid = this.getId();
        Object module = null;
        switch (this.fType) {
            case STATE_SYSTEM: {
                TmfXmlStateProviderCu compile = TmfXmlStateProviderCu.compile(this.fSourceFile.toPath(), analysisid);
                if (compile == null) {
                    return null;
                }
                module = new DataDrivenAnalysisModule(analysisid, compile);
                module.setName(this.getName());
                break;
            }
            case PATTERN: {
                TmfXmlPatternCu patternCu = TmfXmlPatternCu.compile(this.fSourceFile.toPath(), analysisid);
                if (patternCu == null) {
                    return null;
                }
                module = new XmlPatternAnalysis(analysisid, patternCu);
                module.setName(this.getName());
                XmlPatternAnalysis paModule = (XmlPatternAnalysis)((Object)module);
                paModule.setViewLabelPrefix(this.getViewLabelPrefix());
                break;
            }
            case OTHER: {
                String name = this.getName();
                module = this.createOtherModule(analysisid, name);
                break;
            }
        }
        if (module != null) {
            if (module.setTrace(trace)) {
                TmfAnalysisManager.analysisModuleCreated((IAnalysisModule)module);
            } else {
                module.dispose();
                module = null;
            }
        }
        return module;
    }

    protected IAnalysisModule createOtherModule(@NonNull String analysisid, @NonNull String name) {
        throw new UnsupportedOperationException("Other modules should be implemented by their own helper classes");
    }

    protected Path getSourceFile() {
        return this.fSourceFile.toPath();
    }

    protected Element getSourceElement() {
        return this.fSourceElement;
    }

    public @NonNull Map<@NonNull String, @NonNull String> getProperties() {
        HashMap<@NonNull String, @NonNull String> properties = new HashMap<String, String>();
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.XmlModuleHelper_PropertyFile), this.fSourceFile.getName());
        properties.put((String)NonNullUtils.checkNotNull((Object)Messages.XmlModuleHelper_PropertyType), this.fType.name());
        return properties;
    }

    public static enum XmlAnalysisModuleType {
        STATE_SYSTEM,
        PATTERN,
        OTHER;

    }
}

