/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.texteditor.quickdiff;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.ui.texteditor.quickdiff.ReferenceProviderDescriptor;

public class QuickDiffExtensionsRegistry {
    private ReferenceProviderDescriptor fDefaultDescriptor;
    private List<ReferenceProviderDescriptor> fDescriptors;

    public synchronized ReferenceProviderDescriptor getDefaultProvider() {
        this.ensureRegistered();
        return this.fDefaultDescriptor;
    }

    public synchronized List<ReferenceProviderDescriptor> getReferenceProviderDescriptors() {
        this.ensureRegistered();
        return this.fDescriptors;
    }

    private void ensureRegistered() {
        if (this.fDescriptors == null) {
            this.reloadExtensions();
        }
    }

    public synchronized void reloadExtensions() {
        IConfigurationElement[] elements;
        this.fDefaultDescriptor = null;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        ArrayList<ReferenceProviderDescriptor> list = new ArrayList<ReferenceProviderDescriptor>();
        IConfigurationElement[] iConfigurationElementArray = elements = registry.getConfigurationElementsFor("org.eclipse.ui.workbench.texteditor", "quickDiffReferenceProvider");
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            ReferenceProviderDescriptor desc = new ReferenceProviderDescriptor(element);
            if (desc.getId().equals("org.eclipse.ui.internal.editors.quickdiff.LastSaveReferenceProvider")) {
                this.fDefaultDescriptor = desc;
            }
            list.add(desc);
            ++n2;
        }
        if (this.fDefaultDescriptor != null) {
            list.remove(this.fDefaultDescriptor);
            list.add(0, this.fDefaultDescriptor);
        }
        this.fDescriptors = Collections.unmodifiableList(list);
    }
}

