/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.jsdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.wst.jsdt.core.IJavaScriptElement;
import org.eclipse.wst.jsdt.core.IJavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.AST;
import org.eclipse.wst.jsdt.core.dom.ASTNode;
import org.eclipse.wst.jsdt.core.dom.ASTVisitor;
import org.eclipse.wst.jsdt.core.dom.Assignment;
import org.eclipse.wst.jsdt.core.dom.ClassInstanceCreation;
import org.eclipse.wst.jsdt.core.dom.Expression;
import org.eclipse.wst.jsdt.core.dom.FieldAccess;
import org.eclipse.wst.jsdt.core.dom.FieldDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionDeclaration;
import org.eclipse.wst.jsdt.core.dom.FunctionInvocation;
import org.eclipse.wst.jsdt.core.dom.IBinding;
import org.eclipse.wst.jsdt.core.dom.IFunctionBinding;
import org.eclipse.wst.jsdt.core.dom.ITypeBinding;
import org.eclipse.wst.jsdt.core.dom.IVariableBinding;
import org.eclipse.wst.jsdt.core.dom.JSdoc;
import org.eclipse.wst.jsdt.core.dom.JavaScriptUnit;
import org.eclipse.wst.jsdt.core.dom.PostfixExpression;
import org.eclipse.wst.jsdt.core.dom.PrefixExpression;
import org.eclipse.wst.jsdt.core.dom.QualifiedName;
import org.eclipse.wst.jsdt.core.dom.SimpleName;
import org.eclipse.wst.jsdt.core.dom.SingleVariableDeclaration;
import org.eclipse.wst.jsdt.core.dom.SuperMethodInvocation;
import org.eclipse.wst.jsdt.core.dom.TagElement;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationExpression;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationFragment;
import org.eclipse.wst.jsdt.core.dom.VariableDeclarationStatement;
import org.eclipse.wst.jsdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.wst.jsdt.internal.corext.dom.ASTNodes;
import org.eclipse.wst.jsdt.internal.corext.dom.LinkedNodeFinder;
import org.eclipse.wst.jsdt.internal.corext.dom.NodeFinder;
import org.eclipse.wst.jsdt.internal.corext.util.Messages;
import org.eclipse.wst.jsdt.internal.ui.JavaScriptPlugin;
import org.eclipse.wst.jsdt.internal.ui.javaeditor.ASTProvider;
import org.eclipse.wst.jsdt.internal.ui.text.correction.ASTRewriteCorrectionProposal;
import org.eclipse.wst.jsdt.internal.ui.text.correction.CorrectionMessages;
import org.eclipse.wst.jsdt.internal.ui.text.correction.JavadocTagsSubProcessor;

public class RemoveDeclarationCorrectionProposal
extends ASTRewriteCorrectionProposal {
    private SimpleName fName;

    public RemoveDeclarationCorrectionProposal(IJavaScriptUnit cu, SimpleName name, int relevance) {
        super("", cu, (ASTRewrite)null, relevance, JavaScriptPlugin.getDefault().getWorkbench().getSharedImages().getImage("IMG_TOOL_DELETE"));
        this.fName = name;
    }

    @Override
    public String getDisplayString() {
        IBinding binding = this.fName.resolveBinding();
        String name = this.fName.getIdentifier();
        switch (binding.getKind()) {
            case 2: {
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedtype_description, name);
            }
            case 4: {
                if (((IFunctionBinding)binding).isConstructor()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedconstructor_description, name);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedmethod_description, name);
            }
            case 3: {
                if (((IVariableBinding)binding).isField()) {
                    return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedfield_description, name);
                }
                return Messages.format(CorrectionMessages.RemoveDeclarationCorrectionProposal_removeunusedvar_description, name);
            }
        }
        return super.getDisplayString();
    }

    @Override
    protected ASTRewrite getRewrite() {
        ASTRewrite rewrite;
        IBinding binding = this.fName.resolveBinding();
        JavaScriptUnit root = (JavaScriptUnit)this.fName.getRoot();
        if (binding.getKind() == 4) {
            IFunctionBinding decl = ((IFunctionBinding)binding).getMethodDeclaration();
            ASTNode declaration = root.findDeclaringNode((IBinding)decl);
            rewrite = ASTRewrite.create((AST)root.getAST());
            rewrite.remove(declaration, null);
        } else if (binding.getKind() == 2) {
            ITypeBinding decl = ((ITypeBinding)binding).getTypeDeclaration();
            ASTNode declaration = root.findDeclaringNode((IBinding)decl);
            rewrite = ASTRewrite.create((AST)root.getAST());
            rewrite.remove(declaration, null);
        } else if (binding.getKind() == 3) {
            JavaScriptUnit completeRoot = JavaScriptPlugin.getDefault().getASTProvider().getAST((IJavaScriptElement)this.getCompilationUnit(), ASTProvider.WAIT_YES, null);
            SimpleName nameNode = (SimpleName)NodeFinder.perform((ASTNode)completeRoot, this.fName.getStartPosition(), this.fName.getLength());
            rewrite = ASTRewrite.create((AST)completeRoot.getAST());
            SimpleName[] references = LinkedNodeFinder.findByBinding((ASTNode)completeRoot, nameNode.resolveBinding());
            int i = 0;
            while (i < references.length) {
                this.removeVariableReferences(rewrite, references[i]);
                ++i;
            }
            IVariableBinding bindingDecl = ((IVariableBinding)nameNode.resolveBinding()).getVariableDeclaration();
            ASTNode declaringNode = completeRoot.findDeclaringNode((IBinding)bindingDecl);
            if (declaringNode instanceof SingleVariableDeclaration) {
                this.removeParamTag(rewrite, (SingleVariableDeclaration)declaringNode);
            }
        } else {
            throw new IllegalArgumentException("Unexpected binding");
        }
        return rewrite;
    }

    private void removeParamTag(ASTRewrite rewrite, SingleVariableDeclaration varDecl) {
        TagElement tagElement;
        JSdoc javadoc;
        if (varDecl.getParent() instanceof FunctionDeclaration && (javadoc = ((FunctionDeclaration)varDecl.getParent()).getJavadoc()) != null && (tagElement = JavadocTagsSubProcessor.findParamTag(javadoc, varDecl.getName().getIdentifier())) != null) {
            rewrite.remove((ASTNode)tagElement, null);
        }
    }

    private void removeVariableReferences(ASTRewrite rewrite, SimpleName reference) {
        int nameParentType;
        ASTNode parent = reference.getParent();
        while (parent instanceof QualifiedName) {
            parent = parent.getParent();
        }
        if (parent instanceof FieldAccess) {
            parent = parent.getParent();
        }
        if ((nameParentType = parent.getNodeType()) == 7) {
            Assignment assignment = (Assignment)parent;
            Expression rightHand = assignment.getRightHandSide();
            ASTNode assignParent = assignment.getParent();
            if (assignParent.getNodeType() == 21 && rightHand.getNodeType() != 7) {
                this.removeVariableWithInitializer(rewrite, (ASTNode)rightHand, assignParent);
            } else {
                rewrite.replace((ASTNode)assignment, rewrite.createCopyTarget((ASTNode)rightHand), null);
            }
        } else if (nameParentType == 44) {
            rewrite.remove(parent, null);
        } else if (nameParentType == 59) {
            VariableDeclarationFragment frag = (VariableDeclarationFragment)parent;
            ASTNode varDecl = frag.getParent();
            List fragments = varDecl instanceof VariableDeclarationExpression ? ((VariableDeclarationExpression)varDecl).fragments() : (varDecl instanceof FieldDeclaration ? ((FieldDeclaration)varDecl).fragments() : ((VariableDeclarationStatement)varDecl).fragments());
            if (fragments.size() == 1) {
                rewrite.remove(varDecl, null);
            } else {
                rewrite.remove((ASTNode)frag, null);
            }
        }
    }

    private void removeVariableWithInitializer(ASTRewrite rewrite, ASTNode initializerNode, ASTNode statementNode) {
        ArrayList sideEffectNodes = new ArrayList();
        initializerNode.accept((ASTVisitor)new SideEffectFinder(sideEffectNodes));
        int nSideEffects = sideEffectNodes.size();
        if (nSideEffects == 0) {
            if (ASTNodes.isControlStatementBody(statementNode.getLocationInParent())) {
                rewrite.replace(statementNode, (ASTNode)rewrite.getAST().newBlock(), null);
            } else {
                rewrite.remove(statementNode, null);
            }
        }
    }

    private static class SideEffectFinder
    extends ASTVisitor {
        private ArrayList fSideEffectNodes;

        public SideEffectFinder(ArrayList res) {
            this.fSideEffectNodes = res;
        }

        public boolean visit(Assignment node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(PostfixExpression node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(PrefixExpression node) {
            PrefixExpression.Operator operator = node.getOperator();
            if (operator == PrefixExpression.Operator.INCREMENT || operator == PrefixExpression.Operator.DECREMENT) {
                this.fSideEffectNodes.add(node);
            }
            return false;
        }

        public boolean visit(FunctionInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(ClassInstanceCreation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }

        public boolean visit(SuperMethodInvocation node) {
            this.fSideEffectNodes.add(node);
            return false;
        }
    }
}

