/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.incubator.internal.ros.core.Activator;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.messageflow.TargetMessageInfo;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.connections.RosConnectionEndpoint;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.IRosMessageFlowModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messageflow.RosMessageFlowSegment;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.IRosMessagesTransportModel;
import org.eclipse.tracecompass.incubator.internal.ros.core.analysis.model.messagestransport.RosMessageTransport;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystem;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateSystemDisposedException;
import org.eclipse.tracecompass.statesystem.core.interval.ITmfStateInterval;

public class RosMessageFlowModel
implements IRosMessageFlowModel {
    private final @NonNull TargetMessageInfo fInfo;
    private final @NonNull ITmfStateSystem fQueuesSs;
    private final @NonNull IRosMessagesTransportModel fMsgsTransportModel;
    private RosMessageFlowSegment fInitialSegment = null;
    private boolean fIsModelDone = false;

    public RosMessageFlowModel(@NonNull TargetMessageInfo targetInfo, @NonNull ITmfStateSystem queuesStateSystem, @NonNull IRosMessagesTransportModel msgsTransportModel) {
        this.fInfo = targetInfo;
        this.fQueuesSs = queuesStateSystem;
        this.fMsgsTransportModel = msgsTransportModel;
    }

    @Override
    public @Nullable RosMessageFlowSegment getFirstSegment() {
        return this.fInitialSegment;
    }

    @Override
    public boolean isModelDone() {
        return this.fIsModelDone;
    }

    @Override
    public void generateModel() {
        try {
            this.process();
            this.fIsModelDone = true;
        }
        catch (AttributeNotFoundException | StateSystemDisposedException e) {
            Activator.getInstance().logError("Error while processing! ", e);
        }
    }

    private void process() throws AttributeNotFoundException, StateSystemDisposedException {
        RosMessageFlowSegment.SegmentType type = RosMessageFlowModel.getSegmentTypeFromQueueType(this.fInfo.getQueueType());
        int queueQuark = this.getTargetQueueQuark();
        int queuePos = this.fInfo.getQueuePosition();
        int queuePosQuark = this.fQueuesSs.getQuarkRelative(queueQuark, new String[]{String.valueOf(queuePos)});
        NextSegmentInfo next = new NextSegmentInfo();
        next.setType(type);
        next.setQuark(queuePosQuark);
        next.setTimestamp(this.fInfo.getMsgTimestamp());
        while (next.getType() != RosMessageFlowSegment.SegmentType.INVALID) {
            switch (next.getType()) {
                case PUB_QUEUE: {
                    this.processPubQueue(next);
                    break;
                }
                case SUB_QUEUE: {
                    this.processSubQueue(next);
                    break;
                }
                case SUB_CALLBACK: {
                    this.processCallback(next);
                    break;
                }
                default: {
                    Activator.getInstance().logError("Case " + next.getType().name() + " should be handled!");
                }
            }
            RosMessageFlowSegment nextSegment = next.getNextSegment();
            RosMessageFlowSegment previousSegment = next.getPreviousSegment();
            if (previousSegment == null) {
                this.fInitialSegment = nextSegment;
                continue;
            }
            previousSegment.addNext(nextSegment);
        }
    }

    private void processPubQueue(NextSegmentInfo next) throws StateSystemDisposedException, AttributeNotFoundException {
        int queuePosQuark = next.getQuark();
        long msgStart = next.getTimestamp();
        ITmfStateInterval firstState = this.fQueuesSs.querySingleState(msgStart, queuePosQuark);
        ITmfStateInterval lastState = this.getLastStateOfMessageInQueue(firstState, queuePosQuark);
        int queueQuark = this.fQueuesSs.getParentAttributeQuark(queuePosQuark);
        long start = firstState.getStartTime();
        long end = lastState.getEndTime();
        int topicQuark = this.fQueuesSs.getParentAttributeQuark(this.fQueuesSs.getParentAttributeQuark(queuePosQuark));
        int nodeQuark = this.fQueuesSs.getParentAttributeQuark(this.fQueuesSs.getParentAttributeQuark(topicQuark));
        String nodeName = this.fQueuesSs.getAttributeName(nodeQuark);
        String topicName = this.fQueuesSs.getAttributeName(topicQuark);
        RosMessageFlowSegment segment = new RosMessageFlowSegment(start, end, next.getType(), nodeName, topicName);
        next.setNextSegment(segment);
        QueueSegmentTransition transition = this.getTransitionFromLastQueueState(lastState, this.fInfo.getQueueType(), queueQuark);
        if (transition == null) {
            Activator.getInstance().logError("Could not find transition!");
        }
        if (transition == null || transition == QueueSegmentTransition.DROP) {
            next.setType(RosMessageFlowSegment.SegmentType.INVALID);
        } else {
            next.setType(RosMessageFlowSegment.SegmentType.SUB_QUEUE);
            RosMessageTransport transport = this.fMsgsTransportModel.getNextMessageTransport(end, nodeName, topicName);
            if (transport == null) {
                Activator.getInstance().logError("Could not find next message transport!");
                next.setType(RosMessageFlowSegment.SegmentType.INVALID);
            } else {
                RosConnectionEndpoint sub = transport.getConnection().getSub();
                queueQuark = this.fQueuesSs.getQuarkAbsolute(new String[]{sub.getNodeName(), "Subscribers", sub.getTopicName(), "queue"});
                ITmfStateInterval stateBeforeMsg = this.getStateBeforeMessageAddedToQueue(queueQuark, transport.getDestinationTimestamp());
                int incomingMsgPosQuark = stateBeforeMsg.getAttribute();
                long msgStateStartTime = stateBeforeMsg.getEndTime() + 1L;
                next.setQuark(incomingMsgPosQuark);
                next.setTimestamp(msgStateStartTime);
            }
        }
    }

    private void processSubQueue(NextSegmentInfo next) throws AttributeNotFoundException, StateSystemDisposedException {
        int incomingMsgPosQuark = next.getQuark();
        long msgStateStartTime = next.getTimestamp();
        ITmfStateInterval firstState = this.fQueuesSs.querySingleState(msgStateStartTime, incomingMsgPosQuark);
        ITmfStateInterval lastState = this.getLastStateOfMessageInQueue(firstState, incomingMsgPosQuark);
        long start = firstState.getStartTime();
        long end = lastState.getEndTime();
        int topicQuark = this.fQueuesSs.getParentAttributeQuark(this.fQueuesSs.getParentAttributeQuark(incomingMsgPosQuark));
        int nodeQuark = this.fQueuesSs.getParentAttributeQuark(this.fQueuesSs.getParentAttributeQuark(topicQuark));
        String nodeName = this.fQueuesSs.getAttributeName(nodeQuark);
        String topicName = this.fQueuesSs.getAttributeName(topicQuark);
        RosMessageFlowSegment segment = new RosMessageFlowSegment(start, end, next.getType(), nodeName, topicName);
        next.setNextSegment(segment);
        QueueSegmentTransition transition = this.getTransitionFromLastQueueState(lastState, TargetMessageInfo.RosQueueType.SUB, this.fQueuesSs.getParentAttributeQuark(incomingMsgPosQuark));
        if (transition == null) {
            Activator.getInstance().logError("Could not find transition!");
        }
        if (transition == null || transition == QueueSegmentTransition.DROP) {
            next.setType(RosMessageFlowSegment.SegmentType.INVALID);
        } else {
            next.setType(RosMessageFlowSegment.SegmentType.SUB_CALLBACK);
            long callbackStart = lastState.getEndTime() + 1L;
            int subsQuark = this.fQueuesSs.getParentAttributeQuark(topicQuark);
            int callbackQuark = this.fQueuesSs.getQuarkRelative(subsQuark, new String[]{"callbacks"});
            next.setQuark(callbackQuark);
            next.setTimestamp(callbackStart);
        }
    }

    /*
     * Issues handling annotations - annotations may be inaccurate
     */
    private void processCallback(NextSegmentInfo next) throws StateSystemDisposedException {
        long callbackStart = next.getTimestamp();
        int callbackQuark = next.getQuark();
        ITmfStateInterval callbackState = this.fQueuesSs.querySingleState(callbackStart, callbackQuark);
        int nodeQuark = this.fQueuesSs.getParentAttributeQuark(this.fQueuesSs.getParentAttributeQuark(callbackQuark));
        ArrayList<ITmfStateInterval> pubMsgs = new ArrayList<ITmfStateInterval>();
        try {
            int pubListQuark = this.fQueuesSs.getQuarkRelative(nodeQuark, new String[]{"Publishers"});
            @NonNull List pubTopicQuarks = this.fQueuesSs.getSubAttributes(pubListQuark, false);
            for (Integer pubTopicQuark : pubTopicQuarks) {
                int queueQuark;
                ITmfStateInterval stateBefore;
                String topicName = this.fQueuesSs.getAttributeName(pubTopicQuark.intValue());
                if (topicName.contains("rosout") || (stateBefore = this.getStateBeforeMessageAddedToQueue(queueQuark = this.fQueuesSs.getQuarkRelative(pubTopicQuark.intValue(), new String[]{"queue"}), callbackState.getStartTime() - 1L)).getEndTime() >= callbackState.getEndTime()) continue;
                long newMsgsStart = stateBefore.getEndTime() + 1L;
                ITmfStateInterval newPubMsg = this.fQueuesSs.querySingleState(newMsgsStart, stateBefore.getAttribute());
                pubMsgs.add(newPubMsg);
            }
        }
        catch (AttributeNotFoundException pubListQuark) {
            // empty catch block
        }
        long start = callbackState.getStartTime();
        String nodeName = this.fQueuesSs.getAttributeName(nodeQuark);
        String topicName = "";
        if (pubMsgs.isEmpty()) {
            long end = callbackState.getEndTime();
            RosMessageFlowSegment segment = new RosMessageFlowSegment(start, end, next.getType(), nodeName, topicName);
            next.setNextSegment(segment);
            next.setType(RosMessageFlowSegment.SegmentType.INVALID);
        } else {
            if (pubMsgs.size() > 1) {
                Activator.getInstance().logWarning("Found more than one published message during callback!");
            }
            ITmfStateInterval pubMsg = (ITmfStateInterval)pubMsgs.get(0);
            long end = pubMsg.getStartTime() - 1L;
            RosMessageFlowSegment segment = new RosMessageFlowSegment(start, end, next.getType(), nodeName, topicName);
            next.setNextSegment(segment);
            next.setQuark(pubMsg.getAttribute());
            next.setTimestamp(pubMsg.getStartTime());
            next.setType(RosMessageFlowSegment.SegmentType.PUB_QUEUE);
        }
    }

    private ITmfStateInterval getStateBeforeMessageAddedToQueue(int queueQuark, long initialTimestamp) throws StateSystemDisposedException, AttributeNotFoundException {
        ITmfStateInterval queueState = this.fQueuesSs.querySingleState(initialTimestamp, queueQuark);
        int queueSize = queueState.getValue() == null ? 0 : queueState.getValueInt();
        int incomingMsgPos = queueSize + 1;
        int incomingMsgPosQuark = this.fQueuesSs.getQuarkRelative(queueQuark, new String[]{String.valueOf(incomingMsgPos)});
        ITmfStateInterval stateBeforeNewMsg = this.fQueuesSs.querySingleState(initialTimestamp, incomingMsgPosQuark);
        return stateBeforeNewMsg;
    }

    private static RosMessageFlowSegment.SegmentType getSegmentTypeFromQueueType(TargetMessageInfo.RosQueueType queueType) {
        switch (queueType) {
            case SUB: {
                return RosMessageFlowSegment.SegmentType.SUB_QUEUE;
            }
            case PUB: {
                return RosMessageFlowSegment.SegmentType.PUB_QUEUE;
            }
        }
        Activator.getInstance().logError("Case " + queueType.name() + " should be handled!");
        return null;
    }

    private QueueSegmentTransition getTransitionFromLastQueueState(ITmfStateInterval lastState, TargetMessageInfo.RosQueueType queueType, int queueQuark) throws StateSystemDisposedException {
        int topicQuark = this.fQueuesSs.getParentAttributeQuark(queueQuark);
        try {
            int dropsQuark = this.fQueuesSs.getQuarkRelative(topicQuark, new String[]{"drops"});
            ITmfStateInterval possibleDrop = this.fQueuesSs.querySingleState(lastState.getStartTime(), dropsQuark);
            if (possibleDrop.getValue() != null) {
                return QueueSegmentTransition.DROP;
            }
        }
        catch (AttributeNotFoundException attributeNotFoundException) {
            // empty catch block
        }
        switch (queueType) {
            case PUB: {
                return QueueSegmentTransition.NETWORK;
            }
            case SUB: {
                return QueueSegmentTransition.CALLBACK;
            }
        }
        Activator.getInstance().logError("Case " + queueType.name() + " should be handled!");
        return null;
    }

    private ITmfStateInterval getLastStateOfMessageInQueue(ITmfStateInterval message, int queuePosQuark) throws AttributeNotFoundException, StateSystemDisposedException {
        ITmfStateInterval msg = message;
        int queueQuark = this.fQueuesSs.getParentAttributeQuark(queuePosQuark);
        int pos = Integer.parseInt(this.fQueuesSs.getAttributeName(queuePosQuark));
        long ref = msg.getValueLong();
        while (pos > 1) {
            int nextQueuePosQuark;
            long nextStartTime = msg.getEndTime() + 1L;
            if ((msg = this.fQueuesSs.querySingleState(nextStartTime, nextQueuePosQuark = this.fQueuesSs.getQuarkRelative(queueQuark, new String[]{String.valueOf(--pos)}))).getValueLong() != ref) {
                Activator.getInstance().logWarning("References do not match! previous=" + ref + " vs. now=" + msg.getValueLong());
            }
            ref = msg.getValueLong();
        }
        return msg;
    }

    private int getTargetQueueQuark() throws AttributeNotFoundException {
        return this.fQueuesSs.getQuarkAbsolute(new String[]{this.fInfo.getNode(), RosMessageFlowModel.getQueueTypeName(this.fInfo.getQueueType()), this.fInfo.getTopic(), "queue"});
    }

    private static @Nullable String getQueueTypeName(TargetMessageInfo.RosQueueType type) {
        switch (type) {
            case PUB: {
                return "Publishers";
            }
            case SUB: {
                return "Subscribers";
            }
        }
        Activator.getInstance().logError("Case " + type.name() + " should be handled!");
        return null;
    }

    private class NextSegmentInfo {
        private RosMessageFlowSegment.SegmentType fType = null;
        private Integer fQuark = null;
        private Long fTimestamp = null;
        private RosMessageFlowSegment fSegment = null;
        private RosMessageFlowSegment fPreviousSegment = null;

        public RosMessageFlowSegment.SegmentType getType() {
            return this.fType;
        }

        public void setType(RosMessageFlowSegment.SegmentType type) {
            this.fType = type;
        }

        public Integer getQuark() {
            return this.fQuark;
        }

        public void setQuark(int quark) {
            this.fQuark = quark;
        }

        public Long getTimestamp() {
            return this.fTimestamp;
        }

        public void setTimestamp(long t) {
            this.fTimestamp = t;
        }

        public RosMessageFlowSegment getNextSegment() {
            return this.fSegment;
        }

        public void setNextSegment(RosMessageFlowSegment segment) {
            this.fPreviousSegment = this.fSegment;
            this.fSegment = segment;
        }

        public RosMessageFlowSegment getPreviousSegment() {
            return this.fPreviousSegment;
        }
    }

    private static enum QueueSegmentTransition {
        CALLBACK,
        NETWORK,
        DROP;

    }
}

