/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.incubator.internal.ros.ui.views;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.Map;
import java.util.Optional;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.tracecompass.tmf.core.presentation.IPaletteProvider;
import org.eclipse.tracecompass.tmf.core.presentation.RGBAColor;
import org.eclipse.tracecompass.tmf.core.presentation.RotatingPaletteProvider;
import org.eclipse.tracecompass.tmf.ui.colors.RGBAUtil;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.StateItem;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.TimeGraphPresentationProvider;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.ITimeGraphEntry;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.model.NamedTimeEvent;
import org.eclipse.tracecompass.tmf.ui.widgets.timegraph.widgets.Utils;

public abstract class AbstractRosPresentationProvider
extends TimeGraphPresentationProvider {
    protected static final String TAB = "\t";
    private static final int NUM_COLORS = 360;
    private static final StateItem[] STATE_TABLE;
    private static final IPaletteProvider PALETTE;
    protected final LoadingCache<NamedTimeEvent, Optional<String>> fTimeEventNames = CacheBuilder.newBuilder().maximumSize(1000L).build((CacheLoader)new CacheLoader<NamedTimeEvent, Optional<String>>(){

        public Optional<String> load(NamedTimeEvent event) {
            return Optional.ofNullable(event.getLabel());
        }
    });

    static {
        PALETTE = new RotatingPaletteProvider.Builder().setNbColors(360).build();
        STATE_TABLE = new StateItem[361];
        AbstractRosPresentationProvider.STATE_TABLE[0] = new StateItem(State.MULTIPLE.rgb, State.MULTIPLE.toString());
        int i = 1;
        for (RGBAColor color : PALETTE.get()) {
            AbstractRosPresentationProvider.STATE_TABLE[i] = new StateItem(RGBAUtil.fromRGBAColor((RGBAColor)color).rgb, color.toString());
            ++i;
        }
    }

    public AbstractRosPresentationProvider() {
        super("");
    }

    public StateItem[] getStateTable() {
        return STATE_TABLE;
    }

    public int getStateTableIndex(ITimeEvent event) {
        if (event instanceof NamedTimeEvent) {
            NamedTimeEvent namedEvent = (NamedTimeEvent)event;
            return Math.floorMod(namedEvent.getLabel().hashCode(), PALETTE.get().size()) + 1;
        }
        return -1;
    }

    public @Nullable String getEventName(ITimeEvent event) {
        return null;
    }

    public @Nullable String getStateTypeName(ITimeGraphEntry entry) {
        return null;
    }

    public @Nullable Map<String, String> getEventHoverToolTipInfo(ITimeEvent event) {
        return null;
    }

    public void postDrawEvent(ITimeEvent event, Rectangle bounds, GC gc) {
        if (!(event instanceof NamedTimeEvent)) {
            return;
        }
        String name = ((Optional)this.fTimeEventNames.getUnchecked((Object)((NamedTimeEvent)event))).orElse("");
        if (name.isEmpty()) {
            return;
        }
        if (bounds.width > bounds.height) {
            gc.setForeground(gc.getDevice().getSystemColor(1));
            Utils.drawText((GC)gc, (String)name, (int)bounds.x, (int)bounds.y, (int)bounds.width, (int)bounds.height, (boolean)true, (boolean)true);
        }
    }

    private static enum State {
        MULTIPLE(new RGB(100, 100, 100)),
        EXEC(new RGB(0, 200, 0));

        private final RGB rgb;

        private State(RGB rgb) {
            this.rgb = rgb;
        }
    }
}

