/*
 * Decompiled with CFR 0.152.
 */
package org.python.modules.jffi;

import java.util.List;
import org.python.core.Py;
import org.python.core.PyNewWrapper;
import org.python.core.PyObject;
import org.python.core.PyType;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedType;
import org.python.modules.jffi.AllocatedNativeMemory;
import org.python.modules.jffi.CData;
import org.python.modules.jffi.DirectMemory;
import org.python.modules.jffi.Memory;
import org.python.modules.jffi.MemoryOp;
import org.python.modules.jffi.Pointer;
import org.python.modules.jffi.StructLayout;
import org.python.modules.jffi.Structure$PyExposer;
import org.python.modules.jffi.Util;

@ExposedType(name="jffi.Structure", base=CData.class)
public class Structure
extends CData
implements Pointer {
    public static final PyType TYPE;
    private final StructLayout layout;
    private final MemoryOp memoryOp;

    Structure(PyType pyType, StructLayout layout) {
        this(pyType, layout, (Memory)AllocatedNativeMemory.allocate(layout.size(), true));
    }

    Structure(PyType pyType, StructLayout layout, Memory m) {
        super(pyType, layout);
        this.layout = layout;
        this.memoryOp = new MemoryOp.StructOp(pyType, layout);
        this.setReferenceMemory(m);
    }

    @ExposedNew
    public static PyObject Structure_new(PyNewWrapper new_, boolean init, PyType subtype, PyObject[] args, String[] keywords) {
        StructLayout layout = Structure.getStructLayout(subtype);
        Structure s = new Structure(subtype, layout);
        if (args.length > 0) {
            StructLayout.Field f;
            int i;
            int n = args.length - keywords.length;
            List<StructLayout.Field> fields = layout.getFieldList();
            DirectMemory m = s.getMemory();
            for (i = 0; i < n; ++i) {
                f = fields.get(i);
                f.op.put(m, f.offset, args[i]);
            }
            for (i = n; i < args.length; ++i) {
                f = layout.getField(keywords[i - n]);
                f.op.put(m, f.offset, args[i]);
            }
        }
        return s;
    }

    static final StructLayout getStructLayout(PyType subtype) {
        PyObject jffi_type = subtype.__getattr__("_jffi_type");
        if (!(jffi_type instanceof StructLayout)) {
            throw Py.TypeError("invalid _jffi_type for " + subtype.fastGetName() + "; should be instance of jffi.StructLayout");
        }
        return (StructLayout)jffi_type;
    }

    public static final PyObject from_address(PyType subtype, PyObject address) {
        return new Structure(subtype, Structure.getStructLayout(subtype), (Memory)Util.getMemoryForAddress(address));
    }

    @Override
    protected final void initReferenceMemory(Memory m) {
        throw Py.RuntimeError("reference memory already initialized");
    }

    @Override
    MemoryOp getMemoryOp() {
        return this.memoryOp;
    }

    StructLayout.Field getField(PyObject key) {
        StructLayout.Field f = this.layout.getField(key);
        if (f == null) {
            throw Py.NameError(String.format("struct %s has no field '%s'", this.getType().fastGetName(), key.toString()));
        }
        return f;
    }

    @Override
    public PyObject __getitem__(PyObject key) {
        StructLayout.Field f = this.getField(key);
        return f.op.get(this.getReferenceMemory(), f.offset);
    }

    @Override
    public void __setitem__(PyObject key, PyObject value) {
        StructLayout.Field f = this.getField(key);
        f.op.put(this.getReferenceMemory(), f.offset, value);
    }

    @Override
    public DirectMemory getMemory() {
        return this.getReferenceMemory();
    }

    static {
        PyType.addBuilder(Structure.class, new Structure$PyExposer());
        TYPE = PyType.fromClass(Structure.class);
    }
}

