/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.internal.server.ui.types;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.php.internal.server.ui.Activator;
import org.eclipse.php.internal.ui.wizards.WizardFragmentsFactoryRegistry;
import org.eclipse.php.server.ui.types.IServerTypeDescriptor;
import org.eclipse.php.ui.wizards.ICompositeFragmentFactory;
import org.eclipse.swt.graphics.Image;
import org.osgi.framework.Bundle;

public class ServerTypeDescriptor
implements IServerTypeDescriptor {
    protected static final String FRAGMENT_GROUP_ID = "org.eclipse.php.server.ui.serverWizardAndComposite";
    private IConfigurationElement element;
    private String id;
    private String serverTypeId;
    private List<Fragment> wizardFragments;
    private List<Fragment> editorFragments;

    public ServerTypeDescriptor(IConfigurationElement element) {
        this.construct(element);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getServerTypeId() {
        return this.serverTypeId;
    }

    @Override
    public Image getImage(IServerTypeDescriptor.ImageType type) {
        return this.getImage(type.getAttribute());
    }

    @Override
    public ImageDescriptor getImageDescriptor(IServerTypeDescriptor.ImageType type) {
        return this.getImageDescriptor(type.getAttribute());
    }

    @Override
    public ICompositeFragmentFactory[] getWizardFragmentFactories() {
        Map factories = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        ArrayList<ICompositeFragmentFactory> result = new ArrayList<ICompositeFragmentFactory>();
        for (Fragment fragment : this.wizardFragments) {
            ICompositeFragmentFactory factory = (ICompositeFragmentFactory)factories.get(fragment.getId());
            if (factory == null) continue;
            result.add(factory);
        }
        return result.toArray(new ICompositeFragmentFactory[result.size()]);
    }

    @Override
    public ICompositeFragmentFactory[] getEditorFragmentFactories() {
        Map factories = WizardFragmentsFactoryRegistry.getFragmentsFactories((String)FRAGMENT_GROUP_ID);
        ArrayList<ICompositeFragmentFactory> result = new ArrayList<ICompositeFragmentFactory>();
        for (Fragment fragment : this.editorFragments) {
            ICompositeFragmentFactory factory = (ICompositeFragmentFactory)factories.get(fragment.getId());
            if (factory == null) continue;
            result.add(factory);
        }
        return result.toArray(new ICompositeFragmentFactory[result.size()]);
    }

    private void construct(IConfigurationElement element) {
        this.element = element;
        this.id = element.getAttribute("id");
        this.serverTypeId = element.getAttribute("serverTypeId");
        this.wizardFragments = new ArrayList<Fragment>();
        this.editorFragments = new ArrayList<Fragment>();
        IConfigurationElement[] iConfigurationElementArray = element.getChildren();
        int n = iConfigurationElementArray.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement child = iConfigurationElementArray[n2];
            if (child.getName().equals("wizard")) {
                var9_9 = child.getChildren();
                var8_8 = var9_9.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    wizardFragment = var9_9[var7_7];
                    this.wizardFragments.add(new Fragment(wizardFragment.getAttribute("id")));
                    ++var7_7;
                }
            } else if (child.getName().equals("editor")) {
                var9_9 = child.getChildren();
                var8_8 = var9_9.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    wizardFragment = var9_9[var7_7];
                    this.editorFragments.add(new Fragment(wizardFragment.getAttribute("id")));
                    ++var7_7;
                }
            }
            ++n2;
        }
    }

    private Image getImage(String name) {
        String id;
        ImageRegistry regitry = Activator.getDefault().getImageRegistry();
        Image image = regitry.get(id = this.getId() + name);
        if (image == null) {
            ImageDescriptor descriptor = this.getImageDescriptor(name);
            regitry.put(id, descriptor != null ? descriptor : ImageDescriptor.getMissingImageDescriptor());
            image = regitry.get(id);
        }
        return image;
    }

    private ImageDescriptor getImageDescriptor(String attribute) {
        Bundle bundle = Platform.getBundle((String)this.element.getContributor().getName());
        String iconPath = this.element.getAttribute(attribute);
        if (iconPath != null) {
            URL iconURL = FileLocator.find((Bundle)bundle, (IPath)new Path(iconPath), null);
            if (iconURL != null) {
                return ImageDescriptor.createFromURL((URL)iconURL);
            }
            try {
                iconURL = FileLocator.find((URL)new URL(iconPath));
                if (iconURL != null) {
                    return ImageDescriptor.createFromURL((URL)iconURL);
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    private class Fragment {
        private String id;

        Fragment(String id) {
            this.id = id;
        }

        String getId() {
            return this.id;
        }
    }
}

