/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.phpunit.model.elements;

import java.util.LinkedHashSet;
import java.util.Set;
import org.eclipse.php.internal.debug.core.zend.debugger.RemoteDebugger;
import org.eclipse.php.phpunit.model.connection.MessageTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTest;
import org.eclipse.php.phpunit.model.elements.PHPUnitTestCase;

public class PHPUnitTestGroup
extends PHPUnitTest {
    private Set<PHPUnitTest> children = null;
    private int runCount = 0;
    private final StatusCount statusCount = new StatusCount();
    private int totalCount;
    private boolean method;

    public PHPUnitTestGroup(MessageTest test, PHPUnitTestGroup parent, RemoteDebugger remoteDebugger) {
        super(test, parent, remoteDebugger);
        this.totalCount = test == null ? 0 : test.getTests();
    }

    @Override
    protected void processName(String name) {
        int cutFrom = name.indexOf("::");
        if (cutFrom > 0) {
            this.name = name.substring(cutFrom + 2);
            this.method = true;
        } else {
            this.name = name;
        }
    }

    public void addChild(PHPUnitTest test, boolean finished) {
        if (this.children == null) {
            this.children = new LinkedHashSet<PHPUnitTest>();
        }
        this.children.add(test);
        if (test instanceof PHPUnitTestCase && finished) {
            this.addRunCount(1);
        }
        this.setStatus(test.getStatus());
    }

    public void addRunCount(int count) {
        this.runCount += count;
        if (this.parent != null) {
            ((PHPUnitTestGroup)this.parent).addRunCount(count);
        }
    }

    public Set<PHPUnitTest> getChildren() {
        return this.children;
    }

    @Override
    public int getRunCount() {
        return this.runCount;
    }

    @Override
    public int getStatus() {
        return this.status;
    }

    public int getStatusCount(int status) {
        return this.statusCount.counts[status];
    }

    public int getFailedCount() {
        return this.getStatusCount(4) + this.getStatusCount(5);
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public void setParent(PHPUnitTestGroup group) {
        this.parent = group;
    }

    @Override
    public String getLocalFile() {
        if (this.isMethod() && this.parent != null) {
            return this.parent.getLocalFile();
        }
        return super.getLocalFile();
    }

    @Override
    public void setStatus(int status) {
        int n = status;
        this.statusCount.counts[n] = this.statusCount.counts[n] + 1;
        this.status = Math.max(this.status, status);
        if (this.parent != null) {
            ((PHPUnitTestGroup)this.parent).setStatus(status);
        }
    }

    public boolean isMethod() {
        return this.method;
    }

    public String getSuiteName() {
        if (this.getLocalFile() == null) {
            return this.getName();
        }
        return null;
    }

    @Override
    public String getFilterName() {
        if (this.getLocalFile() == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.getName());
        if (this.method) {
            sb.insert(0, "::").insert(0, ((PHPUnitTestGroup)this.parent).getName()).append(" .*");
        } else {
            sb.append("::").append(".*");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        String result = this.getSuiteName();
        if (result == null) {
            result = this.getFilterName();
        }
        return result;
    }

    private class StatusCount {
        public int[] counts = new int[6];

        private StatusCount() {
        }
    }
}

