/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.php.refactoring.core.rename;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.ltk.core.refactoring.participants.RefactoringProcessor;
import org.eclipse.php.core.ast.nodes.Program;
import org.eclipse.php.core.tests.TestUtils;
import org.eclipse.php.refactoring.core.rename.RenameFileProcessor;
import org.eclipse.php.refactoring.core.test.AbstractRefactoringTest;
import org.eclipse.php.refactoring.core.test.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class RenameFileTestCase0029095
extends AbstractRefactoringTest {
    private IProject project1;
    private IFile file;
    private IFile file1;

    @Before
    public void setUp() throws Exception {
        this.project1 = TestUtils.createProject((String)"project1");
        this.file = TestUtils.createFile((IProject)this.project1, (String)"RenameFile0029095.php", (String)"<?php class TestRenameClass{}?>");
        this.file1 = TestUtils.createFile((IProject)this.project1, (String)"RenameFile0029095_2.php", (String)"<?php include 'RenameFile0029095.php'; echo 'RenameFile0029095.php test rename RenameFile0029095.php';?>");
        TestUtils.waitForIndexer();
    }

    @Test
    public void testRename() throws Exception {
        Program program = this.createProgram(this.file);
        Assert.assertNotNull((Object)program);
        RenameFileProcessor processor = new RenameFileProcessor((IResource)this.file, program);
        processor.setNewElementName("RenameFile00290951.php");
        processor.setUpdateRefernces(true);
        processor.setUpdateTextualMatches(true);
        this.checkInitCondition((RefactoringProcessor)processor);
        this.performChange((RefactoringProcessor)processor);
        IFile file = this.project1.getFile("RenameFile00290951.php");
        Assert.assertNotNull((Object)file);
        Assert.assertTrue((boolean)file.exists());
        try {
            String content = FileUtils.getContents(this.file1);
            Assert.assertEquals((Object)"<?php include 'RenameFile00290951.php'; echo 'RenameFile00290951.php test rename RenameFile00290951.php';?>", (Object)content);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @After
    public void tearDown() throws Exception {
        this.project1.delete(1, (IProgressMonitor)new NullProgressMonitor());
    }
}

