/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.internal.ui.refactoring.includes;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.cdt.internal.corext.codemanipulation.IncludeInfo;
import org.eclipse.cdt.internal.ui.refactoring.includes.IncludeMap;
import org.eclipse.cdt.ui.CUIPlugin;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.WorkbenchException;
import org.eclipse.ui.XMLMemento;

public class HeaderSubstitutionMap {
    private static final String TAG_HEADER_SUBSTITUTION_MAPS = "maps";
    private static final String TAG_HEADER_SUBSTITUTION_MAP = "map";
    private static final String TAG_NAME = "name";
    private static final String TAG_CPP_ONLY = "cpp_only";
    private static final String TAG_UNCONDITIONAL_SUBSTITUTION_MAP = "unconditional_substitution_map";
    private static final String TAG_OPTIONAL_SUBSTITUTION_MAP = "optional_substitution_map";
    private String name;
    private boolean cppOnly;
    private final IncludeMap unconditionalSubstitutionMap;
    private final IncludeMap optionalSubstitutionMap;

    public HeaderSubstitutionMap(boolean cppOnly) {
        this.cppOnly = cppOnly;
        this.unconditionalSubstitutionMap = new IncludeMap(true);
        this.optionalSubstitutionMap = new IncludeMap(false);
    }

    public HeaderSubstitutionMap(String name, boolean cppOnly, IncludeMap unconditionalSubstitutionMap, IncludeMap optionalSubstitutionMap) {
        this.name = name;
        this.cppOnly = cppOnly;
        this.unconditionalSubstitutionMap = unconditionalSubstitutionMap;
        this.optionalSubstitutionMap = optionalSubstitutionMap;
    }

    protected void addMapping(IncludeInfo from, IncludeInfo to, boolean unconditionalSubstitution) {
        IncludeMap map = unconditionalSubstitution ? this.unconditionalSubstitutionMap : this.optionalSubstitutionMap;
        map.addMapping(from, to);
    }

    public void addMapping(String from, String to, boolean unconditionalSubstitution) {
        IncludeMap map = unconditionalSubstitution ? this.unconditionalSubstitutionMap : this.optionalSubstitutionMap;
        map.addMapping(from, to);
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isCppOnly() {
        return this.cppOnly;
    }

    public void setCppOnly(boolean cppOnly) {
        this.cppOnly = cppOnly;
    }

    public void saveToMemento(IMemento memento) {
        if (this.name != null) {
            memento.putString(TAG_NAME, this.name);
        }
        memento.putBoolean(TAG_CPP_ONLY, this.cppOnly);
        this.unconditionalSubstitutionMap.saveToMemento(memento.createChild(TAG_UNCONDITIONAL_SUBSTITUTION_MAP));
        this.optionalSubstitutionMap.saveToMemento(memento.createChild(TAG_OPTIONAL_SUBSTITUTION_MAP));
    }

    public static HeaderSubstitutionMap fromMemento(IMemento memento) {
        String name = memento.getString(TAG_NAME);
        Boolean b = memento.getBoolean(TAG_CPP_ONLY);
        boolean cppOnly = b != null && b != false;
        IncludeMap unconditionalSubstitutionMap = IncludeMap.fromMemento(true, memento.getChild(TAG_UNCONDITIONAL_SUBSTITUTION_MAP));
        IncludeMap optionalSubstitutionMap = IncludeMap.fromMemento(false, memento.getChild(TAG_OPTIONAL_SUBSTITUTION_MAP));
        for (IncludeInfo header : unconditionalSubstitutionMap.getMap().keySet()) {
            optionalSubstitutionMap.removeMapping(header);
        }
        return new HeaderSubstitutionMap(name, cppOnly, unconditionalSubstitutionMap, optionalSubstitutionMap);
    }

    public static HeaderSubstitutionMap fromSerializedMemento(String str) {
        return HeaderSubstitutionMap.fromSerializedMemento(new StringReader(str));
    }

    public static HeaderSubstitutionMap fromSerializedMemento(Reader reader) {
        XMLMemento memento;
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            return null;
        }
        return HeaderSubstitutionMap.fromMemento((IMemento)memento);
    }

    public static String serializeMaps(List<HeaderSubstitutionMap> maps) {
        XMLMemento memento = XMLMemento.createWriteRoot((String)TAG_HEADER_SUBSTITUTION_MAPS);
        for (HeaderSubstitutionMap element : maps) {
            element.saveToMemento(memento.createChild(TAG_HEADER_SUBSTITUTION_MAP));
        }
        StringWriter writer = new StringWriter();
        try {
            memento.save((Writer)writer);
        }
        catch (IOException e) {
            CUIPlugin.log(e);
        }
        return writer.toString();
    }

    public static List<HeaderSubstitutionMap> deserializeMaps(String str) {
        XMLMemento memento;
        StringReader reader = new StringReader(str);
        try {
            memento = XMLMemento.createReadRoot((Reader)reader);
        }
        catch (WorkbenchException e) {
            return Collections.emptyList();
        }
        ArrayList<HeaderSubstitutionMap> maps = new ArrayList<HeaderSubstitutionMap>();
        IMemento[] iMementoArray = memento.getChildren(TAG_HEADER_SUBSTITUTION_MAP);
        int n = iMementoArray.length;
        int n2 = 0;
        while (n2 < n) {
            IMemento element = iMementoArray[n2];
            maps.add(HeaderSubstitutionMap.fromMemento(element));
            ++n2;
        }
        return maps;
    }

    public IncludeMap getUnconditionalSubstitutionMap() {
        return this.unconditionalSubstitutionMap;
    }

    public IncludeMap getOptionalSubstitutionMap() {
        return this.optionalSubstitutionMap;
    }
}

