/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.make.internal.ui.text;

import org.eclipse.cdt.make.internal.core.makefile.gnu.GNUMakefileUtil;
import org.eclipse.cdt.make.internal.ui.MakeUIPlugin;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;

public class WordPartDetector {
    private IDocument document;
    private int offset;
    private String wordPart = "";
    private WORDPART_TYPE type = WORDPART_TYPE.UNDETERMINED;

    public WordPartDetector(IDocument doc, int documentOffset) {
        char c;
        this.document = doc;
        this.offset = documentOffset - 1;
        int endOffset = documentOffset;
        try {
            IRegion region = doc.getLineInformationOfOffset(documentOffset);
            int top = region.getOffset();
            int bottom = region.getLength() + top;
            while (this.offset >= top && this.isMakefileLetter(doc.getChar(this.offset))) {
                --this.offset;
            }
            while (endOffset < bottom && this.isMakefileLetter(doc.getChar(endOffset))) {
                ++endOffset;
            }
            ++this.offset;
            this.wordPart = doc.get(this.offset, endOffset - this.offset);
        }
        catch (BadLocationException e) {
            MakeUIPlugin.log(e);
        }
        try {
            int index = this.offset - 1;
            while (index >= 0) {
                c = this.document.getChar(index);
                if (c == '$') {
                    this.type = WORDPART_TYPE.MACRO;
                    int index2 = index + 1;
                    if (index2 < doc.getLength()) {
                        c = this.document.getChar(index2);
                        this.wordPart = doc.get(index2, endOffset - index2);
                    }
                    return;
                }
                if (!Character.isWhitespace(c) && c != ')' && c != '}') {
                    --index;
                    continue;
                }
                break;
            }
        }
        catch (BadLocationException e) {
            MakeUIPlugin.log(e);
        }
        try {
            int index = this.offset - 1;
            while (index > 0) {
                c = this.document.getChar(index);
                if (!Character.isJavaIdentifierPart(c) && c != '-' && c != ' ') {
                    String builtinFun;
                    boolean isFunction;
                    boolean bl = isFunction = (c == '(' || c == '{') && this.document.getChar(index - 1) == '$';
                    if (isFunction && (builtinFun = this.document.get(index + 1, 4)).equals("call")) {
                        this.type = WORDPART_TYPE.FUNCTION_CALL;
                        int nameOffset = index + 2 + "call".length();
                        int endIndex = this.offset;
                        endIndex = this.offset;
                        while (endIndex < this.document.getLength()) {
                            char c2 = this.document.getChar(endIndex);
                            if (!Character.isJavaIdentifierPart(c2) && c2 != '-') break;
                            ++endIndex;
                        }
                        this.wordPart = this.document.get(nameOffset, endIndex - nameOffset);
                        return;
                    }
                    break;
                }
                --index;
            }
        }
        catch (BadLocationException e) {
            MakeUIPlugin.log(e);
        }
        try {
            int lineNumber = this.document.getLineOfOffset(this.offset);
            String line = this.document.get(this.document.getLineOffset(lineNumber), this.document.getLineLength(lineNumber));
            if (GNUMakefileUtil.isInclude((String)line)) {
                String sub;
                this.type = WORDPART_TYPE.INCLUDE;
                int lineOffset = this.document.getLineOffset(lineNumber);
                int position = this.offset - lineOffset;
                String before = line.substring(0, position);
                this.wordPart = !(before + ".").trim().contains(" ") ? ((sub = line.substring(line.indexOf(32, position)).trim()).contains(" ") ? sub.substring(0, sub.indexOf(32)).trim() : sub) : WordPartDetector.findWord(line, position);
                return;
            }
        }
        catch (BadLocationException e) {
            MakeUIPlugin.log(e);
        }
    }

    public boolean isMacro() {
        return this.type == WORDPART_TYPE.MACRO;
    }

    public boolean isFunctionCall() {
        return this.type == WORDPART_TYPE.FUNCTION_CALL;
    }

    public boolean isIncludeDirective() {
        return this.type == WORDPART_TYPE.INCLUDE;
    }

    private static String findWord(String line, int position) {
        String secondHalf;
        String firstHalf;
        try {
            firstHalf = line.substring(0, position);
        }
        catch (IndexOutOfBoundsException e) {
            firstHalf = line;
        }
        try {
            secondHalf = line.substring(position);
        }
        catch (IndexOutOfBoundsException e) {
            secondHalf = "";
        }
        int startIndex = firstHalf.lastIndexOf(32) + 1;
        int firstHalfLen = firstHalf.length();
        int endIndex = firstHalfLen + secondHalf.indexOf(32);
        if (endIndex < firstHalfLen) {
            endIndex = line.length();
        }
        String word = line.substring(startIndex, endIndex).trim();
        return word;
    }

    public String toString() {
        return this.wordPart;
    }

    public String getName() {
        return this.wordPart;
    }

    public int getOffset() {
        return this.offset;
    }

    private boolean isMakefileLetter(char c) {
        return Character.isLetterOrDigit(c) || "_-.@%<?^+|*".indexOf(c) >= 0;
    }

    private static enum WORDPART_TYPE {
        MACRO,
        FUNCTION_CALL,
        INCLUDE,
        UNDETERMINED;

    }
}

