/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.cdt.ui.templateengine.processes;

import org.eclipse.cdt.core.templateengine.TemplateCore;
import org.eclipse.cdt.core.templateengine.process.ProcessArgument;
import org.eclipse.cdt.core.templateengine.process.ProcessFailureException;
import org.eclipse.cdt.core.templateengine.process.ProcessRunner;
import org.eclipse.cdt.ui.templateengine.processes.Messages;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

public class OpenFiles
extends ProcessRunner {
    public void process(TemplateCore template, ProcessArgument[] args, String processId, IProgressMonitor monitor) throws ProcessFailureException {
        ProcessArgument[][] files;
        ProcessArgument[][] processArgumentArray = files = args[1].getComplexArrayValue();
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessArgument[] file = processArgumentArray[n2];
            String fileTargetPath = file[0].getSimpleValue();
            String projectName = args[0].getSimpleValue();
            IProject projectHandle = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
            IFile iFile = projectHandle.getFile(fileTargetPath);
            if (iFile.exists()) {
                if (!this.isOpen(iFile)) {
                    try {
                        IDE.openEditor((IWorkbenchPage)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IFile)iFile);
                    }
                    catch (PartInitException e) {
                        throw new ProcessFailureException(Messages.OpenFiles_CannotOpen_error + fileTargetPath);
                    }
                }
            } else {
                throw new ProcessFailureException(Messages.OpenFiles_FileNotExist_error + fileTargetPath);
            }
            ++n2;
        }
    }

    private boolean isOpen(IFile file) {
        IEditorReference[] editorReferences = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getEditorReferences();
        if (editorReferences != null) {
            IEditorReference[] iEditorReferenceArray = editorReferences;
            int n = editorReferences.length;
            int n2 = 0;
            while (n2 < n) {
                IEditorReference editorReference = iEditorReferenceArray[n2];
                try {
                    IEditorInput editorInput = editorReference.getEditorInput();
                    if (editorInput instanceof IFileEditorInput && file.equals((Object)((IFileEditorInput)editorInput).getFile())) {
                        return true;
                    }
                }
                catch (PartInitException partInitException) {
                    // empty catch block
                }
                ++n2;
            }
        }
        return false;
    }
}

