/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tm.terminal.connector.cdtserial.controls;

import java.io.IOException;
import org.eclipse.cdt.serial.ByteSize;
import org.eclipse.cdt.serial.Parity;
import org.eclipse.cdt.serial.SerialPort;
import org.eclipse.cdt.serial.StandardBaudRates;
import org.eclipse.cdt.serial.StopBits;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.terminal.connector.AbstractSettingsPage;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanel;
import org.eclipse.terminal.view.ui.launcher.IConfigurationPanelContainer;
import org.eclipse.tm.terminal.connector.cdtserial.activator.Activator;
import org.eclipse.tm.terminal.connector.cdtserial.connector.SerialConnector;
import org.eclipse.tm.terminal.connector.cdtserial.connector.SerialSettings;
import org.eclipse.tm.terminal.connector.cdtserial.nls.Messages;

public class SerialSettingsPage
extends AbstractSettingsPage {
    private final SerialSettings settings;
    private final IConfigurationPanel panel;
    private final IDialogSettings dialogSettings;
    private Combo portCombo;
    private Combo baudRateCombo;
    private Combo byteSizeCombo;
    private Combo parityCombo;
    private Combo stopBitsCombo;
    private String portName;
    private int baudRate;
    private ByteSize byteSize;
    private Parity parity;
    private StopBits stopBits;

    public SerialSettingsPage(SerialSettings settings, IConfigurationPanel panel) {
        String byteSizeStr;
        this.settings = settings;
        this.panel = panel;
        this.setHasControlDecoration(true);
        this.dialogSettings = DialogSettings.getOrCreateSection((IDialogSettings)Activator.getDefault().getDialogSettings(), (String)((Object)((Object)this)).getClass().getSimpleName());
        this.portName = this.dialogSettings.get("cdtserial.portName");
        String baudRateStr = this.dialogSettings.get("cdtserial.baudRate");
        if (baudRateStr != null && !baudRateStr.isEmpty()) {
            try {
                this.baudRate = Integer.parseInt(baudRateStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.baudRate <= 0) {
            this.baudRate = StandardBaudRates.getDefault();
        }
        if ((byteSizeStr = this.dialogSettings.get("cdtserial.byteSize")) == null || byteSizeStr.isEmpty()) {
            this.byteSize = ByteSize.getDefault();
        } else {
            String[] sizes = ByteSize.getStrings();
            int i = 0;
            while (i < sizes.length) {
                if (byteSizeStr.equals(sizes[i])) {
                    this.byteSize = ByteSize.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String parityStr = this.dialogSettings.get("cdtserial.parity");
        if (parityStr == null || parityStr.isEmpty()) {
            this.parity = Parity.getDefault();
        } else {
            String[] parities = Parity.getStrings();
            int i = 0;
            while (i < parities.length) {
                if (parityStr.equals(parities[i])) {
                    this.parity = Parity.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
        String stopBitsStr = this.dialogSettings.get("cdtserial.stopBits");
        if (stopBitsStr == null || stopBitsStr.isEmpty()) {
            this.stopBits = StopBits.getDefault();
        } else {
            String[] bits = StopBits.getStrings();
            int i = 0;
            while (i < bits.length) {
                if (stopBitsStr.equals(bits[i])) {
                    this.stopBits = StopBits.fromStringIndex((int)i);
                    break;
                }
                ++i;
            }
        }
    }

    public void createControl(Composite parent) {
        Composite comp = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(2, false);
        gridLayout.marginHeight = 0;
        gridLayout.marginWidth = 0;
        GridData gridData = new GridData(768);
        comp.setLayout((Layout)gridLayout);
        comp.setLayoutData((Object)gridData);
        Label portLabel = new Label(comp, 0);
        portLabel.setText(Messages.SerialTerminalSettingsPage_SerialPort);
        this.portCombo = new Combo(comp, 0);
        this.portCombo.setLayoutData((Object)new GridData(768));
        String[] portNames = new String[]{};
        try {
            portNames = SerialPort.list();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        String[] stringArray = portNames;
        int n = portNames.length;
        int n2 = 0;
        while (n2 < n) {
            String portName = stringArray[n2];
            if (!SerialConnector.isOpen(portName)) {
                this.portCombo.add(portName);
            }
            ++n2;
        }
        this.portCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SerialSettingsPage.this.validate();
            }
        });
        Label baudRateLabel = new Label(comp, 0);
        baudRateLabel.setText(Messages.SerialTerminalSettingsPage_BaudRate);
        this.baudRateCombo = new Combo(comp, 4);
        this.baudRateCombo.setLayoutData((Object)new GridData(768));
        this.baudRateCombo.setItems(StandardBaudRates.asStringArray());
        Label byteSizeLabel = new Label(comp, 0);
        byteSizeLabel.setText(Messages.SerialTerminalSettingsPage_DataSize);
        this.byteSizeCombo = new Combo(comp, 8);
        this.byteSizeCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray2 = ByteSize.getStrings();
        int n3 = stringArray2.length;
        int n4 = 0;
        while (n4 < n3) {
            String byteSizeStr = stringArray2[n4];
            this.byteSizeCombo.add(byteSizeStr);
            ++n4;
        }
        Label parityLabel = new Label(comp, 0);
        parityLabel.setText(Messages.SerialTerminalSettingsPage_Parity);
        this.parityCombo = new Combo(comp, 8);
        this.parityCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray3 = Parity.getStrings();
        int n5 = stringArray3.length;
        n3 = 0;
        while (n3 < n5) {
            String parityStr = stringArray3[n3];
            this.parityCombo.add(parityStr);
            ++n3;
        }
        Label stopBitsLabel = new Label(comp, 0);
        stopBitsLabel.setText(Messages.SerialTerminalSettingsPage_StopBits);
        this.stopBitsCombo = new Combo(comp, 8);
        this.stopBitsCombo.setLayoutData((Object)new GridData(768));
        String[] stringArray4 = StopBits.getStrings();
        int n6 = stringArray4.length;
        n5 = 0;
        while (n5 < n6) {
            String stopBitsStr = stringArray4[n5];
            this.stopBitsCombo.add(stopBitsStr);
            ++n5;
        }
        this.loadSettings();
    }

    void validate() {
        IConfigurationPanelContainer container = this.panel.getContainer();
        container.validate();
    }

    public void loadSettings() {
        String portName = this.settings.getPortName();
        if (portName == null || portName.isEmpty()) {
            portName = this.portName;
        }
        if (portName != null && !portName.isEmpty() && !SerialConnector.isOpen(portName)) {
            int i = 0;
            String[] stringArray = this.portCombo.getItems();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String name = stringArray[n2];
                if (portName.equals(name)) {
                    this.portCombo.select(i);
                    break;
                }
                ++i;
                ++n2;
            }
        } else if (this.portCombo.getItemCount() > 0) {
            this.portCombo.select(0);
        }
        int baudRate = this.settings.getBaudRateValue();
        if (baudRate <= 0) {
            baudRate = this.baudRate;
        }
        this.baudRateCombo.setText(Integer.toString(baudRate));
        ByteSize byteSize = this.settings.getByteSize();
        if (byteSize == null) {
            byteSize = this.byteSize;
        }
        this.byteSizeCombo.select(ByteSize.getStringIndex((ByteSize)byteSize));
        Parity parity = this.settings.getParity();
        if (parity == null) {
            parity = this.parity;
        }
        this.parityCombo.select(Parity.getStringIndex((Parity)parity));
        StopBits stopBits = this.settings.getStopBits();
        if (stopBits == null) {
            stopBits = this.stopBits;
        }
        this.stopBitsCombo.select(StopBits.getStringIndex((StopBits)stopBits));
    }

    public void saveSettings() {
        this.settings.setPortName(this.portCombo.getText());
        int baudRateValue = 0;
        try {
            baudRateValue = Integer.parseInt(this.baudRateCombo.getText());
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (baudRateValue <= 0) {
            baudRateValue = StandardBaudRates.getDefault();
        }
        this.settings.setBaudRateValue(baudRateValue);
        this.settings.setByteSize(ByteSize.fromStringIndex((int)this.byteSizeCombo.getSelectionIndex()));
        this.settings.setParity(Parity.fromStringIndex((int)this.parityCombo.getSelectionIndex()));
        this.settings.setStopBits(StopBits.fromStringIndex((int)this.stopBitsCombo.getSelectionIndex()));
        this.dialogSettings.put("cdtserial.portName", this.portCombo.getText());
        this.dialogSettings.put("cdtserial.baudRate", Integer.toString(baudRateValue));
        this.dialogSettings.put("cdtserial.byteSize", ByteSize.getStrings()[this.byteSizeCombo.getSelectionIndex()]);
        this.dialogSettings.put("cdtserial.parity", Parity.getStrings()[this.parityCombo.getSelectionIndex()]);
        this.dialogSettings.put("cdtserial.stopBits", StopBits.getStrings()[this.stopBitsCombo.getSelectionIndex()]);
    }

    public boolean validateSettings() {
        return this.portCombo.getSelectionIndex() >= 0 || !this.portCombo.getText().isEmpty();
    }
}

